<?php
require_once 'iadmin/inc/db.php';
require_once 'models/ProductDetailModel.php';

$productSlug = $_GET[ 'product' ] ?? '';
$model = new ProductDetailModel( $conn );
$product = $model->getProductBySlug( $productSlug );

include( "assets/inc/template.php" ); // Load common layout (includes <body> & header/footer)

function main() {
	global $product;
	?>

<script type="module" src="https://unpkg.com/@google/model-viewer/dist/model-viewer.min.js"></script>

	<link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
	<main>

		<!-- breadcrumb area start -->
		<section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
			<div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
			<div class="container">
				<div class="row">
					<div class="col-xxl-6 col-xl-8 col-lg-8">
						<div class="rs-breadcrumb-content-wrapper">
							<div class="rs-breadcrumb-title-wrapper">
								<h1 class="rs-breadcrumb-title">Product Details</h1>
							</div>
							<div class="rs-breadcrumb-menu">
								<nav>
									<ul>
										<li><span><a href="index.php">Home</a></span>
										</li>
										<li><span><a href="products.php?category=<?= htmlspecialchars($product['category_slug']) ?>"><?= ucwords(htmlspecialchars($product['category_name'])) ?>
</a></span>
										</li>
										<li>
											<span>
												<?= ucwords(htmlspecialchars($product['subcat_name'])) ?>
											</span>
										</li>
									</ul>
								</nav>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- breadcrumb area end -->

		
		<!-- shop area start -->
		<section class="rs-shop-area section-space">
			<div class="container">
				<style>
    .product-details-thumb img {
        width: 100%;
        height: auto;
        object-fit: contain;
        border-radius: 10px;
    }
    .product-details-slider-dot .swiper-slide {
        width: auto;
        margin-right: 10px;
    }
    .custom-button img {
        width: 70px;
        height: 70px;
        object-fit: cover;
        border: 2px solid #ddd;
        border-radius: 8px;
        transition: all 0.3s;
    }
    .custom-button:hover img {
        border-color: #0d6efd;
        transform: scale(1.05);
    }
    .play-icon {
        position: absolute;
        bottom: 5px;
        right: 5px;
        font-size: 20px;
    }
    .modal-content {
        border-radius: 12px;
    }
    model-viewer {
        border-radius: 10px;
        background: #f9f9f9;
    }
    .product-details-title {
        font-size: 28px;
        font-weight: 600;
        color: #333;
    }
    .product-details-categories a {
        text-decoration: none;
        color: #0d6efd;
    }
</style>

<div class="row align-items-center g-5 py-5">
    <!-- Left: Product Image + Thumbs -->
    <div class="col-md-6">
        <div class="product-details-thumb-wrap">
            <!-- Main Swiper -->
            <div class="product-details-thumb-top mb-3">
                <div class="swiper product-details-active position-relative">
                    <div class="swiper-wrapper">
                        <!-- Image Slide -->
                        <div class="swiper-slide">
                            <div class="product-details-thumb">
                                <img src="assets/images/ss-panel-lock-rls41-diagram.jpg" alt="Main Image">
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="product-details-thumb">
                                <img src="assets/images/ss-panel-lock-rls41.png" alt="Second Image">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Thumbnail Navigation -->
            <div class="product-details-thumb-bottom">
                <div class="product-details-slider-dot">
                    <div class="swiper product-details-nav d-flex align-items-center">
                        <div class="swiper-slide">
                            <button class="custom-button">
                                <img src="assets/images/ss-panel-lock-rls41-diagram.jpg" alt="Thumb 1">
                            </button>
                        </div>
                        <div class="swiper-slide">
                            <button class="custom-button">
                                <img src="assets/images/ss-panel-lock-rls41.png" alt="Thumb 2">
                            </button>
                        </div>
                        <!-- Video Thumb -->
                        <div class="swiper-slide">
                            <div class="rs-about-btn">
                                <a href="https://www.youtube.com/watch?v=Yue48fUXuqI" class="rs-play-btn popup-video btn btn-outline-dark rounded-circle">
                                    <i class="ri-play-fill fs-4"></i>
                                </a>
                            </div>
                        </div>
                        <!-- 3D Viewer Thumb -->
                        <div class="swiper-slide">
                            <button class="custom-button position-relative" data-bs-toggle="modal" data-bs-target="#threeDModal">
                                <img src="assets/images/3d-icon.jpg" alt="3D View">
                                <span class="play-icon">&#128064;</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Right: Product Info -->
    <div class="col-md-6">
        <div class="product-details-wrapper shop-details">
            <h3 class="product-details-title mb-3">
                <?= ucwords(htmlspecialchars($product['subcat_name'])) ?>
            </h3>

            <p class="mb-3 text-muted">Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur...</p>
            <p class="mb-4 text-muted">Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur...</p>

            <!-- Product Details Table -->
            <div class="table-responsive mb-4">
                <table class="table table-bordered table-hover text-center shadow rounded">
                    <thead class="table-light">
                        <tr>
                            <th>Model</th>
                            <th>Material</th>
                            <th>Finish</th>
                            <th>Size</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>RLS41</td>
                            <td>Stainless Steel</td>
                            <td>Matt</td>
                            <td>40x60 mm</td>
                        </tr>
                        <tr>
                            <td>RLS42</td>
                            <td>Zinc Alloy</td>
                            <td>Chrome</td>
                            <td>45x65 mm</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Download Button -->
            <div class="mb-4">
                <a href="#" class="btn btn-outline-danger d-inline-flex align-items-center gap-2 px-4 py-2">
                    <img src="assets/images/icon/pdf.svg" alt="PDF" style="width: 20px;">
                    Download PDF
                </a>
            </div>

            <!-- Categories -->
            <div class="product-details-categories mb-3">
                <p class="mb-1 fw-semibold">Category:</p>
                <span class="badge bg-primary-subtle text-primary px-3 py-2">
                    <a href="products.php?category=<?= htmlspecialchars($product['category_slug']) ?>">
                        <?= ucwords(htmlspecialchars($product['category_name'])) ?>
                    </a>
                </span>
            </div>
        </div>
    </div>
</div>

<!-- 3D Viewer Modal -->
<div class="modal fade" id="threeDModal" tabindex="-1" aria-labelledby="threeDModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">3D Product View</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <model-viewer src="https://modelviewer.dev/shared-assets/models/Astronaut.glb"
                              alt="3D model"
                              auto-rotate
                              camera-controls
                              ar
                              style="width: 100%; height: 600px;">
                </model-viewer>
            </div>
        </div>
    </div>
</div>
				<div class="product-information mt-50">
					<div class="row g-5 justify-content-center">
						<div class="col-xxl-12 col-xl-12 col-lg-12">
							<div class="product-information-tab">
								<ul class="nav nav-pills mb-35 flex-wrap gap-10 has-border" id="pills-tab" role="tablist">
									<li class="nav-item" role="presentation">
										<button class="nav-link active" id="pills-information-tab" data-bs-toggle="pill" data-bs-target="#pills-information" type="button" role="tab" aria-controls="pills-information" aria-selected="true">Description</button>
									</li>
									<li class="nav-item" role="presentation">
										<button class="nav-link" id="pills-review-tab" data-bs-toggle="pill" data-bs-target="#pills-review" type="button" role="tab" aria-controls="pills-review" aria-selected="false">Review (02)</button>
									</li>
								</ul>
								<div class="tab-content" id="pills-tabContent">
									<div class="tab-pane fade show active" id="pills-information" role="tabpanel" aria-labelledby="pills-information-tab" tabindex="0">
										<div class="information-wrapper">
											<p>It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using ‘Content here, content here’, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for ‘lorem ipsum’ will uncover many web sites still in their infancy. vel illum qui dolorem eum fugiat quo voluptas nulla pariatur</p>

										</div>
									</div>

									<div class="tab-pane fade" id="pills-review" role="tabpanel" aria-labelledby="pills-review-tab" tabindex="0">
										<div class="product-details-reviews-wrapper">
											<div class="product-details-review-list">
												<div class="product-review-item">
													<div class="product-review-avater">
														<div class="product-review-avater-thumb">
															<img src="assets/images/user/user-thumb-01.png" alt="image">
														</div>
														<div class="product-review-avater-info">
															<h6 class="product-review-avater-title">John Miller</h6>
														</div>
													</div>
													<div class="product-review-rating d-flex align-items-center mt-15 mb-15">
														<div class="product-rating rating-color d-flex">
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
														</div>
														<div class="product-review-rating-date">
															<span>April 10, 2024</span>
														</div>
													</div>
													<p>Podcasting operational change management inside of workflows to establish a framework Taking seamless key performance indicators.</p>
												</div>
												<div class="product-review-item">
													<div class="product-review-avater">
														<div class="product-review-avater-thumb">
															<img src="assets/images/user/user-thumb-02.png" alt="image">
														</div>
														<div class="product-review-avater-info">
															<h6 class="product-review-avater-title">Joshua Sendu</h6>
														</div>
													</div>
													<div class="product-review-rating d-flex align-items-center mt-15 mb-15">
														<div class="product-rating rating-color d-flex">
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
														</div>
														<div class="product-review-rating-date">
															<span>Feb 2, 2025</span>
														</div>
													</div>
													<p>Podcasting operational change management inside of workflows to establish a framework Taking seamless key performance indicators.</p>
												</div>
											</div>
										</div>
										<div class="product-review-form">
											<h5 class="product-review-form-title">Add a review</h5>
											<p>Your email address will not be published. Required fields are marked *</p>
											<form action="#">
												<div class="product-review-form-rating  mb-25">
													<h5 class="rate-title">Rate this product:</h5>
													<div class="product-review-rating-wrapper d-flex">
														<span>
                                             <i class="icon_star"></i>
                                          </span>
													
														<span>
                                             <i class="icon_star"></i>
                                          </span>
													
														<span>
                                             <i class="icon_star"></i>
                                          </span>
													
														<span>
                                             <i class="icon_star"></i>
                                          </span>
													
														<span>
                                             <i class="icon_star_alt"></i>
                                          </span>
													
													</div>
												</div>
												<div class="row g-5">
													<div class="col-lg-6">
														<div class="product-review-input">
															<input type="text" placeholder="Name">
														</div>
													</div>
													<div class="col-lg-6">
														<div class="product-review-input">
															<input type="email" placeholder="Email">
														</div>
													</div>
													<div class="col-lg-12">
														<div class="product-review-input is-textarea">
															<textarea placeholder="Your Review Here..."></textarea>
														</div>
													</div>
													<div class="col-lg-12">
														<div class="product-review-btn">
															<button class="rs-btn has-theme-orange" type="submit">Submit Review</button>
														</div>
													</div>
												</div>
											</form>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<hr><br>
		<section class="rs-elements-services-area section-space-bottom rs-services-eight rs-swiper has-theme-blue">
			<div class="container">

				<div class="row align-items-center g-5 section-title-space">
					<div class="col-xl-7 col-lg-7">
						<div class="rs-section-title-wrapper">

							<h4 class="mb-30">Related products</h4>
						</div>
					</div>
					<div class="col-xl-5 col-lg-5">

						<div class="rs-services-navigation">
							<button class="swiper-button-prev rs-swiper-btn has-theme-yellow"><i
                           class="fa-regular fa-arrow-left"></i></button>
							<button class="swiper-button-next rs-swiper-btn has-theme-yellow"><i
                           class="fa-regular fa-arrow-right"></i></button>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="rs-services-slide-wrapper">
						<div class="swiper" data-clone-slides="false" data-loop="false" data-speed="1500" data-autoplay="true" data-dots-dynamic="false" data-hover-pause="true" data-effect="false" data-delay="1000" data-item="4" data-item-xl="3" data-item-lg="3" data-item-md="2" data-item-sm="1" data-item-xs="1" data-item-mobile="1" data-margin="30">
							<div class="swiper-wrapper process-counts">
								<div class="swiper-slide">
									<div class="rs-services-item">
										<div class="rs-services-thumb">
											<a href="services-details.html"> <img src="assets/images/services/services-thumb-21.png" alt="image"></a>
										</div>
										<div class="rs-services-content">
											<h5 class="rs-services-title"><a href="services-details.html"> Best innovations in
                                                    metallurgy</a></h5>
											<p class="descrip"> Consectetur ipiscing elit tellus ullam corper mattis </p>
											<div class="rs-services-number"></div>
											<div class="rs-services-btn-wrapper">
												<div class="rs-services-text-btn underline has-theme-yellow">
													<a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
												</div>
												<a class="rs-square-btn has-icon has-light-bg" href="services-details.html">
                                                    <span class="icon-box">
                                          <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                          <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                       </span>
                                                </a>
											
											</div>
										</div>
									</div>
								</div>
								<div class="swiper-slide">
									<div class="rs-services-item">
										<div class="rs-services-thumb">
											<a href="services-details.html"> <img src="assets/images/services/services-thumb-22.png" alt="image"></a>
										</div>
										<div class="rs-services-content">
											<h5 class="rs-services-title"><a href="services-details.html"> Manufacturer of tin lead
                                                    and lead...</a></h5>
											<p class="descrip"> Making this true first generator think on the Internet </p>
											<div class="rs-services-number"></div>
											<div class="rs-services-btn-wrapper">
												<div class="rs-services-text-btn underline has-theme-yellow">
													<a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
												</div>
												<a class="rs-square-btn has-icon has-light-bg" href="services-details.html">
                                                    <span class="icon-box">
                                          <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                          <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                       </span>
                                                </a>
											
											</div>
										</div>
									</div>
								</div>
								<div class="swiper-slide">
									<div class="rs-services-item">
										<div class="rs-services-thumb">
											<a href="services-details.html"> <img src="assets/images/services/services-thumb-23.png" alt="image"></a>
										</div>
										<div class="rs-services-content">
											<h5 class="rs-services-title"><a href="services-details.html"> State of the art for
                                                    hight control in... </a></h5>
											<p class="descrip"> With our vast experience &amp; knowledge in this field.</p>
											<div class="rs-services-number"></div>
											<div class="rs-services-btn-wrapper">
												<div class="rs-services-text-btn underline has-theme-yellow">
													<a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
												</div>
												<a class="rs-square-btn has-icon has-light-bg" href="services-details.html">
                                                    <span class="icon-box">
                                          <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                          <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                       </span>
                                                </a>
											
											</div>
										</div>
									</div>
								</div>
								<div class="swiper-slide">
									<div class="rs-services-item">
										<div class="rs-services-thumb">
											<a href="services-details.html"> <img src="assets/images/services/services-thumb-08.png" alt="image"></a>
										</div>
										<div class="rs-services-content">
											<h5 class="rs-services-title"><a href="services-details.html"> Automation industry
                                                    management</a></h5>
											<p class="descrip">Industry's standard dummy text ever since the 1500s </p>
											<div class="rs-services-number"></div>
											<div class="rs-services-btn-wrapper">
												<div class="rs-services-text-btn underline has-theme-yellow">
													<a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
												</div>
												<a class="rs-square-btn has-icon has-light-bg" href="services-details.html">
                                                    <span class="icon-box">
                                          <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                          <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                       </span>
                                                </a>
											
											</div>
										</div>
									</div>
								</div>
								<div class="swiper-slide">
									<div class="rs-services-item">
										<div class="rs-services-thumb">
											<a href="services-details.html"> <img src="assets/images/services/services-thumb-21.png" alt="image"></a>
										</div>
										<div class="rs-services-content">
											<h5 class="rs-services-title"><a href="services-details.html"> Best innovations in
                                                    metallurgy</a></h5>
											<p class="descrip"> Consectetur ipiscing elit tellus ullam corper mattis </p>
											<div class="rs-services-number"></div>
											<div class="rs-services-btn-wrapper">
												<div class="rs-services-text-btn underline has-theme-yellow">
													<a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
												</div>
												<a class="rs-square-btn has-icon has-light-bg" href="services-details.html">
                                                    <span class="icon-box">
                                          <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                          <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                       </span>
                                                </a>
											
											</div>
										</div>
									</div>
								</div>
								<div class="swiper-slide">
									<div class="rs-services-item">
										<div class="rs-services-thumb">
											<a href="services-details.html"> <img src="assets/images/services/services-thumb-22.png" alt="image"></a>
										</div>
										<div class="rs-services-content">
											<h5 class="rs-services-title"><a href="services-details.html"> Manufacturer of tin lead
                                                    and lead...</a></h5>
											<p class="descrip"> Making this true first generator think on the Internet </p>
											<div class="rs-services-number"></div>
											<div class="rs-services-btn-wrapper">
												<div class="rs-services-text-btn underline has-theme-yellow">
													<a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
												</div>
												<a class="rs-square-btn has-icon has-light-bg" href="services-details.html">
                                                    <span class="icon-box">
                                          <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                          <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                       </span>
                                                </a>
											
											</div>
										</div>
									</div>
								</div>
								<div class="swiper-slide">
									<div class="rs-services-item">
										<div class="rs-services-thumb">
											<a href="services-details.html"> <img src="assets/images/services/services-thumb-23.png" alt="image"></a>
										</div>
										<div class="rs-services-content">
											<h5 class="rs-services-title"><a href="services-details.html"> State of the art for
                                                    hight control in... </a></h5>
											<p class="descrip"> With our vast experience &amp; knowledge in this field.</p>
											<div class="rs-services-number"></div>
											<div class="rs-services-btn-wrapper">
												<div class="rs-services-text-btn underline has-theme-yellow">
													<a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
												</div>
												<a class="rs-square-btn has-icon has-light-bg" href="services-details.html">
                                                    <span class="icon-box">
                                          <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                          <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                       </span>
                                                </a>
											
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</main>

	<script>
		const slug = new URLSearchParams( window.location.search ).get( "category" );

		document.addEventListener( "DOMContentLoaded", () => {
			fetchProducts();

		} );


		function fetchProducts() {
			isLoading = true;
			document.getElementById( "loading" ).style.display = 'block';

			fetch( `controllers/ProductSubCategoryController.php?action=fetch&category=${encodeURIComponent(slug)}&offset=${offset}&limit=${limit}` )
				.then( res => res.text() )
				.then( data => {
					data = data.trim();

					if ( data === '' || data.includes( 'no-products-marker' ) ) {
						hasMore = false;
					} else {
						document.getElementById( "subproduct-list" ).innerHTML += data;
						offset += limit;

						// if returned less than 12 items, it means no more left
						if ( ( data.match( /data-aos=/g ) || [] ).length < limit ) {
							hasMore = false;
						}

						AOS.init(); // reinitialize animations
					}

					isLoading = false;
					document.getElementById( "loading" ).style.display = 'none';
				} )
				.catch( err => {
					console.error( err );
					isLoading = false;
					document.getElementById( "loading" ).style.display = 'none';
				} );
		}
	</script>

	<script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
	<script>
		AOS.init();
	</script>

	<?php } ?>