<?php
require_once 'iadmin/inc/db.php';
require_once 'models/ProductDetailModel.php';

$productSlug = $_GET[ 'product' ] ?? '';
$model = new ProductDetailModel( $conn );
$product = $model->getProductBySlug( $productSlug );

include( "assets/inc/template.php" ); // Load common layout (includes <body> & header/footer)

function main() {
	global $product;
	?>
	<style>
		.custom-button {
			position: relative;
			border: none;
			background: transparent;
			padding: 0;
		}
		
		.custom-button img {
			max-width: 100px;
			border-radius: 8px;
		}
		
		.play-icon {
			position: absolute;
			top: 50%;
			left: 50%;
			transform: translate(-50%, -50%);
			font-size: 22px;
			background-color: rgba(0, 0, 0, 0.6);
			color: white;
			padding: 6px 10px;
			border-radius: 50%;
		}
		
		/* Table Styling */
		.table-responsive .table {
			margin-top: 15px;
			border: 1px solid #898989;
		}
		
		.table thead th {
			background-color: #214c8b;
			color: #fff;
			font-weight: 600;
			font-size: 15px;
			text-align: center;
			border: 1px solid #fff
		}
		
		.table td,
		.table th {
			padding: 12px 16px;
			font-size: 14px;
			vertical-align: middle;
			text-align: center
		}
		
		.custom-list {
    list-style: none;
    padding-left: 0;
}
.custom-list li {
    position: relative;
    padding-left: 20px;
    margin-bottom: 8px;
    color: #333;
}
.custom-list li::before {
    content: "➤"; /* Or use →, ►, etc. */
    position: absolute;
    left: 0;
    color: #214c8b;
}
		

 .rs-services-item {
  position: relative;
  background: #fff;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
  padding: 9px;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
  z-index: 1;
 border: 1px solid #214c8b
}

/* Hover scale and shadow */
.rs-services-item:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 30px rgba(33, 76, 139, 0.25);
}

/* Animated circular gradient border */
.rs-services-item::before {
  content: "";
  position: absolute;
  top: -4px;
  left: -4px;
  right: -4px;
  bottom: -4px;
  background: conic-gradient(from 0deg, #214C8B, #898989, #214C8B);
  border-radius: 24px;
  z-index: -1;
  opacity: 0;
  transition: opacity 0.4s ease;
  animation: rotateBorder 4s linear infinite;
}

.rs-services-item:hover::before {
  opacity: 1;
}


/* Image styling */
.rs-services-thumb img {
  border-radius: 14px;
  width: 100%;
  object-fit: cover;
}

/* Title styling */
.rs-services-title a {
  color: #214C8B;
  font-size: 18px;
  font-weight: 600;
  margin-top: 15px;
  display: inline-block;
  transition: color 0.3s ease;
}

.rs-services-title a:hover {
  color: #898989;
}

/* Button area */
.rs-services-btn-wrapper {
  margin-top: 15px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.rs-text-btn {
  color: #214C8B;
  font-weight: 500;
  text-decoration: underline;
}

.rs-text-btn:hover {
  color: #898989;
}

.rs-square-btn {
  background: #214C8B;
  color: #fff;
  padding: 8px 12px;
  border-radius: 8px;
  transition: background 0.3s ease;
}

.rs-square-btn:hover {
  background: #898989;
}

.icon-box svg path {
  fill: #fff;
}

	</style>
	<script type="module" src="https://unpkg.com/@google/model-viewer/dist/model-viewer.min.js"></script>

	<link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
	<main>

		<!-- breadcrumb area start -->
		<section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
			<div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
			<div class="container">
				<div class="row">
					<div class="col-xxl-6 col-xl-8 col-lg-8">
						<div class="rs-breadcrumb-content-wrapper">
							<div class="rs-breadcrumb-title-wrapper">
								<h1 class="rs-breadcrumb-title">Product Details</h1>
							</div>
							<div class="rs-breadcrumb-menu">
								<nav>
									<ul>
										<li><span><a href="index.php">Home</a></span>
										</li>
										<li><span><a href="products.php?category=<?= htmlspecialchars($product['category_slug']) ?>"><?= ucwords(htmlspecialchars($product['category_name'])) ?>
</a></span>
										</li>
										<li>
											<span>
												<?= ucwords(htmlspecialchars($product['subcat_name'])) ?>
											</span>
										</li>
									</ul>
								</nav>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- breadcrumb area end -->


		<!-- shop area start -->
		<section class="rs-shop-area section-space">
			<div class="container">
				<div class="row align-items-lg-center g-5">
					<div class="col-md-6">
						<div class="product-details-thumb-wrap">
							<div class="product-details-thumb-top mb-10">
								<div class="swiper product-details-active p-relative">
									<div class="swiper-wrapper">
										<!-- Image Slide -->
										<div class="swiper-slide">
											<div class="product-details-thumb">
												<img src="assets/images/ss-panel-lock-rls41.png" style="width: 600px; height: 600px" alt="image">
											</div>
										</div>
										<div class="swiper-slide">
											<div class="product-details-thumb">
												<img src="assets/images/ss-panel-lock-rls41-diagram.jpg" style="width: 600px; height: 600px" alt="image">
											</div>
										</div>

										<!-- Video Slide -->



										<!-- More Images -->
										
										<!-- Add more as needed -->
									</div>
								</div>
							</div>

							<div class="product-details-thumb-bottom">
								<div class="product-details-slider-dot">
									<div class="swiper product-details-nav">
										<div class="swiper-wrapper">
											<div class="swiper-slide">
												<button class="custom-button">
                                <img src="assets/images/ss-panel-lock-rls41.png" alt="image">
                            </button>
											

											</div>
											<!-- Thumbnail for image -->
											<div class="swiper-slide">
												<button class="custom-button">
                                <img src="assets/images/ss-panel-lock-rls41-diagram.jpg" alt="image">
                            </button>
											

											</div>

											<!-- Thumbnail for video -->


											<!-- More thumbnails -->
											
											<div class="swiper-slide">
												<div class="rs-about-btn">
													<a href="https://www.youtube.com/watch?v=Yue48fUXuqI" class="rs-play-btn popup-video"><i class="ri-play-fill"></i></a>
												</div>
											</div>
											<div class="swiper-slide">
												<button class="custom-button" data-bs-toggle="modal" data-bs-target="#threeDModal">
        <img src="assets/images/3d.png" alt="3D View" width="100">
        <span class="play-icon">&#128064;</span>
    </button>
											
											</div>
											<!-- Add more as needed -->
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- 3D Viewer Modal -->
					<div class="modal fade" id="threeDModal" tabindex="-1" aria-labelledby="threeDModalLabel" aria-hidden="true">
						<div class="modal-dialog modal-xl modal-dialog-centered">
							<div class="modal-content">
								<div class="modal-header">
									<h5 class="modal-title">3D Product View</h5>
									<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
								</div>
								<div class="modal-body text-center">
									<model-viewer src="https://modelviewer.dev/shared-assets/models/Astronaut.glb" alt="3D model" auto-rotate camera-controls ar style="width: 100%; height: 600px;">
									</model-viewer>
								</div>
							</div>
						</div>
					</div>

					<div class="col-md-6">
						<div class="product-details-wrapper shop-details">
							<h3 class="product-details-title mb-10">
								<?= ucwords(htmlspecialchars($product['subcat_name'])) ?>
							</h3>
							<a href="#" style="color: black">
												
													<span><img src="assets/images/icon/pdf.svg" alt="#" ></span> Download PDF
												
												
											</a>
							<p class="mb-15 mt-15">Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur...</p>
							<div class="rs-services-details-feature-list">
                                <div class="rs-list-item has-theme-orange">
                                    <ul>
                                        <li><i class="fa-light fa-gear"></i>
<!--
-->
                                            <b> Material : </b> Die Cast Housing, MS Lever, MS Nut, Die Cast Insert
                                        </li>
										<li><li><i class="fa-light fa-gear"></i>
<!--
-->
                                            <b>Finish : </b> Bright Chrome
                                        </li>
                                       
                                    </ul>
                                </div>
                            </div>

							<!-- Responsive Table -->
							<div class="table-responsive mb-20">
								<table class="table table-bordered">
									<thead class="table-light">
										<tr>
											<th align="center">Model</th>
											<th align="center">Specifications</th>

										</tr>
									</thead>
									<tbody>
										<tr>
											<td>RLS41</td>
											<td>Stainless Steel</td>

										</tr>
										
									</tbody>
								</table>
							</div>
							<!-- End Table -->
							<div class="product-details-count-wrap d-flex flex-wrap gap-20 align-items-center mb-25">
                                
                                <div class="product-details-action d-flex flex-wrap align-items-center">
                                    <a class="rs-btn has-theme-orange has-icon has-bg" href="inquiry-us.php">Inquiry Now
                                            <span class="icon-box">
                                    <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
                                       <path d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                       </path>
                                    </svg>
                                    <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
                                       <path d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                       </path>
                                    </svg>
                                 </span>
                                        </a>
                                </div>
								<div class="product-details-action d-flex flex-wrap align-items-center">
                                   <a class="rs-btn has-theme-orange has-icon has-bg d-inline-flex align-items-center" href="https://wa.me/919999999999" target="_blank" style="background: #075e54; color: #fff; padding: 12px 20px; border-radius: 6px; font-weight: 500;">
    <span class="icon-box me-2">
        <img src="assets/images/whatsapp.svg" alt="WhatsApp" style="width: 20px; height: 20px;">
    </span>
    WhatsApp Now
</a>

                                </div>
                            </div>
							

							<?php /*?>
							<div class="product-details-categories product-details-more mb-5">
								<p>Categories:</p>
								<span>
                <a href="products.php?category=<?= htmlspecialchars($product['category_slug']) ?>">
                    <?= ucwords(htmlspecialchars($product['category_name'])) ?>
                </a>
            </span>
							
							</div>
							<?php */?>
						</div>
					</div>

				</div>
				<div class="product-information mt-50">
					<div class="row g-5 justify-content-center">
						<div class="col-xxl-12 col-xl-12 col-lg-12">
							<div class="product-information-tab">
								<ul class="nav nav-pills mb-35 flex-wrap gap-10 has-border" id="pills-tab" role="tablist">
									<li class="nav-item" role="presentation">
										<button class="nav-link active" id="pills-information-tab" data-bs-toggle="pill" data-bs-target="#pills-information" type="button" role="tab" aria-controls="pills-information" aria-selected="true">Description</button>
									</li>
									<li class="nav-item" role="presentation">
										<button class="nav-link" id="pills-review-tab" data-bs-toggle="pill" data-bs-target="#pills-review" type="button" role="tab" aria-controls="pills-review" aria-selected="false">Other</button>
									</li>
								</ul>
								<div class="tab-content" id="pills-tabContent">
									<div class="tab-pane fade show active" id="pills-information" role="tabpanel" aria-labelledby="pills-information-tab" tabindex="0">
										<div class="information-wrapper">
											<p>It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using ‘Content here, content here’, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for ‘lorem ipsum’ will uncover many web sites still in their infancy. vel illum qui dolorem eum fugiat quo voluptas nulla pariatur</p>

										</div>
									</div>

									<div class="tab-pane fade" id="pills-review" role="tabpanel" aria-labelledby="pills-review-tab" tabindex="0">
										<div class="product-details-reviews-wrapper">
											<div class="product-details-review-list">
												<div class="product-review-item">
													<div class="product-review-avater">
														<div class="product-review-avater-thumb">
															<img src="assets/images/user/user-thumb-01.png" alt="image">
														</div>
														<div class="product-review-avater-info">
															<h6 class="product-review-avater-title">John Miller</h6>
														</div>
													</div>
													<div class="product-review-rating d-flex align-items-center mt-15 mb-15">
														<div class="product-rating rating-color d-flex">
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
														</div>
														<div class="product-review-rating-date">
															<span>April 10, 2024</span>
														</div>
													</div>
													<p>Podcasting operational change management inside of workflows to establish a framework Taking seamless key performance indicators.</p>
												</div>
												<div class="product-review-item">
													<div class="product-review-avater">
														<div class="product-review-avater-thumb">
															<img src="assets/images/user/user-thumb-02.png" alt="image">
														</div>
														<div class="product-review-avater-info">
															<h6 class="product-review-avater-title">Joshua Sendu</h6>
														</div>
													</div>
													<div class="product-review-rating d-flex align-items-center mt-15 mb-15">
														<div class="product-rating rating-color d-flex">
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
														</div>
														<div class="product-review-rating-date">
															<span>Feb 2, 2025</span>
														</div>
													</div>
													<p>Podcasting operational change management inside of workflows to establish a framework Taking seamless key performance indicators.</p>
												</div>
											</div>
										</div>
										<div class="product-review-form">
											<h5 class="product-review-form-title">Add a review</h5>
											<p>Your email address will not be published. Required fields are marked *</p>
											<form action="#">
												<div class="product-review-form-rating  mb-25">
													<h5 class="rate-title">Rate this product:</h5>
													<div class="product-review-rating-wrapper d-flex">
														<span>
                                             <i class="icon_star"></i>
                                          </span>
													

														<span>
                                             <i class="icon_star"></i>
                                          </span>
													

														<span>
                                             <i class="icon_star"></i>
                                          </span>
													

														<span>
                                             <i class="icon_star"></i>
                                          </span>
													

														<span>
                                             <i class="icon_star_alt"></i>
                                          </span>
													

													</div>
												</div>
												<div class="row g-5">
													<div class="col-lg-6">
														<div class="product-review-input">
															<input type="text" placeholder="Name">
														</div>
													</div>
													<div class="col-lg-6">
														<div class="product-review-input">
															<input type="email" placeholder="Email">
														</div>
													</div>
													<div class="col-lg-12">
														<div class="product-review-input is-textarea">
															<textarea placeholder="Your Review Here..."></textarea>
														</div>
													</div>
													<div class="col-lg-12">
														<div class="product-review-btn">
															<button class="rs-btn has-theme-orange" type="submit">Submit Review</button>
														</div>
													</div>
												</div>
											</form>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<hr><br>
		<section class="rs-elements-services-area section-space-bottom rs-services-eight rs-swiper has-theme-orange">
			<div class="container">

				<div class="row align-items-center g-5 section-title-space">
					<div class="col-xl-7 col-lg-7">
						<div class="rs-section-title-wrapper">

							<h4 class="mb-30">Related products</h4>
						</div>
					</div>
					<div class="col-xl-5 col-lg-5">

						<div class="rs-services-navigation">
							<button class="swiper-button-prev rs-swiper-btn has-theme-yellow"><i
                           class="fa-regular fa-arrow-left"></i></button>
							<button class="swiper-button-next rs-swiper-btn has-theme-yellow"><i
                           class="fa-regular fa-arrow-right"></i></button>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="rs-services-slide-wrapper">
						<div class="swiper" data-clone-slides="false" data-loop="false" data-speed="1500" data-autoplay="true" data-dots-dynamic="false" data-hover-pause="true" data-effect="false" data-delay="1000" data-item="4" data-item-xl="3" data-item-lg="3" data-item-md="2" data-item-sm="1" data-item-xs="1" data-item-mobile="1" data-margin="30">
							<div class="swiper-wrapper process-counts" id="related-products-wrapper">
							
								
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		
	</main>

		<script>
document.addEventListener("DOMContentLoaded", function () {
    const slug = new URLSearchParams(window.location.search).get('product');
    if (!slug) return;

    fetch(`controllers/ProductSubCategoryController.php?action=related&product=${slug}`)
        .then(res => res.text())
        .then(html => {
            const wrapper = document.getElementById("related-products-wrapper");
            wrapper.innerHTML = html;

            // ✅ Update only
            const swiperInstance = document.querySelector(".swiper")?.swiper;
            if (swiperInstance) {
                swiperInstance.update();
            }
        })
        .catch(err => {
            console.error("Failed to load related products:", err);
            document.getElementById("related-products-wrapper").innerHTML =
                '<div class="col-12 text-center text-danger">Error loading related products.</div>';
        });
});
</script>


	<script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
	<script>
		AOS.init();
	</script>

	<?php } ?>