<?php
class ProductMediaModel {
    private $conn;
	private $uploadDir;
    public function __construct($db) {
        $this->conn = $db;
		$this->uploadDir = __DIR__ . '/../../uploads/media/';
    }

    public function create($data) {
        $stmt = $this->conn->prepare("INSERT INTO product_medias (product_id, media_type, media_url, alt_text, is_primary, sort_order, status) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param(
            "isssiss",
            $data['product_id'],
            $data['media_type'],
            $data['media_url'],
            $data['alt_text'],
            $data['is_primary'],
            $data['sort_order'],
            $data['status']
        );
        return $stmt->execute();
    }

    public function update($id, $data) {
    $query = "UPDATE product_medias SET media_type=?, alt_text=?, is_primary=?, sort_order=?, status=?";
    $hasNewImage = !empty($data['media_url']);

    if ($hasNewImage) {
        $this->unlinkOldImage($id); // ✅ Delete old image
        $query .= ", media_url=?";
    }
    $query .= " WHERE id=?";

    if ($hasNewImage) {
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param(
            "ssiiisi",
            $data['media_type'],
            $data['alt_text'],
            $data['is_primary'],
            $data['sort_order'],
            $data['status'],
            $data['media_url'],
            $id
        );
    } else {
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param(
            "ssiiis",
            $data['media_type'],
            $data['alt_text'],
            $data['is_primary'],
            $data['sort_order'],
            $data['status'],
            $id
        );
    }
    return $stmt->execute();
}


    public function getById($id) {
        $stmt = $this->conn->prepare("SELECT * FROM product_medias WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function getAllByProduct($product_id) {
    $stmt = $this->conn->prepare("SELECT pm.*, ps.subcat_name
        FROM product_medias pm
        JOIN product_subcategories ps ON pm.product_id = ps.id
        WHERE pm.product_id = ?
        ORDER BY pm.sort_order ASC, pm.id DESC
    ");
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}


    public function delete($id) {
		$this->unlinkOldImage($id);
        $stmt = $this->conn->prepare("DELETE FROM product_medias WHERE id = ?");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }
	
	public function toggleStatus($id) {
    $stmt = $this->conn->prepare("
        UPDATE product_medias 
        SET status = CASE 
            WHEN status = 'active' THEN 'inactive' 
            ELSE 'active' 
        END 
        WHERE id = ?
    ");
    $stmt->bind_param("i", $id);
    return $stmt->execute();
}
	
	public function updateSortOrder($id, $sort_order) {
    $stmt = $this->conn->prepare("UPDATE product_medias SET sort_order = ? WHERE id = ?");
    $stmt->bind_param("ii", $sort_order, $id);
    return $stmt->execute();
}

	
	// ✅ DELETE OLD IMAGE FILE
    private function unlinkOldImage($id) {
        $product = $this->getById($id);
        if ($product && !empty($product['media_url'])) {
            $oldImagePath = $this->uploadDir . $product['media_url'];
            if (file_exists($oldImagePath)) {
                unlink($oldImagePath);
            }
        }
    }
}
?>
