$(document).on('change', ".__change_account__super_admin", function (e) {
    e.preventDefault();

    let accountId = $('.__change_account__super_admin').val();
    let token = $('meta[name="csrf-token"]').attr('content');
    let url = $('.__change_account__super_admin').data("url");

    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': token},
        type: 'POST',
        data: {
            accountId: accountId,
        },
        success: function (data) {
            location.reload();
        },
        error: function () {
            alert("Something Went Wrong!");
        }
    });

});

$(document).on('change', '.__change__student__class', function () {
    let refId = $('.__change__student__class').val();
    if (refId==0 || refId=='' || refId==null){
        return false;
    }
    let url = $('.__change__student__class').data("url").replace('classId', refId);

    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: 'POST',
        success: function (data) {
            $(".__replace__section__byClass").html(data.classSections);
        },
        error: function () {
            alert("Something Went Wrong!");
        }
    });
});

$(document).on('click', '#__fill__current__address', function () {
    if ($("#__fill__current__address").is(':checked')) {
        $('#current_address').val($('#guardian_address').val());
    }
});

$(document).on('click', '#__fill__permanent__address', function () {
    if ($("#__fill__permanent__address").is(':checked')) {
        $('#permanent_address').val($('#current_address').val());
    }
});

$(document).ready(function () {
    flatpickr(".setDatePicker", {
        dateFormat: "Y-m-d",
        allowInput: true,
        onOpen: function (selectedDates, dateStr, instance) {
            instance.setDate(instance.input.value, false);
        },
    });

    flatpickr(".setTimePicker", {
        enableTime: true,
        noCalendar: true,
        dateFormat: "H:i",
        onOpen: function (selectedDates, dateStr, instance) {
            instance.setDate(instance.input.value, false);
        },
    });
});

// Common datatable for listing
function __commonDatatableListing(tableRef, routeUrl, columnsArr) {
    let table = $("#" + tableRef).DataTable({
        processing: true,
        serverSide: false,
        autoWidth: false,
        responsive: false,
        orderClasses: false,
        ajax: routeUrl,
        columns: columnsArr,
        columnDefs: [
            {className: "__sms__ta__right", targets: "_all"},
        ],
        order: [[0, 'asc']],
        language: {
            search: '<span>Filter:</span> _INPUT_',
            lengthMenu: '<span>Show:</span> _MENU_',
            paginate: {'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;'}
        },
        lengthMenu: [25, 50, 100],
        displayLength: 25
    });

    return table;
}

// Common datatable for listing
function __commonDatatableListingNormal(tableRef, routeUrl, columnsArr, paramArr = []) {
    let table = $("#" + tableRef).DataTable({
        processing: true,
        serverSide: false,
        autoWidth: false,
        responsive: false,
        orderClasses: false,
        paging: false,
        searching: false,
        bInfo: false,
        ajax: {
            url: routeUrl,
            data: paramArr
        },
        columns: columnsArr,
        columnDefs: [
            {className: "__sms__ta__right", targets: "_all"},
        ],
        order: [[0, 'asc']],
    });

    return table;
}

// Add edit sections
$(document).on('click', ".__sms__add__section__detail", function (event) {
    event.preventDefault();
    $(".__sms__field__error").html("");
    let section = $("#section").val();
    if (section == '' || section == null || typeof section == undefined) {
        $("#section").focus();
        return false;
    }
    let _refSection = $(this).data("id");
    let url = actionUrl._add_edit_record;
    url = url.replace("_refSection", _refSection);

    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: 'POST',
        data: {
            title: section,
        },
        success: function (data) {
            table.ajax.reload();
            event.preventDefault();
            $("#section").val("");
            $('.__sms__add__section__detail').data("id", 0);
            showSuccessDialog(actionUrl._success_msg);
        },
        error: function (jqXHR, exception) {
            if (jqXHR.status === 422) {
                $(".__sms__field__error").html(jqXHR.responseJSON.errors.title[0]);
            }
        }
    });
});

// fetch section details
$(document).on('click', '.__section__table .__sms__edit__record', function () {
    let _ref = $(this).data("id");
    $("#section").val("");
    let url = actionUrl._edit_record;
    url = url.replace("_refSection", _ref);

    $.ajax({
        url: url,
        dataType: "json",
        success: function (data) {
            $('#section').val(data.result.title);
            $('.__sms__add__section__detail').data('id', data.result.id); //setter
            $('#section').focus();
        }
    })
});

// delete section
$(document).on('click', '.__section__table .__sms__delete__record', function (event) {
    event.preventDefault();

    Swal.fire({
        title: commonMessage.__destroy_confirmation_message,
        text: commonMessage.__no_revert_message,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: commonMessage.__yes_delete,
    }).then((result) => {
        if (result.value) {
            let _ref = $(this).data("id");
            let url = actionUrl._destroy_record;
            url = url.replace("_refSection", _ref);
            $.ajax({
                url: url,
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                dataType: "json",
                type: 'DELETE',
                success: function (data) {
                    table.ajax.reload();
                    showSuccessDialog(commonMessage.__deleted_message);
                }
            })
        }
    });
});

$(document).on('click', ".__sms__add__class__detail", function (event) {
    event.preventDefault();
    $(".__sms__field__error").html("");
    let className = $("#studentClass").val();
    if (className == '' || className == null || typeof className == undefined) {
        $("#studentClass").focus();
        return false;
    }

    let divisions = [];
    $.each($("input[name='divisionCheckbox']:checked"), function () {
        divisions.push($(this).val());
    });
    if (!divisions.length) {
        $("input[name='divisionCheckbox']:first").focus();
        return false;
    }
    let _refSection = $(this).data("id");
    let url = actionUrl._add_edit_record;
    url = url.replace("_refSection", _refSection);

    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: 'POST',
        data: {
            title: className,
            divisions: divisions,
        },
        success: function (data) {
            table.ajax.reload();
            event.preventDefault();
            $("#studentClass").val("");
            $('.__sms__add__class__detail').data("id", 0);
            $('input:checkbox').removeAttr('checked');
            showSuccessDialog(actionUrl._success_msg);
        },
        error: function (jqXHR, exception) {
            if (jqXHR.status === 422) {
                $(".__sms__field__error").html(jqXHR.responseJSON.errors.title[0]);
            }
        }
    });
});

// fetch section details
$(document).on('click', '.__grade__table .__sms__edit__record', function () {
    let _ref = $(this).data("id");
    $("#section").val("");
    let url = actionUrl._edit_record;
    url = url.replace("_refSection", _ref);

    $.ajax({
        url: url,
        dataType: "json",
        success: function (data) {
            $('#studentClass').val(data.result.title);
            $('.__sms__add__class__detail').data('id', data.result.id); //setter
            $(".__divisions__data__checkbox").html(data.gradeDivisions);
            $('#studentClass').focus();
        }
    })
});

// delete grade
$(document).on('click', '.__grade__table .__sms__delete__record', function (event) {
    event.preventDefault();
    Swal.fire({
        title: commonMessage.__destroy_confirmation_message,
        text: commonMessage.__no_revert_message,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: commonMessage.__yes_delete,
    }).then((result) => {
        if (result.value) {
            let _ref = $(this).data("id");
            let url = actionUrl._destroy_record;
            url = url.replace("_refSection", _ref);
            $.ajax({
                url: url,
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                dataType: "json",
                type: 'DELETE',
                success: function (data) {
                    table.ajax.reload();
                    showSuccessDialog(commonMessage.__deleted_message);
                }
            })
        }
    });
});



$(document).on('click', ".__sms__add__teacher__detail", function (event) {
    event.preventDefault();
    $(".__sms__field__error").html("");
    let _ref_class_id = $("#_ref_class_id").val();
    if (_ref_class_id == '' || _ref_class_id == 0 || _ref_class_id == null || typeof _ref_class_id == undefined) {
        $("#_ref_class_id").focus();
        return false;
    }

    let _ref_section_id = $("#section_id").val();
    if (_ref_section_id == '' || _ref_section_id == 0 || _ref_section_id == null || typeof _ref_section_id == undefined) {
        $("#section_id").focus();
        return false;
    }

    let _ref_staff_id = $("#_ref_staff_id").val();
    if (_ref_staff_id == '' || _ref_staff_id == 0 || _ref_staff_id == null || typeof _ref_staff_id == undefined) {
        $("#_ref_staff_id").focus();
        return false;
    }

    let _refSection = $(this).data("id");
    let url = actionUrl._add_edit_record;
    url = url.replace("_refSection", _refSection);

    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: 'POST',
        data: {
            _ref_class_id: _ref_class_id,
            _ref_section_id: _ref_section_id,
            _ref_staff_id: _ref_staff_id,
        },
        success: function (data) {
            table.ajax.reload();
            event.preventDefault();
            $("#studentClass").val("");
            $('.__sms__add__class__detail').data("id", 0);
            $('input:checkbox').removeAttr('checked');
            showSuccessDialog(actionUrl._success_msg);
        },
        error: function (jqXHR, exception) {
            if (jqXHR.status === 422) {
                $(".__sms__field__error").html(jqXHR.responseJSON.errors.title[0]);
            }
        }
    });
});

// fetch section details
$(document).on('click', '.__class__teacher__table .__sms__edit__record', function () {
    let _ref = $(this).data("id");
    let url = actionUrl._edit_record;
    url = url.replace("_refSection", _ref);

    $.ajax({
        url: url,
        dataType: "json",
        success: function (data) {
            getClassSectionUrl(data.result.class_id, data.result.section_id);
            $("#_ref_class_id option[value="+data.result.class_id+"]").prop('selected', true);
            $("#section_id option[value="+data.result.section_id+"]").prop('selected', true);
            $("#_ref_staff_id option[value="+data.result.staff_id+"]").prop('selected', true);

        }
    })
});


// delete teacher
$(document).on('click', '.__class__teacher__table .__sms__delete__record', function (event) {
    event.preventDefault();
    Swal.fire({
        title: commonMessage.__destroy_confirmation_message,
        text: commonMessage.__no_revert_message,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: commonMessage.__yes_delete,
    }).then((result) => {
        if (result.value) {
            let _ref = $(this).data("id");
            let url = actionUrl._destroy_record;
            url = url.replace("_refSection", _ref);
            $.ajax({
                url: url,
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                dataType: "json",
                type: 'DELETE',
                success: function (data) {
                    table.ajax.reload();
                    showSuccessDialog(commonMessage.__deleted_message);
                }
            })
        }
    });
});





// Add edit sections
$(document).on('click', ".__sms__add__subject__detail", function (event) {
    event.preventDefault();
    $(".__sms__field__error").html("");
    let subject = $("#subject").val();
    if (subject == '' || subject == null || typeof subject == undefined) {
        $("#subject").focus();
        return false;
    }
    let _refSection = $(this).data("id");
    let url = actionUrl._add_edit_record;
    url = url.replace("_refSection", _refSection);

    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: 'POST',
        data: {
            title: subject,
        },
        success: function (data) {
            table.ajax.reload();
            event.preventDefault();
            $("#subject").val("");
            $('.__sms__add__subject__detail').data("id", 0);
            showSuccessDialog(actionUrl._success_msg);
        },
        error: function (jqXHR, exception) {
            if (jqXHR.status === 422) {
                $(".__sms__field__error").html(jqXHR.responseJSON.errors.title[0]);
            }
        }
    });
});

// fetch subject details
$(document).on('click', '.__subject__table .__sms__edit__record', function () {
    let _ref = $(this).data("id");
    $("#subject").val("");
    let url = actionUrl._edit_record;
    url = url.replace("_refSection", _ref);

    $.ajax({
        url: url,
        dataType: "json",
        success: function (data) {
            $('#subject').val(data.result.title);
            $('.__sms__add__subject__detail').data('id', data.result.id); //setter
            $('#subject').focus();
        }
    })
});

// delete subject
$(document).on('click', '.__subject__table .__sms__delete__record', function (event) {
    event.preventDefault();

    Swal.fire({
        title: commonMessage.__destroy_confirmation_message,
        text: commonMessage.__no_revert_message,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: commonMessage.__yes_delete,
    }).then((result) => {
        if (result.value) {
            let _ref = $(this).data("id");
            let url = actionUrl._destroy_record;
            url = url.replace("_refSection", _ref);
            $.ajax({
                url: url,
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                dataType: "json",
                type: 'DELETE',
                success: function (data) {
                    table.ajax.reload();
                    showSuccessDialog(commonMessage.__deleted_message);
                }
            })
        }
    });
});


$('#timetableForm').on('submit',function(event) {
    event.preventDefault();

    $( '#form-errors' ).html( '' );

    let refId = $("#__ref__id").val();
    let url = (refId>0) ? $(this).data('update-url').replace('timetableRef', refId) : $(this).data('create-url');
    let method = (refId>0) ? 'PATCH' : 'POST';
    let data = $('#timetableForm').serialize();
    __callTimetableAction(url, method, data, 'form');
});

function __callTimetableAction(url, method, data, source){
    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: method,
        // data: {formData: $('#timetableForm').serialize(), _method: method},
        data: data,
        success: function (data) {
            if (data.status_code == 202){
                showErrorDialog(commonMessage.__oops, commonMessage.__slot_booked_teacher);
            }
            if (data.status_code == 200){
                if (source!=='event'){
                    let _ref_class_id = $("#_ref_class_id").val();
                    let section_id = $("#section_id").val();
                    $("#timetableForm")[0].reset();
                    $("#_ref_class_id").val(_ref_class_id);
                    $("#section_id").val(section_id);
                    showSuccessDialog(actionUrl._success_msg);
                }
            }
            reRenderEvent();

            teacherAvailability.ajax.reload();
        },
        error: function (jqXHR, exception) {
            if (jqXHR.status === 422) {

                let errors = jqXHR.responseJSON.errors; //this will get the errors response data.
                let errorsHtml = '<div class="alert alert-danger"><ul>';
                $.each( errors, function( key, value ) {
                    errorsHtml += '<li>' + value[0] + '</li>'; //showing only the first error.
                });
                errorsHtml += '</ul></di>';

                $( '#form-errors' ).html( errorsHtml );
            }
        }
    });
}

async function __getTimetableDetails(url, method){
    await $.ajax({
        url: url,
        type: method,
        dataType: "json",
        success: function (data) {
            // console.log(data.result);

            $('#timetableForm *').filter(':input').each(function(){
                let fieldName = $(this).attr('name');
                let inputObj = $(this);

                    Object.keys(data.result).forEach(function(key) {
                        if (key == fieldName){
                            inputObj.val(data.result[key]);
                        }
                    });
            });

            $("#__ref__id").val(data.result.id);
            $('html,body').animate({ scrollTop: 0 }, 'slow');

            return data.result;
        },
        error: function () {
            alert("Something Went Wrong!");
        }
    })
}


$('#uploadFileForm').on('submit',function(event) {
    event.preventDefault();

    $( '#form-errors' ).html( '' );

    let refId = $("#__ref__id").val();
    let url = (refId>0) ? $(this).data('update-url').replace('timetableRef', refId) : $(this).data('create-url');
    let method = (refId>0) ? 'PATCH' : 'POST';
    let data = $('#uploadFileForm').serialize();
    __callFileUploadAction(url, method, data, 'form');
});

function __callFileUploadAction(url, method, data, source){
    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: method,
        data: data,
        success: function (data) {
            if (data.status_code == 202){
                showErrorDialog(commonMessage.__oops, commonMessage.__slot_booked_teacher);
            }
            if (data.status_code == 200){
                $("#uploadFileForm")[0].reset();
                table.ajax.reload();
                // this.removeAllFiles();
                showSuccessDialog(actionUrl._success_msg);
                location.reload();
            }
        },
        error: function (jqXHR, exception) {
            if (jqXHR.status === 422) {

                let errors = jqXHR.responseJSON.errors; //this will get the errors response data.
                let errorsHtml = '<div class="alert alert-danger"><ul>';
                $.each( errors, function( key, value ) {
                    errorsHtml += '<li>' + value[0] + '</li>'; //showing only the first error.
                });
                errorsHtml += '</ul></di>';

                $( '#form-errors' ).html( errorsHtml );
            }
        }
    });
}

function inputValidation(fieldName) {
    if (fieldName == 0 || fieldName == '' || fieldName == null || typeof fieldName == "undefined") {
        return false;
    }
    return true;
}

$(document).on('click', '.__sms__copy__guardian', function (e) {
    let value = $(this).val();

    $("#guardian_name").val($(document).find('input[name="' + value + '_name"]').attr('value'));
    $("#guardian_relation").val(value);
    $("#guardian_phone").val($(document).find('input[name="' + value + '_phone"]').attr('value'));
    $("#guardian_occupation").val($(document).find('input[name="' + value + '_occupation"]').attr('value'));
});

$(document).on('change', '.__sms__change__section', function () {
    let refId = $('.__sms__change__section').val();
    let gradeId = $('#_ref_class_id').val();
    let url = $('.__sms__change__section').data("url");

    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: 'POST',
        data:{
            grade: gradeId,
            division: refId
        },
        success: function (data) {
            $(".__sms_class_teacher").val(data.classTeacherName);
        },
        error: function () {
            alert("Something Went Wrong!");
        }
    });
});

function getDivisions() {
    let url = actionUrl._get_division;
    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: 'POST',
        success: function (data) {
            $(".__divisions__data__checkbox").html(data.gradeDivisions);
        },
        error: function (jqXHR, exception) {

        }
    });
}

function getClassSectionUrl(refId, classId) {
    let url = actionUrl._get_class_section_url.replace('classId', refId);

    $.ajax({
        url: url,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: 'POST',
        success: function (data) {
            $(".__replace__section__byClass").html(data.classSections);
            $("#section_id option[value="+classId+"]").prop('selected', true);
        },
        error: function () {
            alert("Something Went Wrong!");
        },
    });
}

function showSuccessDialog(msg) {
    Swal.fire({
        position: "bottom-center",
        icon: "success",
        title: msg,
        showConfirmButton: false,
        timer: 1500,
    });
}

function showErrorDialog(title, message) {
    Swal.fire({
        icon: "error",
        title: title,
        text: message,
        footer: "",
    });
}

function showDeleteDialog() {
    let flag = false;
    Swal.fire({
        title: commonMessage.__destroy_confirmation_message,
        text: commonMessage.__no_revert_message,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: commonMessage.__yes_delete,
    }).then((result) => {
        if (result.value) {
            flag = true;
        }
        flag = false;
    });

    return flag;
}

function deleteSuccessDialog() {
    Swal.fire(commonMessage.__deleted, commonMessage.__deleted_message, commonMessage.__success);
}
