<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAccountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('accounts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('user_id');
            $table->string('account_code', 100)->nullable();
            $table->string('name', 100);
            $table->string('address', 255)->nullable();
            $table->string('reg_no', 100)->nullable();
            $table->date('reg_date')->nullable();
            $table->enum('school_type', ['Private', 'Government', 'Self Finance', 'Not Specified'])->nullable();
            $table->enum('school_category', ['Primary', 'Secondary', 'University', 'Not Specified'])->nullable();
            $table->string('contact_number', 100)->nullable();
            $table->string('email', 100)->nullable();
            $table->string('website', 100)->nullable();
            $table->string('pincode', 100)->nullable();
            $table->string('logo', 150)->nullable();
            $table->date('school_start_year', 150)->nullable();
            $table->string('domain_alias', 255);
            $table->text('about_us')->nullable();
            $table->tinyInteger('is_activated')->default(0);
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('accounts');
    }
}
