<?php

namespace App;

use App\Modules\Staff\Model\Staff;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable, SoftDeletes;

    protected $guard = 'web';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'account_id',
        'user_id',
        'name',
        'email',
        'gender',
        'dob',
        'mobile_number',
        'blood_group',
        'join_date',
        'permanent_address',
        'current_address',
        'email_verified_at',
        'password',
        'role_id',
        'avatar',
        'created_by',
        'updated_by',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * @return BelongsTo
     */
    public function account()
    {
        return $this->belongsTo('App\Models\Account', 'account_id');
    }

    /**
     * @return BelongsTo
     */
    public function role()
    {
        return $this->belongsTo('App\Models\Role', 'role_id')->withDefault();
    }

    /**
     * @return mixed
     */
    public function userSetting()
    {
        return $this->hasMany('App\Models\UserSetting', 'user_id')->withDefault();
    }

    /**
     * @return mixed
     */
    public function student()
    {
        return $this->hasOne('App\Modules\Student\Model\Student', 'user_id')->withDefault();
    }

    /**
     * @return mixed
     */
    public function staff()
    {
        return $this->hasOne(Staff::class, 'user_id')->withDefault();
    }
}
