<?php

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | This file is where you may define all of the routes that are handled
  | by your module. Just tell Laravel the URIs it should respond
  | to using a Closure or controller method. Build something great!
  |
 */

Route::group(['middleware' => ['auth:web,saas', 'acl']], function () {
    Route::resource('timetable', 'TimetableController');

    Route::get('calender-timetable/events', ['as'   => 'timetable.calender_events', 'uses' => 'TimetableController@getCalendarEvents']);
    Route::get('calender-timetable/check-teacher-availability', ['as'   => 'timetable.teacher_availability', 'uses' => 'TimetableController@checkAvailability']);

    Route::resource('file_manager', 'FileController');
//    Route::post('crud-file_manager/{fileId?}', ['as'   => 'file_manager.crud', 'uses' => 'FileController@crud']);
    Route::post('upload-file-manager', ['as'   => 'file_manager.upload', 'uses' => 'FileController@uploadFile']);
    Route::get('study-material', ['as'   => 'study-material.index', 'uses' => 'FileController@studyMaterial']);

//    Route::post('calender-timetable/update-event/{eventId}', ['as'   => 'timetable.event-update', 'uses' => 'TimetableController@eventUpdate']);

    Route::resource('lectures', 'LectureController');
    Route::get('/test', ['as' => 'lectures.test', 'uses' => 'LectureController@test']);

    Route::get('teacher-timetable', ['as'   => 'teacher-timetable.index', 'uses' => 'TimetableController@teacherTimetable']);
    Route::get('teacher-timetable/events', ['as'   => 'teacher-timetable.events', 'uses' => 'TimetableController@getTeacherEvents']);

    Route::get('student-timetable', ['as'   => 'student-timetable.index', 'uses' => 'TimetableController@studentTimetable']);
    Route::get('student-timetable/events', ['as'   => 'student-timetable.events', 'uses' => 'TimetableController@getStudentEvents']);
});
