@extends('layouts.master')
@section('pageTitle') @include('layouts.includes.title', ['moduleTitle' => __('locale.timetable')]) @stop
@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('locale.timetable').' '. __('locale.details') ]) @stop
@section('content')
    <div class="row __sms__datatable">
        <div class="col-lg-12">
            <div class="card card-topline-yellow">
                <div class="card-body ">
                    <div class="row">
                        <div id="">Notification:</div>
                        <div id="notification"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('scripts')

    <script>
        window.laravel_echo_port='{{env("LARAVEL_ECHO_PORT")}}';
    </script>
    <script src="//{{ \Illuminate\Support\Facades\Request::getHost() }}:{{env('LARAVEL_ECHO_PORT')}}/socket.io/socket.io.js"></script>
    <script src="{{ url('/js/laravel-echo-setup.js') }}" type="text/javascript"></script>

    <script type="text/javascript">
        let i = 0;
        window.Echo.channel('user-channel')
            .listen('.UserEvent', (data) => {
                i++;
                $("#notification").append('<div class="alert alert-success">'+i+'.'+data.title+'</div>');
            });
    </script>

@stop

