<?php

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | This file is where you may define all of the routes that are handled
  | by your module. Just tell Laravel the URIs it should respond
  | to using a Closure or controller method. Build something great!
  |
 */

    Route::group(['middleware' => ['auth:web,saas', 'acl']], function () {
    Route::resource('students', 'StudentController');
    Route::resource('class', 'ClassController');
    Route::resource('section', 'SectionController');
    Route::resource('class-teacher', 'ClassTeacherController');
    Route::resource('subject', 'SubjectController');

    Route::post('crud-section/{sectionId?}', ['as'   => 'section.crud', 'uses' => 'SectionController@crud']);
    Route::post('crud-class/{classId?}', ['as'   => 'class.crud', 'uses' => 'ClassController@crud']);
    Route::post('crud-class-teacher/{cstId?}', ['as'   => 'class-teacher.crud', 'uses' => 'ClassTeacherController@crud']);
    Route::post('crud-subject/{subjectId?}', ['as'   => 'subject.crud', 'uses' => 'SubjectController@crud']);
    Route::post('change-class/{classId}', ['as'   => 'class.ajax_on_change', 'uses' => 'ClassController@onChangeClass']);
    Route::post('change-division', ['as'   => 'division.ajax_on_change', 'uses' => 'SectionController@getClassTeacherName']);
    Route::post('get-divisions/', ['as'   => 'class.get_divisions', 'uses' => 'ClassController@getDivisions']);
    Route::any('import-students/', ['as'   => 'import-students.index', 'uses' => 'StudentController@import']);
    Route::any('import-students/save', ['as'   => 'import-students.save', 'uses' => 'StudentController@importSave']);
    Route::any('import-subjects/', ['as'   => 'import-subjects.index', 'uses' => 'SubjectController@import']);
    Route::any('import-subjects/save', ['as'   => 'import-subjects.save', 'uses' => 'SubjectController@importSave']);
    Route::get('students-profile', ['as' => 'students.profile','uses' => 'StudentController@studentProfile']);
	Route::get('students-biology', ['as' => 'students.biology','uses' => 'StudentController@studentBiology']);
	Route::get('students-3dinteractives', ['as' => 'students.3dinteractives','uses' => 'StudentController@student3DInteractives']);
	Route::get('students-chemistry', ['as' => 'students.chemistry','uses' => 'StudentController@studentChemistry']);
	Route::get('students-physics', ['as' => 'students.physics','uses' => 'StudentController@studentPhysics']);
    Route::patch('update-students-profile/{staffId}', ['as' => 'students-profile.update','uses' => 'StudentController@updateStudentProfile']);
});
