@extends('layouts.master')
@section('pageTitle') @include('layouts.includes.title', ['moduleTitle' => __('Student')]) @stop

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('Add').' '.__('student') ]) @stop

@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="card-box">
                @include('layouts.modules.header', [ 'title' => __('student::locale.student_admission')])
                <div class="card-body row">
                    @if(isset($student) && isset($isStudentProfile))
                        {!! Form::model($student, ['route' => ['students-profile.update', $student->id] ,'files' => true, "type" => "card" ]) !!}
                    @elseif(isset($student))
                        {!! Form::model($student, ['route' => [$moduleName.'.update', $student->id] ,'files' => true, "type" => "card" ]) !!}
                    @else
                        {!! Form::open([ 'route' => $moduleName.'.store' ,'files' => true, "type" => "card"]) !!}
                    @endif
                        {!! Form::hidden('user_id', $student->user->id ??  old('user_id')) !!}

                        <div class="row {{ \App\Facades\General::isSchoolAdmin() ? 'show' : 'hide'  }}">
                            {!!  Form::openGroup('admission_no', __('student::locale.admission_no')) !!}
                            {!!  Form::text('admission_no', $student->admission_no ?? old('admission_no') ) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('roll_no', __('student::locale.roll_no')) !!}
                            {!!  Form::text('roll_no', $student->roll_no ?? old('roll_no')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('class_id', __('student::locale.class') ,array("lbl_class" => "required")) !!}
                            {!!  Form::select('class_id', [null=>__('locale.please_select')] +$data['studentClasses'], $student->class_id ?? old('class_id'), array("required" => "true", 'class'=> 'form-control __change__student__class', 'data-url' => route('class.ajax_on_change', 'classId'),'defaultTxt' => __( 'locale.select' ) ) ) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('section_id', __('student::locale.section') ,array("lbl_class" => "required")) !!}
                            <div class="__replace__section__byClass">
                                {!!  Form::select('section_id', [null=>__('locale.please_select')]+$data["sections"],$student->section_id ?? old('section_id'), array("required" => "true", 'class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ) !!}
                            </div>
                            {!!  Form::closeGroup() !!}
                        </div>

                    <div class="row">
                        {!!  Form::openGroup('name', __('locale.name'),array("lbl_class" => "required")) !!}
                        {!!  Form::text('name',$student->user->name ?? old('name'),array("required" => true)) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('gender', __('student::locale.gender') ) !!}
                        {!!  Form::select('gender', [null=>__('locale.please_select')]+$data['gender'],$student->user->gender ?? old('gender'), array('class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('dob', __('locale.dob')) !!}
                        {!!  Form::text('dob',$student->user->dob ?? old('dob'),[ "autocomplete" => "off",'class' => 'form-control setDatePicker']) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('category_id', __('student::locale.category') ) !!}
                        {!!  Form::select('category_id', [null=>__('locale.please_select')]+$data['categories'],$student->category_id ?? old('category_id'), array('class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ) !!}
                        {!!  Form::closeGroup() !!}
                    </div>

                    <div class="row">
                        {!!  Form::openGroup('religion', 'student::locale.religion') !!}
                        {!!  Form::text('religion',$student->religion ?? old('religion')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('cast', 'student::locale.cast') !!}
                        {!!  Form::text('cast',$student->cast ?? old('cast')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('mobile_number', 'student::locale.mobile_number',array("lbl_class" => "required")) !!}
                        {!!  Form::text('mobile_number',$student->user->mobile_number ?? old('mobile_number'),array("required" => true)) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('email', 'student::locale.email',array("lbl_class" => "required")) !!}
                        {!!  Form::text('email',$student->user->email ?? old('email'),array("required" => true)) !!}
                        {!!  Form::closeGroup() !!}
                    </div>

                    <div class="row">
                        {!!  Form::openGroup('admission_date', __('locale.admission_date')) !!}
                        {!!  Form::text('admission_date',$student->admission_date ?? old('admission_date'),["autocomplete" => "off",'class' => 'form-control setDatePicker']) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('avatar',  Lang::get('student::locale.avatar')) !!}
                        {!!  Form::file('avatar') !!}
                        @push("scripts-footer")
                            @php
                                $options = [];
                                if (isset($student->user->avatar)) {
                                    $options["initialPreview"][] = $student->user->avatar;
                                } @endphp
                            {!!  Form::filejs() !!}
                        @endpush
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('blood_group', __('student::locale.blood_group') ,array("lbl_class" => "required")) !!}
                        {!!  Form::select('blood_group', [null=>__('locale.please_select')]+$data['bloodGroup'],$student->user->blood_group ?? old('blood_group'), array("required" => "true",'class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('house_id', __('student::locale.house') ) !!}
                        {!!  Form::select('house_id', [null=>__('locale.please_select')]+$data['houses'],$student->house_id ?? old('house_id'), array('class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ) !!}
                        {!!  Form::closeGroup() !!}
                    </div>

                    <div class="row">
                        {!!  Form::openGroup('height', 'student::locale.height') !!}
                        {!!  Form::text('height',$student->height ?? old('height')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('weight', 'student::locale.weight') !!}
                        {!!  Form::text('weight',$student->weight ?? old('weight')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('measure_date', __('student::locale.measure_date')) !!}
                        {!!  Form::text('measure_date',$student->measure_date ?? old('measure_date'),["autocomplete" => "off",'class' => 'form-control setDatePicker']) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('medical_history', 'student::locale.medical_history') !!}
                        {!!  Form::textarea('medical_history',$student->medical_history ?? old('medical_history'),["rows" => 4]) !!}
                        {!!  Form::closeGroup() !!}
                    </div>
                </div>
            </div>

            @if(\App\Facades\General::isSchoolAdmin())
            <div class="card card-topline-aqua">
                @include('layouts.modules.header', [ 'title' => __('student::locale.parent_guardian_detail'), 'hide'=> true])
                <div class="card-body row">
                    <div class="row">
                        {!!  Form::openGroup('father_name', 'student::locale.father_name') !!}
                        {!!  Form::text('father_name', $student->father_name ?? old('father_name')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('father_phone', 'student::locale.father_phone') !!}
                        {!!  Form::text('father_phone', $student->father_phone ?? old('father_phone')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('father_occupation', 'student::locale.father_occupation') !!}
                        {!!  Form::text('father_occupation', $student->father_occupation ?? old('father_occupation')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('father_photo',  Lang::get('student::locale.father_photo')) !!}
                        {!!  Form::file('father_photo') !!}
                        @push("scripts-joining_letter")
                            {!!  Form::filejs() !!}
                        @endpush
                        {!!  Form::closeGroup() !!}
                    </div>
                    <div class="row">
                        {!!  Form::openGroup('mother_name', 'student::locale.mother_name') !!}
                        {!!  Form::text('mother_name', $student->mother_name ?? old('mother_name')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('mother_phone', 'student::locale.mother_phone') !!}
                        {!!  Form::text('mother_phone', $student->mother_phone ?? old('mother_phone')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('mother_occupation', 'student::locale.mother_occupation') !!}
                        {!!  Form::text('mother_occupation', $student->mother_occupation ?? old('mother_occupation')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('mother_photo',  Lang::get('student::locale.mother_photo')) !!}
                        {!!  Form::file('mother_photo') !!}
                        @push("scripts-joining_letter")
                            {!!  Form::filejs() !!}
                        @endpush
                        {!!  Form::closeGroup() !!}
                    </div>
                    <div class="row">
                        <div class="col-lg-12 p-t-20 text-right">
                            <label>{{ __('student::locale.if_guardian_is') }}
                                <small class="req"> *</small>&nbsp;&nbsp;&nbsp;</label>
                            <label class="radio-inline">
                                <input type="radio" name="guardian_is" value="father" class="__sms__copy__guardian"
                                       {{ isset($student) && $student->guardian_is == 'father' ? 'checked' : '' }} autocomplete="off"> {{ __('student::locale.father') }}
                            </label>
                            {{--{!!  Form::radio('guardian_is','father', $student->guardian_is,[ "class" => "choice", "autocomplete" => "off" ]) !!}--}}
                            <label class="radio-inline">
                                <input type="radio" name="guardian_is" value="mother"
                                       class="__sms__copy__guardian" {{ isset($student) && $student->guardian_is == 'mother' ? 'checked' : '' }}> {{ __('student::locale.mother') }}
                            </label>
                            <label class="radio-inline">
                                <input type="radio" name="guardian_is" value="other"
                                       class="__sms__copy__guardian" {{ isset($student) && $student->guardian_is == 'other' ? 'checked' : '' }}> {{ __('student::locale.other') }}
                            </label>
                            <span class="text-danger"></span>
                        </div>
                    </div>
                    <div class="row">
                        {!! Form::hidden('guardian_id', $student->guardian->id ??  old('guardian_id')) !!}
                        {!!  Form::openGroup('guardian_name', 'student::locale.guardian_name') !!}
                        {!!  Form::text('guardian_name', $student->guardian->name ??  old('guardian_name')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('guardian_relation', 'student::locale.guardian_relation') !!}
                        {!!  Form::text('guardian_relation', $student->guardian_relation ?? old('guardian_relation')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('guardian_email', 'student::locale.guardian_email') !!}
                        {!!  Form::text('guardian_email', $student->guardian->email ??  old('guardian_email')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('guardian_avatar',  Lang::get('student::locale.guardian_avatar')) !!}
                        {!!  Form::file('guardian_avatar') !!}
                        @push("scripts-joining_letter")
                            {!!  Form::filejs() !!}
                        @endpush
                        {!!  Form::closeGroup() !!}
                    </div>
                    <div class="row">
                        {!!  Form::openGroup('guardian_phone', 'student::locale.guardian_phone') !!}
                        {!!  Form::text('guardian_phone', $student->guardian->mobile_number ??  old('guardian_phone')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('guardian_occupation', 'student::locale.guardian_occupation') !!}
                        {!!  Form::text('guardian_occupation', $student->guardian_occupation ?? old('guardian_occupation')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('guardian_address', 'student::locale.guardian_address', ["class" => "col-lg-6"]) !!}
                        {!!  Form::textarea('guardian_address', $student->guardian->current_address ??  old('guardian_address'),["rows" => 3]) !!}
                        {!!  Form::closeGroup() !!}
                    </div>
                </div>
            </div>
            @endif

            <div class="card card-topline-aqua">
                @include('layouts.modules.header', [ 'title' => __('student::locale.student_address_details'), 'hide'=> true])
                <div class="card-body row">
                    <div class="row">
                        <div class="col-lg-6 p-t-20">
                            <label>
                                <input type="checkbox" id="__fill__current__address">
                                {{ __('student::locale.guardian_address_is_current_address') }}
                            </label>
                        </div>
                        <div class="col-lg-6 p-t-20">
                            <label>
                                <input type="checkbox" id="__fill__permanent__address">
                                {{ __('student::locale.permanent_address_is_current_address') }}
                            </label>
                        </div>

                        {!!  Form::openGroup('current_address', 'student::locale.current_address', ["class" => "col-lg-6", "lbl_class" => "required"]) !!}
                        {!!  Form::textarea('current_address',$student->user->current_address ?? old('current_address'),["required" => "true","rows" => 3]) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('permanent_address', 'student::locale.permanent_address', ["class" => "col-lg-6", "lbl_class" => "required"]) !!}
                        {!!  Form::textarea('permanent_address',$student->user->permanent_address ?? old('permanent_address'),["required" => "true","rows" => 3]) !!}
                        {!!  Form::closeGroup() !!}
                    </div>
                </div>
            </div>

            @if(\App\Facades\General::isSchoolAdmin())
            <div class="card card-topline-aqua">
                @include('layouts.modules.header', [ 'title' => __('student::locale.miscellaneous_details'), 'hide'=> true])
                <div class="card-body row">
                    <div class="row">
                        {!!  Form::openGroup('bank_account_no', 'student::locale.bank_account_no') !!}
                        {!!  Form::text('bank_account_no', $student->bank_account_no ?? old('bank_account_no')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('bank_name', 'student::locale.bank_name') !!}
                        {!!  Form::text('bank_name', $student->bank_name ?? old('bank_name')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('ifsc_code', 'student::locale.ifsc_code') !!}
                        {!!  Form::text('ifsc_code', $student->ifsc_code ?? old('ifsc_code')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('bank_branch', 'student::locale.bank_branch') !!}
                        {!!  Form::text('bank_branch', $student->bank_branch ?? old('bank_branch')) !!}
                        {!!  Form::closeGroup() !!}
                    </div>
                    <div class="row">
                        {!!  Form::openGroup('national_ident_no', 'student::locale.national_ident_no') !!}
                        {!!  Form::text('national_ident_no', $student->national_ident_no ?? old('national_ident_no')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('local_ident_no', 'student::locale.local_ident_no') !!}
                        {!!  Form::text('local_ident_no', $student->local_ident_no ?? old('local_ident_no')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('prev_school', 'student::locale.prev_school') !!}
                        {!!  Form::text('prev_school', $student->prev_school ?? old('prev_school')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('note', 'student::locale.note') !!}
                        {!!  Form::textarea('note', $student->note ?? old('note'), ["rows" => 3]) !!}
                        {!!  Form::closeGroup() !!}
                    </div>
                </div>
            </div>
            @endif
            <div class="row"> @include('layouts.forms.actions')</div>
            {!! Form::close() !!}
        </div>
@stop
@section('scripts')
@stop
