@extends('layouts.master')
@section('pageTitle') @include('layouts.includes.title', ['moduleTitle' => __('locale.classes')]) @stop
@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('locale.class').' '. __('locale.details') ]) @stop
@section('content')
    <div class="row __sms__datatable">
        <div class="col-lg-4">
            <div class="card card-topline-yellow">
                <div class="card-head">
                    <header>{{ __('locale.assign').' '.__('locale.classteacher') }} </header>
                </div>
                <div class="card-body ">
                    <div class="row text-center m-t-10">
                        <div class="form-group col-lg-12">

                            {!!  Form::openGroup('class_id', __('student::locale.class') ,array("lbl_class" => "required", "class" => 'col-lg-12')) !!}
                            {!!  Form::select('class_id', [null=>__('locale.please_select')] +$data['studentClasses'], '', array("required" => "true", 'id' => '_ref_class_id', 'class'=> 'form-control __change__student__class', 'data-url' => route('class.ajax_on_change', 'classId'),'defaultTxt' => __( 'locale.select' ) ) ) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('section_id', __('student::locale.section') ,array("lbl_class" => "required", "class" => 'col-lg-12')) !!}
                            <div class="__replace__section__byClass">
                                {!!  Form::select('section_id', [null=>__('locale.please_select')]+$data["sections"],'', array("required" => "true", 'id' => '_ref_section_id', 'class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ) !!}
                            </div>
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('staff_id', __('student::locale.staff') ,array("lbl_class" => "required", "class" => 'col-lg-12')) !!}
                            <div class="">
                                {!!  Form::select('staff_id', [null=>__('locale.please_select')]+$data["staffs"],'', array("required" => "true", 'id' => '_ref_staff_id', 'class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ) !!}
                            </div>
                            {!!  Form::closeGroup() !!}

                        </div>
                    </div>
                </div>
                <div class="card-footer text-right">
                    <button type="button"
                            class="btn btn-primary m-b-10 __sms__add__teacher__detail mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect btn-circle"
                            data-id="0" data-type="dialog6">Save
                    </button>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card card-topline-yellow">
                <div class="card-head">
                    <header>{{ __('locale.classteachers')}} </header>
                </div>
                <div class="card-body ">
                    <div class="table-scrollable">
                        <table id="{{$moduleName}}-table"
                               class="display table table-checkable order-column valign-middle __class__teacher__table"
                               style="width: 100%">
                            <thead>
                            <tr>
                                <th width="10%"> {{ __('locale.class') }}</th>
                                <th width="20%"> {{ __('locale.sections') }}</th>
                                <th width="20%"> {{ __('locale.teacher') }}</th>
                                <th width="15%"> {{ __('locale.actions') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('scripts')
    <link href="{{ asset('assets/plugins/sweet-alert/sweetalert2.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/css/pages/formlayout.css') }}" rel="stylesheet">
    <script src="{{ asset('assets/plugins/sweet-alert/sweetalert2.all.min.js') }}"></script>

    <script>
        let columnsArray = [{data: 'class', name: 'class'}, {data: 'section', name: 'section'}, {
            data: 'teacher',
            name: 'teacher'
        }, {data: 'action', name: 'action'}];
        let routeUrl = "{{ route($moduleName.'.index') }}";
        let tableRef = "{{ $moduleName.'-table'}}";
        // Run the Datatable
        let table = __commonDatatableListing(tableRef, routeUrl, columnsArray);
        let actionUrl = {
            '_add_edit_record': "{{ route($moduleName.'.crud', '_refSection') }}",
            '_edit_record': "{{ route($moduleName.'.edit', '_refSection') }}",
            '_destroy_record': "{{ route($moduleName.'.destroy', '_refSection') }}",
            {{--'_get_division': "{{ route($moduleName.'.get_divisions') }}",--}}
            '_success_msg': "{{ __('locale.teacher_saved') }}",
            '_get_class_section_url': "{{ route('class.ajax_on_change', 'classId') }}"
        };
        getDivisions();
    </script>
@stop

