<?php

namespace App\Modules\Student\Requests;

use App\Facades\General;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreClass extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id    = $this->segment(2);
        $accountId = General::getAccountId();
        return [
            'title' => [
                'required',
                Rule::unique('classes')->where(function ($query) use($id,$accountId) {
                    $query->where('account_id', $accountId);
                    if ($id>0){
                        $query->where('id', '!=', $id);
                    }
                    return $query;
                }),
            ]
        ];
    }
}
