<?php

namespace App\Modules\Student\Model;

use App\Models\Crud;
use App\Models\Tenant;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Throwable;
use Yajra\DataTables\Facades\DataTables;

class Subject extends Tenant
{

    use SoftDeletes;

    protected $fillable = ['account_id', 'title', 'created_by', 'updated_by'];

    /**
     * Return section lists
     *
     * @return void
     */
    public static function getSubjects()
    {
        try
        {
            $subjectResults = self::orderBy('title', 'ASC')->get();
            $subjectValues  = [];
            foreach ($subjectResults as $subjectResult)
            {
                $subjectValues[$subjectResult->id] = $subjectResult->title;
            }

            return $subjectValues;
        } catch (Exception $e)
        {
            return '';
        }
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public static function getDatatableSubjects()
    {
        $options            = array();
        $options['object']  = true;
        $options['orderBy'] = "id";
        $options['order']   = "DESC";

        $subject = new Subject();
        $model   = $subject->find($options);
        return DataTables::eloquent($model)
                        ->addColumn('action', function (Subject $subject) {
                            return $subject->returnAjaxAction('section', $subject, ['edit', 'destroy']);
                        })
                        ->rawColumns(['action'])
                        ->make(true);
    }

    /**
     * Return house name nby house id
     *
     * @param $classId
     * @return mixed
     */
    public function getSubjectByTitle($title)
    {
        return self::where('title', $title)->pluck('id')->first();
    }

}
