<?php

namespace App\Modules\Student\Model;

use App\Models\Crud;
use App\Models\Tenant;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class CastCategory extends Tenant
{

    use SoftDeletes;

    protected $fillable = ['account_id', 'title', 'created_by', 'updated_by'];


    /**
     * @return mixed
     */
    public function student()
    {
        return $this->hasMany('App\Modules\Student\Model\Student', 'category_id')->withDefault();
    }

    /**
     * Return category lists
     *
     * @return void
     */
    public static function getCategories()
    {
        try {
            $categoryResults = self::get();
            $categoryValues  = [];

            foreach ($categoryResults as $categoryResult) {
                $categoryValues[$categoryResult->id] = $categoryResult->title;
            }

            return $categoryValues;

        } catch (Exception $e) {
            return '';
        }
    }

    /**
     * return cast category by category id
     *
     * @param $categoryId
     * @return mixed
     */
    public static function getCastCategory($categoryId)
    {
        if (isset($categoryId) && !empty($categoryId) && !is_null($categoryId)) {
            return self::where('id', $categoryId)->pluck('title')->first();
        } else {
            return null;
        }
    }
}
