<?php

namespace App\Modules\Student\Http\Controllers;

use App\Facades\General;
use App\Modules\Student\Model\ClassSection;
use App\Modules\Student\Model\Section;
use App\Modules\Student\Model\Student;
use App\Modules\Student\Model\StudentClass;
use App\Modules\Student\Requests\StoreSection;
use Exception;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Modules\Student\Http\Requests\StoreStudent;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Session;
use Illuminate\View\View;

class SectionController extends Controller
{
    /**
     * Module variable
     *
     * @var array
     */
    protected $moduleName;

    /**
     * Class Constructor.
     *
     * @return string
     */
    public function __construct()
    {
        $this->moduleName = $this->getModuleName();
    }

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return JsonResponse
     * @throws Exception
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return Section::getDatatableSections();
        }

        General::userLog('SL000501', ['action_module' => $this->moduleName]);
        return View('student::section.index', ['moduleName' => $this->moduleName]);
    }

    /**
     * Crud method of section
     *
     * @param StoreSection $request
     * @param int $sectionId
     * @return JsonResponse
     */
    public function crud(StoreSection $request, $sectionId = 0)
    {
        $section    = (new Section())->findById($sectionId);
        $insert     = false;
        $activityId = null;
        if ($section == null) {
            $section = new Section();
            $insert  = true;
        }
        $section->fill($request->all());
        $section->account_id = Config::get('account.id');
        if ($insert == true) {
            $section->created_by = Auth::user()->id;
            $activityId          = 'SL000502';
        } else {
            $section->updated_by = Auth::user()->id;
            $activityId          = 'SL000503';
        }
        $section->save();

        General::userLog($activityId, [
            'action_module' => $this->moduleName,
            'parent_id'     => $section->id,
            'event_data'    => ['name' => $section->title, 'url' => route($this->moduleName . '.edit', $section->id)]
        ]);

        return response()->json(["status" => 'added'], 200);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param $sectionId
     * @return JsonResponse
     */
    public function edit($sectionId)
    {
        if (request()->ajax()) {
            $data = Section::findOrFail($sectionId);
            return response()->json(['result' => $data]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Student $section
     * @return RedirectResponse
     * @throws Exception
     */
    public function destroy($section)
    {
        if (request()->ajax()) {
            $section = (new Section())->findById($section);
            General::userLog('SL000505', [
                'action_module' => $this->moduleName,
                'parent_id'     => $section->id,
                'event_data'    => ['name' => $section->title]
            ]);
            $section->delete();

            return response()->json(['msg' => trans('locale.success_delete_msg')]);
        }
    }

    /**
     * Return class
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function getClassTeacherName(Request $request)
    {
        $classTeacherName = ClassSection::getClassTeacherNameByClass($request->grade, $request->division);

        return response()->json(["classTeacherName" => $classTeacherName], 200);
    }

    /**
     * Get Module name.
     *
     * @return string
     */
    public function getModuleName()
    {
        return "section";
    }

}
