<?php

namespace App\Modules\Student\Http\Controllers;

use App\Facades\General;
use App\Modules\Staff\Model\Staff;
use App\Modules\Student\Model\ClassSection;
use App\Modules\Student\Model\Section;
use App\Modules\Student\Model\StudentClass;
use App\Modules\Student\Requests\StoreClass;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Modules\Student\Http\Requests\StoreStudent;
use Throwable;

class ClassTeacherController extends Controller
{
    /**
     * Module variable
     *
     * @var array
     */
    protected $moduleName;

    /**
     * Class Constructor.
     *
     * @return string
     */
    public function __construct()
    {
        $this->moduleName = $this->getModuleName();
    }

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return JsonResponse
     * @throws Exception
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            return ClassSection::getDatatableClassTeachers();
        }

        $data["studentClasses"] = StudentClass::getStudentClasses();
        $data["sections"]       = Section::getSections();
        $data["staffs"]         = Staff::getTeachers();

        General::userLog('SL000701', ['action_module' => $this->moduleName]);
        return View('student::class_teacher.index', ['moduleName' => $this->moduleName, 'data' => $data]);
    }

    /**
     * Crud method of section
     *
     * @param Request $request
     * @param int $studentClassId
     * @return JsonResponse
     */
    public function crud(Request $request, $studentClassId = 0)
    {

        $input['class_id']   = $request->_ref_class_id;
        $input['section_id'] = $request->_ref_section_id;
        $input['staff_id']   = $request->_ref_staff_id;
        $classTeacher = ClassSection::updateOrCreate([
            "class_id" => $request->_ref_class_id,
            'section_id' => $request->_ref_section_id
        ], $input);

        General::userLog('SL000702', [
            'action_module' => $this->moduleName,
            'parent_id'     => $classTeacher->id,
            'event_data'    => ['name' => $classTeacher->id,
                                'url'  => route($this->moduleName . '.edit', $classTeacher->id)]
        ]);

        return response()->json(["status" => 'added'], 200);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param $classId
     * @return JsonResponse
     * @throws Throwable
     */
    public function edit($classId)
    {
        if (request()->ajax()) {
            $data           = ClassSection::findOrFail($classId);

            return response()->json(['result' => $data]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param $classId
     * @return JsonResponse
     * @throws Exception
     */
    public function destroy($classId)
    {
        if (request()->ajax()) {
            $classSection = (new ClassSection())->findById($classId);
            General::userLog('SL000705', [
                'action_module' => $this->moduleName,
                'parent_id'     => $classSection->id,
                'event_data'    => ['name' => $classSection->title]
            ]);
            $classSection->staff_id = null;
            $classSection->save();

            return response()->json(['msg' => trans('locale.success_delete_msg')]);
        }
    }

    /**
     * Get Module name.
     *
     * @return string
     */
    public function getModuleName()
    {
        return "class-teacher";
    }

}
