@extends('layouts.master')

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('Staff').' '. __('Details') ]) @stop

@section('content')
    <!--begin::Form-->
    @if(isset($staff))
        {{ Form::model($staff, ['route' => [$moduleName.'.update', $staff->id], 'method' => 'post', 'enctype' => "multipart/form-data"]) }}
        @method('PATCH')
    @else
        {{ Form::open(['route' => $moduleName.'.store', 'enctype' => "multipart/form-data"]) }}
    @endif
    @csrf

    <div class="row __sms__show__details">
        <div class="col-md-12">
            <!-- BEGIN PROFILE SIDEBAR -->
            <div class="profile-sidebar">
                <div class="card card-topline-aqua">
                    <div class="card-body no-padding height-9">
                        <div class="row">
                            <div class="profile-userpic">
                               <img src="{{ \Illuminate\Support\Facades\Storage::url( $staff->user->avatar ?? 'avatars/dp.png') }}" class="img-responsive" alt="">
                            </div>
                        </div>
                        <div class="profile-usertitle">
                            <div class="profile-usertitle-name text-muted ">{{ $staff->user->name }}</div>
                        </div>
                        <ul class="list-group list-group-unbordered">
                            <li class="list-group-item">
                                <b class="float-left text-muted mb-0">{{ __("staff::locale.staff_id") }}</b>
                                <a class="pull-right">{{ $staff->staff_id }}</a>
                            </li>
                            <!--<li class="list-group-item">
                                <b class="float-left text-muted mb-0">{{ __("staff::locale.role") }}</b>
                                <a class="pull-right"></a>
                            </li>-->
                            <li class="list-group-item">
                                <b class="float-left text-muted mb-0">{{ __("staff::locale.designation") }}</b>
                                <a class="pull-right">{{ $staff->designation->title }}</a>
                            </li>
                            <li class="list-group-item">
                                <b class="float-left text-muted mb-0">{{ __("staff::locale.department") }}</b>
                                <a class="pull-right">{{  $staff->department->title }}</a>
                            </li>
                            <li class="list-group-item">
                                <b class="float-left text-muted mb-0">{{ __("staff::locale.mobile_number") }}</b>
                                <a class="pull-right">{{ $staff->user->mobile_number }}</a>
                            </li>
                        </ul>
                        <!-- END SIDEBAR USER TITLE -->
                    </div>
                </div>

                <div class="card">
                    <div class="card-head card-topline-aqua">
                        <header>Address</header>
                    </div>
                    <div class="card-body no-padding height-9">
                        <div class="row text-center m-t-10">

                            <div class="col-md-12 mt-4">
                                <label class="text-muted mb-0 float-left">Current Address</label><br>
                                <p class="float-left">{{ $staff->user->current_address }}</p>
                            </div>
                            <div class="col-md-12 mt-4">
                                <label class="text-muted mb-0 float-left">Permanent Address</label><br>
                                <p class="float-left">{{ $staff->user->permanent_address }}</p>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- END BEGIN PROFILE SIDEBAR -->

            <!-- BEGIN PROFILE CONTENT -->
            <div class="profile-content">
                <div class="row">
                    <div class="card">
                        <div class="card-head card-topline-aqua">
                                <header>Staff Details</header>
                        </div>
                        <div class="white-box">
                            <!-- Nav tabs -->
                            <div class="card-body no-padding height-9">
                                    <div id="biography">
                                        <div class="row">
                                            <div class="col-md-3 col-6 b-r mt-4">
                                                <label class="text-muted mb-0">Joining Date</label><br>
                                                <p>{{ \Carbon\Carbon::parse($staff->joining_date)->format('d/m/Y') }}</p>
                                            </div>
                                            <div class="col-md-3 col-6 b-r mt-4">
                                                <label class="text-muted mb-0">Date of Birth</label><br>
                                                <p>{{ \Carbon\Carbon::parse($staff->user->dob)->format('d/m/Y') }}</p>
                                            </div>
                                            <div class="col-md-3 col-6 b-r mt-4">
                                                <label class="text-muted mb-0">{{ __('staff::locale.marital_status') }}</label><br>
                                                <p>{{ $staff->marital_status }}</p>
                                            </div>
                                            <div class="col-md-3 col-6 mt-4">
                                                <label class="text-muted mb-0">Mobile Number</label><br>
                                                <p>{{ $staff->user->mobile_number }}</p>
                                            </div>
                                            <div class="col-md-3 col-6 mt-4">
                                                <label class="text-muted mb-0">Email</label><br>
                                                <p>{{ $staff->user->email }}</p>
                                            </div>
                                            <div class="col-md-3 col-6 mt-4">
                                                <label class="text-muted mb-0">{{ __("staff::locale.father_name") }}</label><br>
                                                <p>{{ $staff->user->father_name }}</p>
                                            </div>
                                            <div class="col-md-6 col-6 mt-4">
                                                <label class="text-muted mb-0">{{ __("staff::locale.mother_name") }}</label><br>
                                                <p>{{ $staff->user->mother_name }}</p>
                                            </div>
                                            <div class="col-md-3 col-6 mt-4">
                                                <label class="text-muted mb-0">{{ __("staff::locale.qualification") }}</label><br>
                                                <p>{{ $staff->qualification }}</p>
                                            </div>
                                            <div class="col-md-3 col-6 mt-4">
                                                <label class="text-muted mb-0">{{ __("staff::locale.work_exp") }}</label><br>
                                                <p>{{ $staff->work_exp }}</p>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- END PROFILE CONTENT -->
        </div>
    </div>
@stop
@section('scripts')

@stop

