<?php

namespace App\Models;

use App\Traits\TenantableTrait;
use Illuminate\Support\Facades\Config;

class Tenant extends Crud
{
    use TenantableTrait;

    /**
     * Class Constructor.
     *
     * Tenant constructor.
     * @param array $options
     */
    public function __construct($options = [])
    {
        parent::__construct();
        if (!empty($options["account_id"])) {
            Config::set("account.id", $options["account_id"]);
        }
    }

    /**
     * Fillable fields
     *
     * @var array
     */
    protected $fillable = [
        'account_id',
    ];

    public function account()
    {
        return $this->belongsTo(Account::class, 'account_id');
    }

}
