<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include("inc/template.php");

function main() {
    global $conn;
    require_once 'models/FyModel.php';
    $fyModel = new FyModel($conn);
    $financialYear = $fyModel->getActiveFinancialYearId();
    $financialYearId = $financialYear['id'];
    $financialYearLabel = $financialYear['year_label'];
?>
<div class="container-xxl flex-grow-1 container-p-y">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb breadcrumb-custom-icon">
            <li class="breadcrumb-item"><a href="dashboard.php">Home</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i></li>
            <li class="breadcrumb-item"><a href="newspepars_order_list.php">Pepar Order List</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i></li>
            <li class="breadcrumb-item active">Pepar Order Edit</li>
        </ol>
    </nav>

    <form id="newsForm">
        <div class="card mb-4 shadow-sm">
            
            <div class="card-body">
                <div class="row g-3 mb-3">
                    <!-- Bill Date -->
                    <div class="col-md-3">
                        <label for="sale_date" class="form-label">Bill Date</label>
                        <input type="date" class="form-control" name="sale_date" id="sale_date" value="<?= date('Y-m-d') ?>" required>
                    </div>

                    <!-- Bill No -->
                    <div class="col-md-3">
                        <label for="bill_no" class="form-label">Bill No.</label>
                        <input type="text" class="form-control" name="bill_no" id="bill_no" required>
                    </div>

                    <!-- Agency -->
                    <div class="col-md-6">
                        <label for="agency_id" class="form-label">Agency Name</label>
                        <select name="agency_id" id="agency_id" class="form-select" required>
                            <option value="">-- Select Agency --</option>
                            <?php
                            require_once 'models/AgencyModel.php';
                            $agencyModel = new AgencyModel($conn);
                            $agencies = $agencyModel->dropdownAgency();
                            while ($row = $agencies->fetch_assoc()) {
                                echo '<option value="' . $row['id'] . '">' . ucwords(htmlspecialchars($row['agencyname'])) . '</option>';
                            }
                            ?>
                        </select>
                    </div>

                    <!-- Newspaper -->
                    <div class="col-md-6">
                        <label for="newspaper_id" class="form-label">Newspaper Name</label>
                        <select name="newspaper_id" id="newspaper_id" class="form-select">
                            <option value="">-- Select Paper --</option>
                            <?php
                            require_once 'models/NewspaperModel.php';
                            $newspaperModel = new NewspaperModel($conn);
                            $newspapers = $newspaperModel->dropdownnewpepars();
                            while ($row = $newspapers->fetch_assoc()) {
                                echo '<option value="' . $row['id'] . '" data-price="' . $row['price'] . '">' . ucwords(htmlspecialchars($row['name'])) . '</option>';
                            }
                            ?>
                        </select>
                    </div>

                    <!-- Rate -->
                    <div class="col-md-3">
                        <label for="price" class="form-label">Rate</label>
                        <input type="number" name="price" id="price" class="form-control" step="0.01" value="0.00">
                    </div>

                    <!-- Quantity -->
                    <div class="col-md-3">
                        <label for="qty" class="form-label">Quantity</label>
                        <input type="number" name="qty" id="qty" class="form-control" value="1">
                    </div>

                    <!-- Remarks -->
                    <div class="col-md-12">
                        <label for="remarks" class="form-label">Remarks</label>
                        <input type="text" class="form-control" name="remarks" id="remarks">
                    </div>
                </div>

                <!-- Hidden Inputs -->
                <input type="hidden" name="financial_year_id" value="<?= $financialYearId ?>">
                <input type="hidden" name="created_by" value="<?= $_SESSION['admin_id'] ?>">

                <!-- Add Product Button -->
                <div class="text-end mb-3">
                    <button type="button" class="btn btn-primary add-row">Add Product</button>
                </div>

                <!-- Product Table -->
                <div class="table-responsive">
                    <table class="table table-bordered table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Newspaper</th>
                                <th>Rate</th>
                                <th>Qty</th>
                                <th>Total</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="podata"></tbody>
                        <tfoot>
                            <tr>
                                <th colspan="3" class="text-end">Total Qty</th>
                                <th id="totalQty">0</th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="4" class="text-end">Subtotal</th>
                                <th id="subtotal">0.00</th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="4" class="text-end">Transport Charge</th>
                                <th><input type="number" id="transport" name="transport" style="width: 80px;" class="form-control form-control-sm" value="0" step="0.01"></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="4" class="text-end">Discount</th>
                                <th><input type="number" id="discount" name="discount" style="width: 80px;" class="form-control form-control-sm" value="0" step="0.01"></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="4" class="text-end">Grand Total</th>
                                <th id="grandtotal">0.00</th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <!-- Save Buttons -->
                <div class="text-end mt-3">
                    <button type="button" class="btn btn-success save-order">Update Order</button>
                    <button type="button" class="btn btn-success save-print">Update & Print</button>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
$(document).ready(function () {
	
  const updateId = <?= isset($_GET['updateid']) ? (int)$_GET['updateid'] : 0 ?>;
// Auto-set price
    $('#newspaper_id').on('change', function() {
        $('#price').val(parseFloat($(this).find(':selected').data('price') || 0).toFixed(2));
    });

  // Load existing order if editing
  if (updateId > 0) {
    $.get('controllers/NewsOrderController.php', {
      action: 'getOrderById',
      order_id: updateId
    }, function (res) {
      try {
        const data = JSON.parse(res);
        if (data.status === 'success') {
          fillForm(data.order, data.items);
        } else {
          alert(data.message || 'Failed to load order');
        }
      } catch (e) {
        console.error("Parse error", e);
      }
    });
  }

  // Fill form with order data
  function fillForm(order, items) {
    $('#sale_date').val(order.sale_date);
    $('#bill_no').val(order.bill_no);
    $('#agency_id').val(order.agency_id);
    $('#remarks').val(order.remarks || '');
    $('#transport').val(order.transport_charge);
    $('#discount').val(order.discount);

    $('#podata').empty();
    if (Array.isArray(items)) {
      items.forEach((item, idx) => {
        addRow(item.newspaper_id, item.newspaper_name, item.rate, item.qty, item.remarks);
      });
    }
    updateTotals();
  }

  // Add row handler
  $// Add row handler
$('.add-row').on('click', function () {
    const newspaperId = $('#newspaper_id').val();
    const newspaperName = $('#newspaper_id option:selected').text();
    const price = parseFloat($('#price').val()) || 0;
    const qty = parseInt($('#qty').val()) || 0;
    const remarks = $('#remarks').val() || '';
    const total = (price * qty).toFixed(2);

    // Check duplicate newspaper
    let exists = false;
    $('#podata input[name="newspaper_id[]"]').each(function() {
        if ($(this).val() == newspaperId) {   // ✅ fixed
            exists = true;
            return false; // stop loop
        }
    });
    if (exists) {
        alert('This newspaper is already added!');
        return;
    }

    if (!newspaperId) {
        alert("Please select a newspaper");
        return;
    }
    if (qty <= 0) {
        alert("Quantity must be greater than 0");
        return;
    }

    addRow(newspaperId, newspaperName, price, qty, remarks);
    updateTotals();

    // reset inputs
    $('#newspaper_id').val('');
    $('#price').val('0.00');
    $('#qty').val('1');
    $('#remarks').val('');
});


  // Add row to table
  function addRow(newspaperId, newspaperName, price, qty, remarks) {
    const total = (price * qty).toFixed(2);
    const row = `
      <tr>
        <td></td>
        <td>
          ${newspaperName}
          <input type="hidden" name="newspaper_id[]" value="${newspaperId}">
        </td>
        <td>
          ${price}
          <input type="hidden" name="price[]" value="${price}">
        </td>
        <td>
          ${qty}
          <input type="hidden" name="qty[]" value="${qty}">
        </td>
        <td>
          ${total}
          <input type="hidden" name="total[]" value="${total}">
        </td>
        <td>
          <button type="button" class="btn btn-xs btn-danger remove-row">Delete</button>
        </td>
      </tr>
    `;
    $('#podata').append(row);
  }

  // Delete row
  $(document).on('click', '.remove-row', function () {
    $(this).closest('tr').remove();
    updateTotals();
  });

  // Update totals
  function updateTotals() {
    let totalQty = 0;
    let subtotal = 0;
    $('#podata tr').each(function () {
      const qty = parseInt($(this).find('input[name="qty[]"]').val()) || 0;
      const total = parseFloat($(this).find('input[name="total[]"]').val()) || 0;
      totalQty += qty;
      subtotal += total;
    });

    $('#totalQty').text(totalQty);
    $('#subtotal').text(subtotal.toFixed(2));

    const transport = parseFloat($('#transport').val()) || 0;
    const discount = parseFloat($('#discount').val()) || 0;
    const grandtotal = subtotal + transport - discount;
    $('#grandtotal').text(grandtotal.toFixed(2));
  }

  // When transport/discount changes
  $('#transport, #discount').on('input', updateTotals);

  // Save order
  $('.save-order, .save-print').on('click', function () {
    if ($('#podata tr').length === 0) {
      alert("Add at least one newspaper.");
      return;
    }
    if (!$('#bill_no').val().trim()) {
      alert("Please enter Bill No.");
      return;
    }

    const formData = $('#newsForm').serializeArray();
    formData.push({name: "action", value: updateId > 0 ? "updateOrder" : "saveOrder"});
    if (updateId > 0) formData.push({name: "id", value: updateId});

    $.post('controllers/NewsOrderController.php', formData, function (res) {
      try {
        const data = JSON.parse(res);
        if (data.status === 'success') {
          if ($(this).hasClass('save-print')) {
            window.open('print_order.php?id=' + data.order_id, '_blank');
          }
          alert("Order saved successfully.");
          location.href = 'newspepars_order_list.php';
        } else {
          alert(data.message || "Failed to save order.");
        }
      } catch (err) {
        console.error(err);
        alert("Unexpected server response.");
      }
    }.bind(this));
  });
});
</script>

<?php } ?>
