<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>
	<div class="container-xxl flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
			<ol class="breadcrumb breadcrumb-custom-icon">
				<li class="breadcrumb-item"><a href="dashboard.php">Home</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i>
				</li>
				<li class="breadcrumb-item"><a href="agency_list.php">News Papers List</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i>
				</li>
				<li class="breadcrumb-item active">News Papers Add</li>
			</ol>
		</nav>

		<div class="card mb-6">
			<div class="position-fixed top-0 end-0 p-3" style="z-index: 1080">
  <div id="toastContainer"></div>
</div>

			<form class="card-body" method="POST" enctype="multipart/form-data" id="newspapersForm"> 
  <div class="row g-6">

    <!-- Hidden ID (for update) -->
    <input type="hidden" name="id" id="id">

    <!-- Newspaper Name -->
    <div class="col-md-6">
      <label for="name" class="form-label">Newspaper Name</label>
      <input type="text" name="name" id="name" class="form-control" required>
    </div>

    <!-- Agency Dropdown -->
    <div class="col-md-6">
      <label for="agency_id" class="form-label">Select Agency</label>
      <select name="agency_id" id="agency_id" class="form-select" required>
        <option value="">-- Select Agency --</option>
        <?php
        // Fetch agencies from database
//        $query = "SELECT id, agencyname FROM agency WHERE status='active'";
//        $result = mysqli_query($conn, $query);
//        while($row = mysqli_fetch_assoc($result)) {
//            echo '<option value="'.$row['id'].'">'.htmlspecialchars($row['agencyname']).'</option>';
//        }
        ?>
      </select>
    </div>

    <!-- Price -->
    <div class="col-md-4">
      <label for="price" class="form-label">Price</label>
      <input type="number" name="price" id="price" class="form-control" step="0.01" value="0.00" required>
    </div>

    <!-- Language -->
   <div class="col-md-4">
  <label for="language" class="form-label">Language</label>
  <select name="language" id="language" class="form-select">
    <option value="Gujarati" selected>Gujarati</option>
    <option value="Hindi">Hindi</option>
    <option value="English">English</option>
    <option value="Marathi">Marathi</option>
    <option value="Other">Other</option>
  </select>
</div>


    <!-- Edition -->
    <div class="col-md-4">
      <label for="edition" class="form-label">Edition</label>
      <input type="text" name="edition" id="edition" class="form-control">
    </div>

    <!-- Circulation -->
    <div class="col-md-4">
      <label for="circulation" class="form-label">Circulation</label>
      <input type="number" name="circulation" id="circulation" class="form-control" value="0">
    </div>

    <!-- Status -->
    <div class="col-md-4">
      <label class="form-label">Status</label>
      <select name="status" id="status" class="form-select">
        <option value="active" selected>Active</option>
        <option value="inactive">Inactive</option>
      </select>
    </div>

  </div>

  <div class="pt-6">
    <button type="submit" class="btn btn-primary me-4">Save Newspaper</button>
  </div>
</form>




		</div>
	</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script>
$(document).ready(function () {
   $(document).ready(function () {
    const form = $('#agencyForm');

    // ✅ Toastr default options (you can customize)
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000"
    };

    // ✅ Toast helper
    function showToast(type, message) {
        switch (type) {
            case 'success': toastr.success(message); break;
            case 'error': toastr.error(message); break;
            case 'info': toastr.info(message); break;
            case 'warning': toastr.warning(message); break;
        }
    }

    // ✅ Submit form
    form.on('submit', function (e) {
        e.preventDefault();

        let formData = new FormData(this);
        formData.append('action', 'saveAgency');

        $.ajax({
            url: 'controllers/AgencyController.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            
            success: function (res) {
                let result = {};
                try {
                    result = JSON.parse(res.trim());  // parse JSON safely
                } catch (err) {
                    console.error("Invalid JSON:", res);
                    showToast('error', 'Invalid server response!');
                    return;
                }

                if (result.status === 'success') {
                    if ($('#id').val()) {
                        // ✅ Update case
                        showToast('success', result.message || 'Agency updated successfully!');
                        setTimeout(() => {
                            window.location.href = 'agency_list.php';
                        }, 1500);
                    } else {
                        // ✅ Create case
                        showToast('success', result.message || 'Agency created successfully!');
                        form[0].reset();
                        $('#logo_preview').hide().attr('src', '');
                    }
                } else {
                    // ❌ Error case
                    showToast('error', result.message || 'Something went wrong!');
                }
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error:", status, error);
                showToast('error', 'Network/Server error, please try again later.');
            }
        });
    });
});

    // If editing existing agency (update case)
    function getUrlParam(param) {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(param);
    }

    const agencyId = getUrlParam('id');
    if (agencyId) {
        $.getJSON('controllers/AgencyController.php', {
            action: 'getAgency',
            id: agencyId
        }, function (r) {
            $('#id').val(r.id);
            $('#agencyname').val(r.agencyname);
            $('#ownername').val(r.ownername);
            $('#email').val(r.email);
            $('#phone').val(r.phone);
            $('#registration_no').val(r.registration_no);
            $('#gst_no').val(r.gst_no);
            $('#address').val(r.address);
            $('#city').val(r.city);
            $('#state').val(r.state);
            $('#country').val(r.country);
            $('#pincode').val(r.pincode);
            $('#website').val(r.website);
            $('#status').val(r.status);

            if (r.logo) {
                $('#logo_preview').show().attr('src', r.logo);
            }
        });
    }

    // Preview logo before upload
    $('#logo').on('change', function () {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function (e) {
                $('#logo_preview').show().attr('src', e.target.result);
            };
            reader.readAsDataURL(file);
        }
    });

});
</script>


	<?php } ?>