<?php
class UserModel {
    private $conn;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all admins
    public function getAllAdmins() {
        $sql = "SELECT * FROM users WHERE role = 'admin' ORDER BY id DESC";
        $result = mysqli_query($this->conn, $sql);
        $data = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }
        return $data;
    }

    // Get single user by ID
    public function getUserById($id) {
        $id = (int)$id;
        $sql = "SELECT id, name, email, phone, status, role,password FROM users WHERE id = $id";
        $result = mysqli_query($this->conn, $sql);
        return mysqli_fetch_assoc($result);
    }

    // Check email exists (excluding current user for update)
    public function checkEmailExists($email, $id = 0) {
        $email = mysqli_real_escape_string($this->conn, $email);
        $id = (int)$id;
        $sql = "SELECT id FROM users WHERE email = '$email' AND id != $id";
        $result = mysqli_query($this->conn, $sql);
        return mysqli_num_rows($result) > 0;
    }

    // Create user
    public function createUser($name, $email, $phone, $password, $role, $status) {
        $name = mysqli_real_escape_string($this->conn, $name);
        $email = mysqli_real_escape_string($this->conn, $email);
        $phone = mysqli_real_escape_string($this->conn, $phone);
        $hashedPassword = password_hash($password, PASSWORD_BCRYPT);
        $role = mysqli_real_escape_string($this->conn, $role);
        $status = mysqli_real_escape_string($this->conn, $status);

        $sql = "INSERT INTO users (name, email, phone, password, role, status)
                VALUES ('$name', '$email', '$phone', '$hashedPassword', '$role', '$status')";
        return mysqli_query($this->conn, $sql);
    }

    // Update user
    public function updateUser($id, $name, $email, $phone, $status) {
        $id = (int)$id;
        $name = mysqli_real_escape_string($this->conn, $name);
        $email = mysqli_real_escape_string($this->conn, $email);
        $phone = mysqli_real_escape_string($this->conn, $phone);
        $status = mysqli_real_escape_string($this->conn, $status);

        $sql = "UPDATE users 
                SET name='$name', email='$email', phone='$phone', status='$status'
                WHERE id = $id";
        return mysqli_query($this->conn, $sql);
    }

    // Delete user
    public function deleteUser($id) {
        $id = (int)$id;
        $sql = "DELETE FROM users WHERE id = $id";
        return mysqli_query($this->conn, $sql);
    }

    // Toggle active/inactive
    public function toggleStatus($id) {
        $id = (int)$id;
        $sql = "UPDATE users 
                SET status = IF(status = 'active', 'inactive', 'active') 
                WHERE id = $id";
        return mysqli_query($this->conn, $sql);
    }
}
