<?php
session_start();

// If user clicked confirm logout
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    session_unset();
    session_destroy();

    // Clear cookies if set
    setcookie('admin_email', '', time() - 3600, "/");
    setcookie('admin_token', '', time() - 3600, "/");

    // Redirect to login
    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Logout</title>
    <script>
        function confirmLogout() {
            if (confirm("Are you sure you want to logout?")) {
                window.location.href = "logout.php?action=logout";
            } else {
                window.location.href = "dashboard.php";
            }
        }
    </script>
</head>
<body onload="confirmLogout()">
</body>
</html>
