<?php
session_start();
require_once __DIR__ . '/db.php';
   
// If session already set, verify against DB
if (isset($_SESSION['admin_id'], $_SESSION['admin_email'])) {
    require_once __DIR__ . '/../models/AuthModel.php';

    $model = new AuthModel($conn);
    $email = $_SESSION['admin_email'];
    $userId = $_SESSION['admin_id'];

    $user = $model->loginWithCookie($email, $userId); // re-use cookie method for DB check

    if ($user && $user['role'] === 'admin' && $user['status'] === 'active') {
        return; // allow access
    } else {
        session_destroy();
        header("Location: index.php");
        exit;
    }
}

// If no session, try to restore from cookies
if (isset($_COOKIE['admin_email']) && isset($_COOKIE['admin_token'])) {
  
    require_once __DIR__ . '/../models/AuthModel.php';

    $model = new AuthModel($conn);
    $email = $_COOKIE['admin_email'];
    $userId = base64_decode($_COOKIE['admin_token']);

    $user = $model->loginWithCookie($email, $userId);

    if ($user && $user['role'] === 'admin' && $user['status'] === 'active') {
        // Restore session
        $_SESSION['admin_id'] = $user['id'];
        $_SESSION['admin_name'] = $user['name'];
        $_SESSION['admin_email'] = $user['email'];
        return;
    }
}
//
//// If no valid session or cookie, redirect to login
//header("Location: index.php");
//exit;
