<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	?>
	<div class="container-xxl flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
			<ol class="breadcrumb breadcrumb-custom-icon">
				<li class="breadcrumb-item"><a href="dashboard.php">Home</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i>
				</li>
				<li class="breadcrumb-item active">Financial Years</li>
			</ol>
		</nav>
		<button type="button" class="btn btn-sm rounded-pill btn-primary" data-bs-toggle="modal" data-bs-target="#fyModal"><span class="ti tabler-square-rounded-plus icon-20px me-2"></span>Add Financial Years</button>
		<div class="card">
			<div id="alert-box" class="alert d-none" role="alert"></div>

			<div class="modal fade" id="fyModal" tabindex="-1" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<form id="fyForm" method="post">
						<div class="modal-content">
							<div class="modal-header">
								<h5 class="modal-title">Add/Edit Financial Year</h5>
								<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
							</div>
							<div class="modal-body">
								<input type="hidden" id="id" name="id"/>
								<div class="row">
									<div class="col-md-6 mb-3">
										<label class="form-label">Year Label</label>
										<input type="text" class="form-control" name="year_label" id="year_label" placeholder="e.g. 2024-2025" pattern="^\d{4}-\d{4}$" inputmode="numeric" minlength="9" maxlength="9" title="Please enter in format: 2024-2025" required>

									</div>
									<script>
										document.addEventListener( "DOMContentLoaded", function () {
											const input = document.getElementById( "year_label" );
											const today = new Date();
											const year = today.getMonth() >= 3 ? today.getFullYear() : today.getFullYear() - 1;
											const nextYear = year + 1;
											input.value = `${year}-${nextYear}`;
										} );
									</script>
									<div class="col-md-6 mb-3">
										<label class="form-label">Status</label>
										<select class="form-control" name="status" id="status">
											<option value="active">Active</option>
											<option value="inactive">Inactive</option>
										</select>
									</div>
									<div class="col-md-6 mb-3">
										<label class="form-label">Start Date</label>
										<input type="date" class="form-control" name="start_date" id="start_date" required>
									</div>
									<div class="col-md-6 mb-3">
										<label class="form-label">End Date</label>
										<input type="date" class="form-control" name="end_date" id="end_date" required>
									</div>
								</div>
							</div>
							<div class="modal-footer">
								<button type="submit" class="btn btn-primary">Save</button>
								<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
							</div>
						</div>
					</form>
				</div>
			</div>


			<!-- Toast -->


			<div class="card-datatable text-nowrap">
				<table class="datatables-ajax table table-bordered">
					<thead>
						<tr>
							<th>Year Label</th>
							<th>Start Date</th>
							<th>End Date</th>
							<th>Status</th>
							<th>Action</th>
						</tr>
					</thead>
					<tbody></tbody>
				</table>
			</div>
		</div>
	</div>
	<script>
		$( document ).ready( function () {
			fetchFinancialyears();

			function showToast( message, type = 'success' ) {
				const alertBox = $( '#alert-box' );
				alertBox.removeClass( 'd-none alert-success alert-danger' )
					.addClass( `alert alert-${type}` )
					.text( message );

				setTimeout( () => {
					alertBox.addClass( 'd-none' ).removeClass( `alert-${type}` ).text( '' );
				}, 3000 );
			}



			// Handle form submit
			$( '#fyForm' ).on( 'submit', function ( e ) {
				e.preventDefault();
				// Hide Bootstrap modal
				const modalEl = document.getElementById( 'fyModal' );
				const modal = bootstrap.Modal.getInstance( modalEl ) || new bootstrap.Modal( modalEl );
				modal.hide();
				const formData = new FormData( this );

				$.ajax( {
					url: 'controllers/fyController.php',
					method: 'POST',
					data: formData,
					contentType: false,
					processData: false,
					success: function ( res ) {
						try {
							let result = JSON.parse( res );

							if ( result.status === 'success' ) {


								$( '#fyForm' )[ 0 ].reset();
								
								fetchFinancialyears();
								showToast( result.message, 'success' );
							} else if ( result.status === 'error' ) {
								if ( result.errors && Array.isArray( result.errors ) ) {
									result.errors.forEach( error => showToast( error, 'danger' ) );
								} else {
									showToast( result.message, 'danger' );
								}
							}
						} catch ( err ) {
							console.error( "Parse error:", res );
							showToast( 'Invalid server response.', 'danger' );
						}
					},
					error: function () {
						showToast( 'Something went wrong. Try again.', 'danger' );
					}
				} );
			} );


			// Edit Button
			$( document ).on( 'click', '.editBtn', function () {
				const id = $( this ).data( 'id' );
				$.post( 'controllers/fyController.php', {
					action: 'getFinancialyear',
					id
				}, function ( data ) {
					const financialyear = JSON.parse( data );
					$( '#id' ).val( financialyear.id );
					$( '#year_label' ).val( financialyear.year_label );
					$( '#start_date' ).val( financialyear.start_date );
					$( '#end_date' ).val( financialyear.end_date );
					$( '#status' ).val( financialyear.status );
					$( '#fyModal' ).modal( 'show' );
				} );
			} );

			// Delete Button
			$( document ).on( 'click', '.deleteBtn', function () {
				const id = $( this ).data( 'id' );

				Swal.fire( {
					title: 'Are you sure?',
					text: "Do you really want to delete this?",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonColor: '#d33',
					cancelButtonColor: '#6c757d',
					confirmButtonText: 'Yes, delete it!'
				} ).then( ( result ) => {
					if ( result.isConfirmed ) {
						$.post( 'controllers/fyController.php', {
							action: 'deleteFinancialyear',
							id
						}, function ( res ) {
							let result = JSON.parse( res );
							if ( result.status === 'success' ) {
								fetchFinancialyears();
								Swal.fire( 'Deleted!', result.message, 'success' );
							} else {
								Swal.fire( 'Error!', result.message, 'error' );
							}
						} );
					}
				} );
			} );


			// Status Toggle
			$( document ).on( 'change', '.toggleStatus', function () {
				const id = $( this ).data( 'id' );
				$.post( 'controllers/fyController.php', {
					action: 'toggleStatus',
					id
				}, function ( res ) {
					const result = JSON.parse( res );
					if ( result.status === 'success' ) {
						showToast( result.message, 'success' );
					} else {
						showToast( result.message, 'danger' );
					}
				} );
			} );


			function fetchFinancialyears() {
				$.get( 'controllers/fyController.php', {
					action: 'list'
				}, function ( html ) {
					// Destroy existing DataTable if initialized
					if ( $.fn.DataTable.isDataTable( '.datatables-ajax' ) ) {
						$( '.datatables-ajax' ).DataTable().destroy();
					}

					// Update table body
					$( '.datatables-ajax tbody' ).html( html );

					// Reinitialize DataTable
					$( '.datatables-ajax' ).DataTable( {
						processing: true,
						responsive: true,
						dom: '<"row mx-3 justify-content-between"' +
							'<"d-md-flex justify-content-between align-items-center dt-layout-start col-md-auto me-auto"l>' +
							'<"d-md-flex justify-content-between align-items-center dt-layout-end col-md-auto ms-auto mt-0"f>' +
							'>' +
							'<"table-responsive"t>' +
							'<"row mx-3 justify-content-between"' +
							'<"col-sm-12 col-md-6"i>' +
							'<"col-sm-12 col-md-6 d-flex justify-content-end"p>' + // 👈 Align pagination to right
							'>',
						order: [
							[ 0, 'asc' ]
						]
					} );

				} );
			}

		} );
	</script>
	<?php } ?>