<?php
error_reporting(1);
include("inc/template.php");
function main() {
  global $conn;

  // === Fetch Counts ===
  $agencyCount     = $conn->query("SELECT COUNT(*) AS total FROM agency")->fetch_assoc()['total'];
  $newspaperCount  = $conn->query("SELECT COUNT(*) AS total FROM newspapers")->fetch_assoc()['total'];
  $userCount       = $conn->query("SELECT COUNT(*) AS total FROM users")->fetch_assoc()['total'];
  $activeUsers     = $conn->query("SELECT COUNT(*) AS total FROM users WHERE status='active'")->fetch_assoc()['total'];
  $salesCount      = $conn->query("SELECT COUNT(*) AS total FROM sales")->fetch_assoc()['total'];

  // === Delivery Performance Example ===
  $totals = $conn->query("
    SELECT 
      SUM(total_qty) AS total_qty,
      SUM(total_amount) AS total_amount,
      SUM(transport_charge) AS transport,
      SUM(discount) AS discount
    FROM sales
  ")->fetch_assoc();

  $totalQty    = $totals['total_qty'] ?? 0;
  $totalSales  = $totals['total_amount'] ?? 0.00;

  // === Last 5 Orders ===
  $lastOrders = $conn->query("
    SELECT s.id, s.bill_no, s.sale_date, a.agencyname, s.total_qty, s.total_amount
    FROM sales s
    JOIN agency a ON s.agency_id = a.id
    ORDER BY s.id DESC
    LIMIT 5
  ");

?>
<div class="container-xxl flex-grow-1 container-p-y">
  <div class="row g-6">

    <!-- Newspapers -->
    <div class="col-lg-3 col-sm-6">
      <a href="newspepars.php" class="text-decoration-none">
        <div class="card card-border-shadow-primary h-100">
          <div class="card-body">
            <div class="d-flex align-items-center mb-2">
              <div class="avatar me-4">
                <span class="avatar-initial rounded bg-label-primary">
                  <i class="ti ti-news ti-28px"></i>
                </span>
              </div>
              <h4 class="mb-0"><?= $newspaperCount ?></h4>
            </div>
            <p class="mb-1">Newspapers</p>
            <small class="text-muted">Click to manage newspapers</small>
          </div>
        </div>
      </a>
    </div>

    <!-- Agencies -->
    <div class="col-lg-3 col-sm-6">
      <a href="agency_list.php" class="text-decoration-none">
        <div class="card card-border-shadow-warning h-100">
          <div class="card-body">
            <div class="d-flex align-items-center mb-2">
              <div class="avatar me-4">
                <span class="avatar-initial rounded bg-label-warning">
                  <i class="ti ti-building ti-28px"></i>
                </span>
              </div>
              <h4 class="mb-0"><?= $agencyCount ?></h4>
            </div>
            <p class="mb-1">Agencies</p>
            <small class="text-muted">Click to manage agencies</small>
          </div>
        </div>
      </a>
    </div>

    <!-- Users -->
    <div class="col-lg-3 col-sm-6">
      <a href="admin_master.php" class="text-decoration-none">
        <div class="card card-border-shadow-danger h-100">
          <div class="card-body">
            <div class="d-flex align-items-center mb-2">
              <div class="avatar me-4">
                <span class="avatar-initial rounded bg-label-danger">
                  <i class="ti ti-users ti-28px"></i>
                </span>
              </div>
              <h4 class="mb-0"><?= $userCount ?></h4>
            </div>
            <p class="mb-1">Users</p>
            <small class="text-muted"><?= $activeUsers ?> active</small>
          </div>
        </div>
      </a>
    </div>

    <!-- Sales -->
    <div class="col-lg-3 col-sm-6">
      <a href="newspepars_order_list.php" class="text-decoration-none">
        <div class="card card-border-shadow-info h-100">
          <div class="card-body">
            <div class="d-flex align-items-center mb-2">
              <div class="avatar me-4">
                <span class="avatar-initial rounded bg-label-info">
                  <i class="ti ti-receipt ti-28px"></i>
                </span>
              </div>
              <h4 class="mb-0"><?= $salesCount ?></h4>
            </div>
            <p class="mb-1">Sales Orders</p>
            <small class="text-muted">Total orders recorded</small>
          </div>
        </div>
      </a>
    </div>

  </div>

  <div class="row mt-4">

    <!-- Delivery Performance -->
    <div class="col-xxl-5 col-lg-6">
      <div class="card h-100">
        <div class="card-header">
          <h5 class="mb-1">Delivery Performance</h5>
          <p class="card-subtitle">Based on all recorded sales</p>
        </div>
        <div class="card-body">
          <ul class="list-unstyled m-0">
            <li class="d-flex justify-content-between mb-3">
              <span>Total Quantity Sold</span>
              <strong><?= number_format($totalQty) ?></strong>
            </li>
            <li class="d-flex justify-content-between mb-3">
              <span>Total Sales Amount</span>
              <strong>₹<?= number_format($totalSales, 2) ?></strong>
            </li>
            <li class="d-flex justify-content-between mb-3">
              <span>Average Order Value</span>
              <strong>
                ₹<?= $salesCount > 0 ? number_format($totalSales / $salesCount, 2) : "0.00" ?>
              </strong>
            </li>
          </ul>
        </div>
      </div>
    </div>

    <!-- Recent Orders -->
    <div class="col-xxl-7 col-lg-6">
      <div class="card h-100">
        <div class="card-header">
          <h5 class="mb-1">Recent Sales Orders</h5>
          <p class="card-subtitle">Last 5 recorded orders</p>
        </div>
        <div class="card-body table-responsive">
          <table class="table table-sm table-striped">
            <thead>
              <tr>
                <th>#Bill</th>
                <th>Agency</th>
                <th>Date</th>
                <th>Qty</th>
                <th>Total</th>
              </tr>
            </thead>
            <tbody>
              <?php if ($lastOrders->num_rows > 0): ?>
                <?php while ($row = $lastOrders->fetch_assoc()): ?>
                  <tr>
                    <td><?= htmlspecialchars($row['bill_no']) ?></td>
                    <td><?= ucwords(htmlspecialchars($row['agencyname'])) ?></td>
                    <td><?= date("d-m-Y", strtotime($row['sale_date'])) ?></td>
                    <td><?= $row['total_qty'] ?></td>
                    <td>₹<?= number_format($row['total_amount'], 2) ?></td>
                  </tr>
                <?php endwhile; ?>
              <?php else: ?>
                <tr><td colspan="5" class="text-center">No orders found.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

  </div>
</div>
<?php } ?>
