<?php
require_once '../inc/db.php';
require_once '../models/FyModel.php';

$model = new FyModel($conn);
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $action = $_POST['action'] ?? '';

    switch ($action) {
        case 'getFinancialyear':
            $id = (int) $_POST['id'];
            $year = $model->getFinancialYearById($id);
            echo json_encode($year);
            break;

        case 'deleteFinancialyear':
            $id = (int) $_POST['id'];
            echo json_encode(
                $model->delete($id)
                    ? ['status' => 'success', 'message' => 'Deleted successfully']
                    : ['status' => 'error', 'message' => 'Delete failed']
            );
            break;

        case 'toggleStatus':
            $id = (int) $_POST['id'];
            echo json_encode(
                $model->toggleStatus($id)
                    ? ['status' => 'success', 'message' => 'Status updated']
                    : ['status' => 'error', 'message' => 'Status update failed']
            );
            break;

        default:
            $data = [
                'id'         => $_POST['id'] ?? null,
                'year_label' => trim($_POST['year_label']),
                'start_date' => trim($_POST['start_date']),
                'end_date'   => trim($_POST['end_date']),
                'status'     => $_POST['status']
            ];

            $errors = [];

            if (empty($data['year_label'])) {
                $errors[] = 'Year label is required.';
            } elseif ($model->isDuplicate($data['year_label'], $data['id'] ?? null)) {
                $errors[] = 'Financial year already exists.';
            }

            if (!empty($errors)) {
                echo json_encode(['status' => 'error', 'errors' => $errors]);
                exit;
            }

            if (!empty($data['id'])) {
                $success = $model->update($data);
                $message = $success ? 'Financial year updated' : 'Update failed';
            } else {
                $success = $model->insert($data);
                $message = $success ? 'Financial year created' : 'Insert failed';
            }

            echo json_encode([
                'status' => $success ? 'success' : 'error',
                'message' => $message
            ]);
            break;
    }
}

// List Years
elseif ($method === 'GET' && $_GET['action'] === 'list') {
    $result = $model->listFinancialYears();
    $html = '';

    while ($row = $result->fetch_assoc()) {
		$start = date('d-m-Y', strtotime($row['start_date']));
$end = date('d-m-Y', strtotime($row['end_date']));
        $checked = $row['status'] === 'active' ? 'checked' : '';
        $statusSwitch = "<label class='switch switch-success'>
            <input type='checkbox' class='switch-input toggleStatus' data-id='{$row['id']}' $checked />
            <span class='switch-toggle-slider'>
              <span class='switch-on'><i class='icon-base ti tabler-check'></i></span>
              <span class='switch-off'><i class='icon-base ti tabler-x'></i></span>
            </span>
          </label>";

        $html .= "<tr>
            <td>{$row['year_label']}</td>
            <td>{$start}</td>
			<td>{$end}</td>
            <td>$statusSwitch</td>
			<td>
                  <button type='button' class='btn btn-xs btn-warning rounded-pill editBtn' 
                         data-id='{$row['id']}' data-bs-toggle='tooltip'
                        data-bs-placement='top' title='edit'>
                    <i class='tf-icons ti ti-edit'></i>
                  </button>
                  
           
            </td>
        </tr>";
    }

    echo $html;
}
