<?php
require_once '../inc/db.php'; 
require_once '../models/UserModel.php';

$model = new UserModel($conn);

// List users
if ($_SERVER['REQUEST_METHOD'] === 'GET' && $_GET['action'] === 'list') {
    $users = $model->getAllAdmins();
    foreach ($users as $row) {
        $checked = ($row['status'] === 'active') ? 'checked' : '';

        $statusSwitch = "<label class='switch switch-success'>
            <input type='checkbox' class='switch-input toggleStatus' data-id='{$row['id']}' $checked />
            <span class='switch-toggle-slider'>
              <span class='switch-on'><i class='icon-base ti tabler-check'></i></span>
              <span class='switch-off'><i class='icon-base ti tabler-x'></i></span>
            </span>
          </label>";

        echo '<tr>
            <td>' . htmlspecialchars($row['name']) . '</td>
            <td>' . htmlspecialchars($row['email']) . '</td>
            <td>' . $row['phone'] . '</td>
            <td>' . $statusSwitch . '</td>
            <td>
              <button type="button" class="btn btn-xs btn-warning rounded-pill editBtn" data-id="' . $row['id'] . '">
                <i class="tf-icons ti ti-edit"></i>
              </button>
              <button type="button" class="btn btn-xs btn-danger rounded-pill deleteBtn" data-id="' . $row['id'] . '">
                <i class="tf-icons ti ti-trash"></i>
              </button>
            </td>
        </tr>';
    }
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'getUser') {
        $user = $model->getUserById($_POST['id']);
        echo json_encode($user);
        exit;
    }

    if ($action === 'deleteUser') {
        $model->deleteUser($_POST['id']);
        echo json_encode(['status' => 'success', 'message' => 'User deleted successfully.']);
        exit;
    }

    if ($action === 'toggleStatus') {
        $model->toggleStatus($_POST['id']);
        echo json_encode(['status' => 'success', 'message' => 'Status updated successfully.']);
        exit;
    }

    // Save user (create or update)
    $id     = $_POST['id'] ?? '';
    $name   = trim($_POST['name'] ?? '');
    $email  = trim($_POST['email'] ?? '');
    $phone  = trim($_POST['phone'] ?? '');
    $status = $_POST['status'] ?? 'active';
    $role   = $_POST['role'] ?? 'admin';
    $pass   = $_POST['password'] ?? '';

    $errors = [];

    if ($name === '') {
        $errors[] = "Name is required.";
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Invalid email format.";
    }

    if ($id === '' && strlen($pass) < 6) {
        $errors[] = "Password must be at least 6 characters.";
    }

    if ($model->checkEmailExists($email, $id ?: 0)) {
        $errors[] = "Email already exists.";
    }

    if (!empty($errors)) {
        echo json_encode(['status' => 'error', 'errors' => $errors]);
        exit;
    }

    if ($id === '') {
        $model->createUser($name, $email, $phone, $pass, $role, $status);
        echo json_encode(['status' => 'success', 'message' => 'User created successfully.']);
    } else {
        $model->updateUser($id, $name, $email, $phone, $status);
        echo json_encode(['status' => 'success', 'message' => 'User updated successfully.']);
    }
    exit;
}
