<?php
require_once '../inc/db.php';
require_once '../models/SalesModel.php';

$model = new SalesModel($conn);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
	if($_POST['action'] === 'saveOrder'){
    // Validate at least one item
    if (!isset($_POST['newspaper_id']) || !is_array($_POST['newspaper_id']) || count($_POST['newspaper_id']) === 0) {
        echo json_encode(['status'=>'error','message'=>'No newspapers added']);
        exit;
    }

    $items = [];
    $totalQty = 0;
    $subtotal = 0;

    for($i=0;$i<count($_POST['newspaper_id']);$i++){
        $newspaper_id = intval($_POST['newspaper_id'][$i]);
        $qty = intval($_POST['qty'][$i]);
        $price = floatval($_POST['price'][$i]);
        $remarks = isset($_POST['remarks'][$i]) ? $_POST['remarks'][$i] : '';

        if($qty <= 0 || $price <= 0) continue;

        $items[] = [
            'newspaper_id' => $newspaper_id,
            'qty' => $qty,
            'price' => $price,
            'remarks' => $remarks
        ];

        $totalQty += $qty;
        $subtotal += $qty * $price;
    }

    if(count($items) === 0){
        echo json_encode(['status'=>'error','message'=>'All items have invalid quantity or price']);
        exit;
    }

    $transport = floatval($_POST['transport'] ?? 0);
    $discount = floatval($_POST['discount'] ?? 0);
    $grandTotal = $subtotal + $transport - $discount;
    if($grandTotal < 0) $grandTotal = 0;

    $salesData = [
        'bill_no' => $_POST['bill_no'],
        'agency_id' => intval($_POST['agency_id']),
        'financial_year_id' => intval($_POST['financial_year_id']),
        'sale_date' => $_POST['sale_date'],
        'total_qty' => $totalQty,
        'transport_charge' => $transport,
        'discount' => $discount,
        'total_amount' => $grandTotal,
        'remarks' => $_POST['remarks_main'] ?? '',
        'created_by' => intval($_POST['created_by']),
        'items' => $items
    ];

    $result = $model->saveOrder($salesData);

    echo json_encode($result);
	}
	
	// ---------------- UPDATE ORDER ----------------
    if($_POST['action'] === 'updateOrder' && isset($_POST['id'])){
        $orderId = intval($_POST['id']);

        if (!isset($_POST['newspaper_id']) || !is_array($_POST['newspaper_id']) || count($_POST['newspaper_id']) === 0) {
            echo json_encode(['status'=>'error','message'=>'No newspapers added']);
            exit;
        }

        $items = [];
        $totalQty = 0;
        $subtotal = 0;

        for($i=0;$i<count($_POST['newspaper_id']);$i++){
            $newspaper_id = intval($_POST['newspaper_id'][$i]);
            $qty = intval($_POST['qty'][$i]);
            $price = floatval($_POST['price'][$i]);
            $remarks = $_POST['remarks'][$i] ?? '';

            if($qty <= 0 || $price <= 0) continue;

            $items[] = [
                'newspaper_id' => $newspaper_id,
                'qty' => $qty,
                'price' => $price,
                'remarks' => $remarks
            ];

            $totalQty += $qty;
            $subtotal += $qty * $price;
        }

        $transport = floatval($_POST['transport'] ?? 0);
        $discount = floatval($_POST['discount'] ?? 0);
        $grandTotal = $subtotal + $transport - $discount;
        if($grandTotal < 0) $grandTotal = 0;

        $salesData = [
            'id' => $orderId,
            'bill_no' => $_POST['bill_no'],
            'agency_id' => intval($_POST['agency_id']),
            'financial_year_id' => intval($_POST['financial_year_id']),
            'sale_date' => $_POST['sale_date'],
            'total_qty' => $totalQty,
            'transport_charge' => $transport,
            'discount' => $discount,
            'total_amount' => $grandTotal,
            'remarks' => $_POST['remarks_main'] ?? '',
            'updated_by' => intval($_POST['created_by']),
            'items' => $items
        ];

        $result = $model->updateOrder($salesData);
        echo json_encode($result);
        exit;
    }

	
	if($_POST['action'] === 'datatable'){
    $start = intval($_POST['start'] ?? 0);
    $length = intval($_POST['length'] ?? 25);
    $search = $_POST['search']['value'] ?? '';
    $orderColumn = $_POST['order'][0]['column'] ?? 0;
    $orderDir = $_POST['order'][0]['dir'] ?? 'desc';
    $financialYearId = $_POST['financial_year_id'] ?? null;

    $orders = $model->getOrders($start, $length, $search, $orderColumn, $orderDir, $financialYearId);

    echo json_encode([
        "draw" => intval($_POST['draw']),
        "recordsTotal" => $orders['recordsTotal'],
        "recordsFiltered" => $orders['recordsTotal'],
        "data" => $orders['data']
    ]);
    exit;
}

	if($_POST['action'] === 'deleteOrder' && isset($_POST['id'])){
        $sale_id = intval($_POST['id']);
        $result = $model->deleteOrder($sale_id);
        echo json_encode($result);
        exit;
    }
}

// ---------------- GET ORDER BY ID (for editing) ----------------
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'getOrderById') {
    $orderId = intval($_GET['order_id'] ?? 0);
    if($orderId <= 0){
        echo json_encode(['status'=>'error','message'=>'Invalid order ID']);
        exit;
    }
    $order = $model->getOrderById($orderId);
    if($order){
        echo json_encode(['status'=>'success','order'=>$order['order'],'items'=>$order['items']]);
    } else {
        echo json_encode(['status'=>'error','message'=>'Order not found']);
    }
    exit;
}
?>
