<?php
include( "assets/inc/template.php" );

function main() {
	global $conn;
	?>
<style>
    .rs-services-item {
  position: relative;
  background: #fff;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
  padding: 9px;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
  z-index: 1;
 border: 1px solid #214c8b
}

/* Hover scale and shadow */
.rs-services-item:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 30px rgba(33, 76, 139, 0.25);
}

/* Animated circular gradient border */
.rs-services-item::before {
  content: "";
  position: absolute;
  top: -4px;
  left: -4px;
  right: -4px;
  bottom: -4px;
  background: conic-gradient(from 0deg, #214C8B, #898989, #214C8B);
  border-radius: 24px;
  z-index: -1;
  opacity: 0;
  transition: opacity 0.4s ease;
  animation: rotateBorder 4s linear infinite;
}

.rs-services-item:hover::before {
  opacity: 1;
}


/* Image styling */
.rs-services-thumb img {
  border-radius: 14px;
  width: 100%;
  object-fit: cover;
}

/* Title styling */
.rs-services-title a {
  color: #214C8B;
  font-size: 18px;
  font-weight: 600;
  margin-top: 15px;
  display: inline-block;
  transition: color 0.3s ease;
}

.rs-services-title a:hover {
  color: #898989;
}

/* Button area */
.rs-services-btn-wrapper {
  margin-top: 15px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.rs-text-btn {
  color: #214C8B;
  font-weight: 500;
  text-decoration: underline;
}

.rs-text-btn:hover {
  color: #898989;
}

.rs-square-btn {
  background: #214C8B;
  color: #fff;
  padding: 8px 12px;
  border-radius: 8px;
  transition: background 0.3s ease;
}

.rs-square-btn:hover {
  background: #898989;
}

.icon-box svg path {
  fill: #fff;
}



</style>
	<main>
		<link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
		<main>

			<!-- breadcrumb area start -->
			<section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
				<div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
				<div class="container">
					<div class="row">
						<div class="col-xxl-6 col-xl-8 col-lg-8">
							<div class="rs-breadcrumb-content-wrapper">
								<div class="rs-breadcrumb-title-wrapper">
									<h1 class="rs-breadcrumb-title">Products</h1>
								</div>
								<div class="rs-breadcrumb-menu">
									<nav>
										<ul>
											<li><span><a href="index.php">Home</a></span>
											</li>
											<li><span>Products</span>
											</li>
										</ul>
									</nav>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!-- breadcrumb area end -->
			<?php //$categoryslug = $_GET['category']; ?>
			<!-- services area start -->
			<section class="rs-services-area rs-services-three section-space has-theme-orange">
				<div class="container">
					<div class="row g-5 process-counts" id="subproduct-list">
						
											
					</div>
					<div id="loading" style="display: none; text-align: center;">Loading...</div>
				</div>
			</section>
			
			
			<!-- brand area end -->


		</main>
<script>
let isLoading = false;
let offset = 0;
const limit = 12;
let hasMore = true;

const slug = new URLSearchParams(window.location.search).get("category");

document.addEventListener("DOMContentLoaded", () => {
    fetchProducts(); // Initial load
    window.addEventListener('scroll', handleScroll); // Infinite scroll
});

function handleScroll() {
    if (!hasMore || isLoading) return;

    if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight - 200) {
        fetchProducts();
    }
}

function fetchProducts() {
    isLoading = true;
    document.getElementById("loading").style.display = 'block';

    fetch(`controllers/ProductSubCategoryController.php?action=fetch&category=${encodeURIComponent(slug)}&offset=${offset}&limit=${limit}`)
        .then(res => res.text())
        .then(data => {
            data = data.trim();

            if (data === '' || data.includes('no-products-marker')) {
                if (offset === 0) {
                    // Initial load, no data
                    document.getElementById("subproduct-list").innerHTML = `
                        <div class="col-12">
                            <div class="alert alert-warning text-center" role="alert">
                                No products found in this category.
                            </div>
                        </div>`;
                }
                hasMore = false;
            } else {
                document.getElementById("subproduct-list").innerHTML += data;
                offset += limit;

                // Less than requested means end
                if ((data.match(/data-aos=/g) || []).length < limit) {
                    hasMore = false;
                }

                AOS.init(); // for animation
            }

            isLoading = false;
            document.getElementById("loading").style.display = 'none';
        })
        .catch(err => {
            console.error(err);
            isLoading = false;
            document.getElementById("loading").style.display = 'none';
        });
}
</script>


		<script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
		<script>
			AOS.init();
		</script>
		<?php } ?>