<?php
class ProductSubCategoryModel {
    private $conn;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function getAllSubProducts($categorySlug, $offset = 0, $limit = 12) {
    $stmt = $this->conn->prepare("
        SELECT ps.*, pc.catname AS category_name, pc.slug AS category_slug
        FROM product_subcategories ps
        JOIN product_categories pc ON ps.cat_id = pc.id
        WHERE ps.status = 1 AND pc.slug = ?
        ORDER BY 
            CASE 
                WHEN ps.sort_order = 0 THEN ps.id 
                ELSE ps.sort_order 
            END ASC
        LIMIT ?, ?
    ");

    // 'sii' means: string, integer, integer
    $stmt->bind_param("sii", $categorySlug, $offset, $limit);
    $stmt->execute();

    $result = $stmt->get_result();
    $subproducts = [];

    while ($row = $result->fetch_assoc()) {
        $subproducts[] = $row;
    }

    return $subproducts;
}

	
	public function getRelatedProducts($slug) {
    // Step 1: Get category of current product using its slug
    $stmt = $this->conn->prepare("SELECT id,cat_id FROM product_subcategories WHERE slug = ?");
    $stmt->bind_param("s", $slug);
    $stmt->execute();
    $result = $stmt->get_result();
    $product = $result->fetch_assoc();

    if (!$product) return [];

    $subcat_id = $product['id'];
	$cat_id = $product['cat_id'];

    // Step 2: Get related subcategories in same category, excluding the current slug
    $stmt = $this->conn->prepare("
        SELECT * FROM product_subcategories 
        WHERE cat_id = ? AND id != ? AND status = 1 
        ORDER BY 
            CASE 
                WHEN sort_order = 0 THEN id 
                ELSE sort_order 
            END ASC
    ");
    $stmt->bind_param("ii", $cat_id, $subcat_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $relatedProducts = [];
    while ($row = $result->fetch_assoc()) {
        $relatedProducts[] = $row;
    }

    return $relatedProducts;
}


}
