<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>

	<div class="container-xxl flex-grow-1 container-p-y">
		<div class="d-flex flex-column justify-content-center">
			<h5 class="card-header mb-2">Product Cat List</h5>
		</div>
		<button class="btn btn-primary" onclick="window.location.href='product_cat_add.php'" type="button"><span><i class="ti ti-plus me-sm-1"></i> <span class="d-none d-sm-inline-block">Add New </span></span></button>

		<div class="card">
			<div class="card-datatable table-responsive">
				
				<div id="alert-box" class="alert d-none" role="alert"></div>
				<table class="datatables-ajax table table-bordered table-responsive">
					<thead>
						<tr>
							<th>Product Cat</th>
							<th>Description</th>
							<th>Image</th>
							<th>Status</th>
							<th>Action</th>
						</tr>
					</thead>
					<tbody>
					
					</tbody>
				</table>
			</div>
		</div>
	</div>
<script>
$(document).ready(function () {
  fetchCategories(); // Load on page load

  function showToast(message, type = 'success') {
    const alertBox = $('#alert-box');
    alertBox.removeClass('d-none alert-success alert-danger')
            .addClass(`alert alert-${type}`)
            .text(message);

    setTimeout(() => {
      alertBox.addClass('d-none').removeClass(`alert-${type}`).text('');
    }, 3000);
  }

  // ?? Redirect to edit page
  $(document).on('click', '.editBtn', function () {
    const id = $(this).data('id');
    window.location.href = 'product_cat_add.php?id=' + id;
  });

  // ? Delete category
  $(document).on('click', '.deleteBtn', function () {
    const id = $(this).data('id');
    if (confirm("Are you sure you want to delete ?")) {
      $.post('controllers/ProductCategoryController.php', { action: 'delete', id }, function (res) {
        let result = JSON.parse(res);
        if (result.status === 'success') {
          fetchCategories();
          showToast(result.message, 'success');
        } else {
          showToast(result.message, 'danger');
        }
      });
    }
  });

  // ? Toggle status
  $(document).on('change', '.toggleStatus', function () {
    const id = $(this).data('id');
    $.post('controllers/ProductCategoryController.php', { action: 'toggleStatus', id }, function (res) {
      const result = JSON.parse(res);
      if (result.status === 'success') {
        showToast(result.message, 'success');
      } else {
        showToast(result.message, 'danger');
      }
    });
  });

  // ? Fetch & render category rows
  function fetchCategories() {
    $.get('controllers/ProductCategoryController.php', { action: 'productcatlist' }, function (html) {
      if ($.fn.DataTable.isDataTable('.datatables-ajax')) {
        $('.datatables-ajax').DataTable().destroy();
      }

      $('.datatables-ajax tbody').html(html);

      $('.datatables-ajax').DataTable({
        processing: true,
        dom:
          '<"row mx-3 justify-content-between"' +
            '<"d-md-flex justify-content-between align-items-center dt-layout-start col-md-auto me-auto"l>' +
            '<"d-md-flex justify-content-between align-items-center dt-layout-end col-md-auto ms-auto mt-0"f>' +
          '>' +
          '<"table-responsive"t>' +
          '<"row mx-3 justify-content-between"' +
            '<"col-sm-12 col-md-6"i>' +
            '<"col-sm-12 col-md-6 d-flex justify-content-end"p>' +
          '>',
		  order: [[0, 'ASC']]
      });
    });
  }
});

</script>
	<?php } ?>