<?php
session_start();
include( 'inc/db.php' );
// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    // Optional: try to use cookies to re-authenticate (auto-login)
    if (isset($_COOKIE['remember_email']) && isset($_COOKIE['remember_pass'])) {
        // Include DB connection
       // require_once 'db_connection.php';

        $email = $_COOKIE['remember_email'];
        $password = $_COOKIE['remember_pass'];

        $stmt = $conn->prepare("SELECT * FROM users WHERE email = ? AND status = '1' LIMIT 1");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();

            // Match password from cookie (note: you can store hash or token instead for better security)
            if ($password === $user['password'] || password_verify($password, $user['password'])) {
                // Set session from cookie
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['user_role'] = $user['role'];
            } else {
                header("Location: index.php");
                exit;
            }
        } else {
            header("Location: index.php");
            exit;
        }
    } else {
        header("Location: index.php");
        exit;
    }
}

date_default_timezone_set( "Asia/Calcutta" ); 
$fromdate = date( 'Y-m-d H:i:s' );

?>

<!doctype html>
<html lang="en"  class="light-style layout-navbar-fixed layout-menu-fixed layout-compact"  dir="ltr"  data-theme="theme-default"  data-assets-path="assets/"  data-template="vertical-menu-template"  data-style="light">
	<head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <?php include('meta-tag.php');?>
    <meta name="description" content="" />
    <link rel="apple-touch-icon" sizes="180x180" href="../image/favicon/apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="../image/favicon/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="../image/favicon/favicon-16x16.png">
	<link rel="manifest" href="image/favicon/site.webmanifest">
    <link rel="stylesheet" href="assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="assets/vendor/fonts/tabler-icons.css" />
    <link rel="stylesheet" href="assets/vendor/fonts/flag-icons.css" />
    <link rel="stylesheet" href="assets/vendor/css/rtl/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
	<link rel="stylesheet" href="assets/css/demo.css" />
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/css/pages/cards-advance.css" />
    <script src="assets/vendor/js/helpers.js"></script>
<!--    <script src="assets/vendor/js/template-customizer.js"></script>-->
    <script src="assets/js/config.js"></script>
	<script src="assets/js/jquery.min.js"></script>

<script src="assets/js/sweetalert2@11.js"></script>
	
  </head>

  <body>					
	

<?php include('header.php');?>	
<?php main(); ?>
            <!-- Footer -->
            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl">
                <div
                  class="footer-container d-flex align-items-center justify-content-between py-4 flex-md-row flex-column">
                  <div class="text-body">
                    ©
                    <script>
                      document.write(new Date().getFullYear());
                    </script> Verix Engineers. All Rights Reserved.
                    
                  </div>
                  
                </div>
              </div>
            </footer>
            <!-- / Footer -->

           
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      
    </div>
   

    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/libs/hammer/hammer.js"></script>
    <script src="assets/vendor/libs/i18n/i18n.js"></script>
    <script src="assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <script src="assets/vendor/libs/swiper/swiper.js"></script>
    <script src="assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/tables-datatables-advanced.js"></script>
  </body>
</html>

				