<?php
require_once '../inc/db.php';
require_once '../models/ProductCategoryModel.php';


$productCategory = new ProductCategoryModel($conn); // Corrected variable name

if ($_SERVER['REQUEST_METHOD'] === 'GET' && ($_GET['action'] ?? '') === 'productcatlist') {
    $result = $conn->query("SELECT * FROM product_categories ORDER BY id ASC");
    $html = '';

    while ($row = $result->fetch_assoc()) {
        $img = $row['image'] ? "<img src='../uploads/products/{$row['image']}' width='60'>" : 'No image';
		$statusText = $row['status'] ? '1' : '0';
        //$imageTag = $user['profile_photo'] ? "<img src='uploads/{$user['profile_photo']}' style='max-width:50px;'>" : '';
        $checked = $row['status'] ? 'checked' : '';
        $statusSwitch = "<label class='switch switch-success'>
            <input type='checkbox' class='switch-input toggleStatus' data-id='{$row['id']}' $checked />
            <span class='switch-toggle-slider'>
              <span class='switch-on'><i class='icon-base ti tabler-check'></i></span>
              <span class='switch-off'><i class='icon-base ti tabler-x'></i></span>
            </span>
          </label>";
        
        $html .= "<tr>
            <td>{$row['catname']}</td>
            <td>{$row['description']}</td>
            <td>$img</td>
            <td>{$statusSwitch}</td>
			<td>
                    <button class='btn btn-xs btn-info rounded-pill editBtn' data-id='{$row['id']}' data-bs-toggle='tooltip'
                            data-bs-placement='top'
                            title='edit'><i class='far fa-edit'></i></button>
                    <button class='btn btn-xs btn-danger rounded-pill deleteBtn' data-id='{$row['id']}' data-bs-toggle='tooltip'
                            data-bs-placement='top'
                            title='delete'><i class='far fa-trash-alt'></i></button>
                </td>
            
        </tr>";
    }

    echo $html;
    exit;
}

if ($_POST['action'] == 'getSubcategoriesByCategory') {
    $cat_id = intval($_POST['cat_id']);
    $sql = "SELECT id, subcat_name FROM product_subcategories WHERE cat_id = $cat_id AND status = '1' ORDER BY subcat_name ASC";
    $result = mysqli_query($conn, $sql);
    
    $data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = $row;
    }

    echo json_encode($data);
    exit; // Important to stop further output
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'Create';

    // 🔹 Handle getCategory request
    if ($action === 'getCategory') {
        $id = $_POST['id'] ?? 0;
        $category = $productCategory->getById($id);
        echo json_encode($category);
        exit;
    }

    // 🔹 Handle Create/Update
    $catname = $_POST['catname'] ?? '';
    $description = $_POST['description'] ?? '';
    $id = $_POST['id'] ?? null;

    // File upload
   $imageName = '';

if (isset($_FILES['photo']) && $_FILES['photo']['error'] === 0) {
    $uploadDir = '../../uploads/products/';
    if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true);

    // 🔹 Sanitize the original filename (remove spaces, special characters)
    $originalName = pathinfo($_FILES['photo']['name'], PATHINFO_FILENAME); // without extension
    $extension = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);

    // 🔹 Clean filename: lowercase, dashes, no spaces or parentheses
    $safeName = preg_replace('/[^a-zA-Z0-9-_]/', '', str_replace(' ', '-', strtolower($originalName)));

    // 🔹 Final image name: timestamp_safe-name.ext
    $imageName = time() . '_' . $safeName . '.' . $extension;

    move_uploaded_file($_FILES['photo']['tmp_name'], $uploadDir . $imageName);
}


    // Prepare data
    $data = [
        'catname' => $catname,
        'description' => $description,
        'image' => $imageName
    ];

    $response = ['status' => 'error', 'message' => 'Something went wrong'];

    if ($action === 'Create') {
        if ($productCategory->create($data)) {
            $response = ['status' => 'success', 'message' => 'Product category added'];
        }
    } elseif ($action === 'Update' && $id) {
        if ($productCategory->update($id, $data)) {
            $response = ['status' => 'success', 'message' => 'Product category updated'];
        }
    } elseif ($action === 'delete') {
        $id = $_POST['id'] ?? 0;
        $result = $productCategory->delete($id);
        echo json_encode(['status' => $result ? 'success' : 'error', 'message' => $result ? 'Deleted successfully' : 'Failed to delete']);
        exit;
    } elseif ($action === 'toggleStatus') {
        $id = $_POST['id'] ?? 0;
        $result = $productCategory->toggleStatus($id);
        echo json_encode(['status' => $result ? 'success' : 'error', 'message' => $result ? 'Status updated' : 'Status update failed']);
        exit;
    }

	
	

    echo json_encode($response);
    exit;
}
