<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set("Asia/Calcutta");
require_once 'inc/config.php';

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = isset($_POST['action']) ? $_POST['action'] : '';
    $currentTime = date('Y-m-d H:i:s');

    // Create action
    if ($action === 'Create') {
		
        $hotel_address = mysqli_real_escape_string($conn, $_POST['hotel_address']);
        $email = mysqli_real_escape_string($conn, $_POST['hotel_email']);
        $contact_office = mysqli_real_escape_string($conn, $_POST['contact_office']);
        $contact_mobile = mysqli_real_escape_string($conn, $_POST['contact_mobile']);
        $status = 1; // Active by default

        // Validation
        if (empty($hotel_address) || empty($email) || empty($contact_office)) {
            $response['status'] = 'Error';
            $response['message'] = 'Hotel address, email, and contact office are required.';
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $response['status'] = 'Error';
            $response['message'] = 'Invalid email format.';
        } else {
            $sql = "INSERT INTO contacts (hotel_address, email, contact_office, contact_mobile, status, created_at)
                    VALUES ('$hotel_address', '$email', '$contact_office', '$contact_mobile', '$status', '$currentTime')";
            if (mysqli_query($conn, $sql)) {
                $response['status'] = 'Create';
                $response['message'] = 'Contact created successfully.';
            } else {
                $response['status'] = 'Error';
                $response['message'] = 'Error creating contact: ' . mysqli_error($conn);
            }
        }
    }

    // Update action
    elseif ($action === 'Update') {
        $contact_id = mysqli_real_escape_string($conn, $_POST['id']);
        $hotel_address = mysqli_real_escape_string($conn, $_POST['hotel_address']);
        $email = mysqli_real_escape_string($conn, $_POST['hotel_email']);
        $contact_office = mysqli_real_escape_string($conn, $_POST['contact_office']);
        $contact_mobile = mysqli_real_escape_string($conn, $_POST['contact_mobile']);

        if (empty($contact_id)) {
            $response['status'] = 'Error';
            $response['message'] = 'Contact ID is required for update.';
        } else {
            $sql = "UPDATE contacts 
                    SET hotel_address='$hotel_address', email='$email', contact_office='$contact_office', 
                        contact_mobile='$contact_mobile', updated_at='$currentTime'
                    WHERE contact_id='$contact_id'";
            if (mysqli_query($conn, $sql)) {
                $response['status'] = 'Update';
                $response['message'] = 'Contact updated successfully.';
            } else {
                $response['status'] = 'Error';
                $response['message'] = 'Error updating contact: ' . mysqli_error($conn);
            }
        }
    }

    // Select action
    elseif ($action === 'Select') {
    $contact_id = mysqli_real_escape_string($conn, $_POST['id']); // Match 'id' from AJAX
    $sql = "SELECT * FROM contacts WHERE contact_id='$contact_id'";

    $result = mysqli_query($conn, $sql);
    if ($result && mysqli_num_rows($result) > 0) {
        // Fetch the data and populate $contacts
        $contacts = mysqli_fetch_assoc($result); // Fetch a single row for the given contact_id
        
        $response['status'] = 'Success';
        $response['data'] = $contacts;
    } else {
        $response['status'] = 'Error';
        $response['message'] = 'No contacts found.';
    }

    // Send JSON response
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}



    // Delete action
    

    // Invalid action
    else {
        $response['status'] = 'Error';
        $response['message'] = 'Invalid action specified.';
    }

    // Return JSON response
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>
