<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'inc/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'];

    // Handle Create action
    if ($action === 'Create') {
        $title = $_POST['title'];
		$slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $title), '-'));
        $description = $_POST['description'];
        $max_occupancy = isset($_POST['max_occupancy']) && $_POST['max_occupancy'] !== '' ? $_POST['max_occupancy'] : 0;
        $status = $_POST['status'];

        // Check if the room category already exists
        $checkQuery = "SELECT * FROM banners WHERE title = ?";
        $stmt = $conn->prepare($checkQuery);
        $stmt->bind_param('s', $title);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            echo 'Duplicate';
        } else {
			
			if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $photo = $_FILES['photo'];
            $fileExtension = pathinfo($photo['name'], PATHINFO_EXTENSION);
            $uniqueName = uniqid('cat_', true) . '.' . $fileExtension;
            $photoPath = 'uploads/' . $uniqueName;
            move_uploaded_file($photo['tmp_name'], $photoPath);
			} else {
				$photoPath = NULL;
			}
            // Insert new record
            $insertQuery = "INSERT INTO banners (title, description,slug,photo, status) VALUES (?, ?, ?,?,?)";
            $stmt = $conn->prepare($insertQuery);
            $stmt->bind_param('sssss', $title, $description,$slug, $photoPath, $status);

            if ($stmt->execute()) {
                echo 'Create';
            } else {
                echo 'Error';
            }
        }
    }

    // Handle Update action
    if ($action === 'Update') {
        $id = $_POST['id'];
        $title = $_POST['title'];
		$slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $title), '-'));
        $description = $_POST['description'];
        $max_occupancy = $_POST['max_occupancy'];
        $status = $_POST['status'];
		
		if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $photo = $_FILES['photo'];
            $fileExtension = pathinfo($photo['name'], PATHINFO_EXTENSION);
            $uniqueName = uniqid('cat_', true) . '.' . $fileExtension;
            $photoPath = 'uploads/' . $uniqueName;
            move_uploaded_file($photo['tmp_name'], $photoPath);
			} else {
				$photoPath = NULL;
			}
		 if ($photoPath !== NULL) {
		 // Delete old image before updating
            $sql_check = "SELECT photo FROM banners WHERE id = '$id'";
            $result_check = mysqli_query($conn, $sql_check);
            if ($result_check && mysqli_num_rows($result_check) > 0) {
                $oldImage = mysqli_fetch_assoc($result_check)['photo'];
                if ($oldImage && file_exists($oldImage)) {
                    unlink($oldImage);  // Delete old image
                }
            }
		$updateQuery = "UPDATE banners SET title = ?, description = ?, photo = ?,slug = ?, status = ? WHERE id = ?";
        $stmt = $conn->prepare($updateQuery);
        $stmt->bind_param('sssssi', $title, $description,$photoPath,$slug, $status, $id);
		} else {
        // Update the record
        $updateQuery = "UPDATE banners SET title = ?, description = ?, slug = ?, status = ? WHERE id = ?";
        $stmt = $conn->prepare($updateQuery);
        $stmt->bind_param('ssssi', $title, $description, $slug, $status, $id);
		 }
        if ($stmt->execute()) {
            echo 'Update';
        } else {
            echo 'Error';
        }
    }

    // Handle Select action
    if ($action === 'Select') {
        $id = $_POST['id'];

        // Fetch record details
        $selectQuery = "SELECT * FROM banners WHERE id = ?";
        $stmt = $conn->prepare($selectQuery);
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            echo json_encode($row); // Return record as JSON
        } else {
            echo 'Error';
        }
    }
	
	if ($action === 'StatusChange') {
    
        $id = $_POST['id'];
        $sql_select = "SELECT status FROM banners WHERE id = $id";
        $result_select = mysqli_query($conn, $sql_select);

        if (mysqli_num_rows($result_select) > 0) {
            $row = mysqli_fetch_assoc($result_select);
            $new_status = $row['status'] == 1 ? 0 : 1;
            $sql_update = "UPDATE banners SET status = '$new_status' WHERE id = $id";

            if (mysqli_query($conn, $sql_update)) {
                $status_text = $new_status == 1 ? 'Active' : 'Inactive';
                echo json_encode([
                    'success' => true,
                    'message' => 'Status Updated',
                    'new_status' => $status_text,
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Error while updating status.',
                ]);
            }
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Record not found.',
            ]);
        }
    
}



    // Handle Delete action
    if ($action === 'Delete') {
        $id = $_POST['id'];

        // Delete the record
        $deleteQuery = "DELETE FROM banners WHERE id = ?";
        $stmt = $conn->prepare($deleteQuery);
        $stmt->bind_param('i', $id);

        if ($stmt->execute()) {
            echo 'Delete';
        } else {
            echo 'Error';
        }
    }
}
?>
