<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>

<div class="container-xxl flex-grow-1 container-p-y">
	<button class="btn btn-secondary create-new btn-primary waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#editUser" type="button"><span><i class="ti ti-plus me-sm-1"></i> <span class="d-none d-sm-inline-block">Add New Record</span></span></button>
	<div class="modal fade" id="editUser" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-lg modal-simple modal-edit-user">
                  <div class="modal-content">
                    <div class="modal-body">
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                      <div class="text-center mb-6">
                        <h4 class="mb-2">Banner</h4>
                        </div>
                      <form id="editroomcategory" method="post" class="row g-6" enctype="multipart/form-data">
                        <div class="col-12 col-md-12">
                          <label class="form-label" for="modalEditUserFirstName">Banner Title</label>
                          <input type="text" id="title" name="title"  class="form-control" required />
                        </div>
						<div class="col-12 col-md-12">
                          <label class="form-label" for="modalEditUserFirstName">Description</label>
                          <textarea class="form-control" name="description" id="description"></textarea>
                        </div>
						<!-- <div class="col-12 col-md-12">
                          <label class="form-label" for="modalEditUserFirstName">Max Occupancy</label>
                          <input type="number" id="max_occupancy" name="max_occupancy"  class="form-control" />
                        </div>-->
                        <div class="col-12 col-md-12">
						<label class="form-label" for="multicol-email">Banner Image</label>

						 <input  type="file"  id="photo" class="form-control" accept="image/png, image/jpeg, image/jpg" onchange="loadFile(event)"  />
							<script>
  														var loadFile = function(event) {
    													var output = document.getElementById('output');
    													output.src = URL.createObjectURL(event.target.files[0]);
    													output.onload = function() {
      													URL.revokeObjectURL(output.src) // free memory
    													}
  														};
													</script>								

					</div>
						  <div class="col-md-3">
						

						<img id="output" src="" height="70" width="70" style="display: none;" />
														

					</div>
                        <div class="col-12 col-md-12">
                          <label class="form-label" for="modalEditUserStatus">Status</label>
                          <select id="status" name="status" class="form-select">                        
                            <option value="1">Active</option>
                            <option value="0">Inactive</option>
                            </select>
                        </div>
                       
                        <div class="col-12 text-center">
						<input type="hidden" name="id" id="id" />
                            <input type="hidden" name="action" id="action" value="Create" />
                          <button type="submit" class="btn btn-primary me-3">Submit</button>
                          <button type="reset"  class="btn btn-label-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
			<div class="card">
                 <div class="card-datatable table-responsive">
                  <table class="datatables-ajax table">
                    <thead>
                      <tr>
						<th>Banner Image</th>
                       <th>Title</th>
						<th>Description</th>
						  <!--<th>Max Occupancy</th>-->
                        <th>Status</th>
                        <th>Action</th>
                        
                      </tr>
                    </thead>
					 <tbody>
						 <?php
                            $result = mysqli_query($conn, "SELECT * FROM banners ORDER BY id ASC");
                            while ($row = mysqli_fetch_array($result)) {
                            ?>
                            <tr class="showtr">
								<td>
                <img src="<?php echo !empty($row['photo']) ? htmlspecialchars($row['photo']) : 'assets/img/no-image.jpg'; ?>" 
                     alt="Room Photo" width="250" height="100">
            </td>
                                <td><?php echo htmlspecialchars(ucwords($row['title'])); ?></td>
								<td><?php echo htmlspecialchars(ucwords($row['description'])); ?></td>
	                             <?php /*?>  <td><?php echo htmlspecialchars($row['max_occupancy']); ?></td><?php */?>
                                <td>
                                    <label class="switch">
                                        <input type="checkbox" class="switch-input" value="<?php echo $row[0]; ?>"
                                               <?php if ($row['status'] == '1') echo "checked"; ?>
                                               onClick="statusChange(this.value);" />
                                        <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                        </span>
                                    </label>
                                </td>
                                <td>
									<button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-warning update"><i class="far fa-edit"></i></button>
                   				 <button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-danger delete"><i class="far fa-trash-alt"></i></button>
                                   
                                </td>
								</tr>
                            <?php } ?>
					  </tbody>
                    
                  </table>
                </div>
              </div>
	

</div>

<script>
  $(document).ready(function () {
    // Open modal for creating a new record
    $('#modal_button').click(function () {
      $('#editUser').modal('show'); // Show modal
      $('#editroomcategory')[0].reset(); // Reset form
      $('.modal-title').text("Create New banner"); // Set modal title
      $('#action').val('Create'); // Set action to "Create"
      $('#id').val(''); // Clear hidden ID field
    });

    // Open modal for updating a record
    $(document).on('click', '.update', function () {
      var id = $(this).attr("id");
      $.ajax({
        url: "banner_action.php",
        method: "POST",
        data: { id: id, action: 'Select' },
        dataType: "json",
        success: function (data) {
          $('#editUser').modal('show'); // Show modal
          $('#title').val(data.title); // Populate banner
          $('#description').val(data.description); // Populate description
          $('#max_occupancy').val(data.max_occupancy); // Populate max occupancy
          $('#status').val(data.status); // Populate status
          $('.modal-title').text("Update banner"); // Set modal title
          $('#action').val('Update'); // Set action to "Update"
          $('#id').val(id); // Set hidden ID field
			
		  if (data.photo) {
                    $('#output').attr('src', data.photo).show();
                } else {
                    $('#output').hide();
                }
        },
        error: function () {
          toastr.error('Error fetching banner details.');
        },
      });
    });

    // Handle form submission for Create/Update
    $('#editroomcategory').on('submit', function (event) {
  event.preventDefault();

  // Create a new FormData object
  var formData = new FormData();
  
  // Append form data to FormData object
  formData.append('id', $('#id').val());
  formData.append('title', $('#title').val());
  formData.append('description', $('#description').val());
  formData.append('max_occupancy', $('#max_occupancy').val());
  formData.append('status', $('#status').val());
  formData.append('action', $('#action').val());
  
  // Append file if selected
  var file = $('#photo').prop('files')[0];
  if (file) {
    formData.append('photo', file);
  }

  // Validate required fields
  if (formData.get('title') !== '') {
    // AJAX request
    $.ajax({
      url: "banner_action.php",
      method: "POST",
      data: formData,
      processData: false,  // Prevent jQuery from processing the data
      contentType: false,  // Prevent jQuery from setting content type
      success: function (response) {
        $('#editUser').modal('hide'); // Hide modal after submission

        // Show SweetAlert response based on server's response
        if (response === 'Create') {
          Swal.fire({
            title: 'Created!',
            text: 'Banner Created Successfully.',
            icon: 'success',
            confirmButtonText: 'OK'
          }).then(() => {
            location.reload(); // Redirect to details list
          });
        } else if (response === 'Update') {
          Swal.fire({
            title: 'Updated!',
            text: 'Banner Updated Successfully.',
            icon: 'success',
            confirmButtonText: 'OK'
          }).then(() => {
            location.reload(); // Redirect to details list
          });
        } else if (response === 'Duplicate') {
          Swal.fire({
            title: 'Duplicate!',
            text: 'Banner already exists.',
            icon: 'error',
            confirmButtonText: 'OK'
          });
        } else {
          Swal.fire({
            title: 'Error!',
            text: 'Error saving banner.',
            icon: 'error',
            confirmButtonText: 'OK'
          });
        }
      },
      error: function () {
        Swal.fire({
          title: 'Error!',
          text: 'Error saving banner.',
          icon: 'error',
          confirmButtonText: 'OK'
        });
      },
    });
  } else {
    // If any required fields are empty, show SweetAlert error message
    Swal.fire({
      title: 'Error!',
      text: 'All required fields must be filled.',
      icon: 'error',
      confirmButtonText: 'OK'
    });
  }
});


    // Handle delete action
    $(document).on('click', '.delete', function () {
    var id = $(this).attr("id");
    var row = $(this).closest('tr'); // Reference the row for deletion

    // SweetAlert2 confirmation
    Swal.fire({
        title: 'Are you sure?',
        text: 'You are about to delete this banner.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            // Proceed with AJAX delete request
            $.ajax({
                url: "banner_action.php",
                method: "POST",
                data: { id: id, action: 'Delete' },
                success: function (response) {
                    if (response === 'Delete') {
                        Swal.fire({
                            title: 'Deleted!',
                            text: 'banner Deleted Successfully.',
                            icon: 'success',
                            confirmButtonText: 'OK'
                        });

                        // Animate row removal
                        row.css('background-color', '#f8d7da').fadeOut(800, function () {
                            $(this).remove();
                        });
                    } else {
                        Swal.fire({
                            title: 'Error!',
                            text: 'There was an error deleting the banner.',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        title: 'Error!',
                        text: 'Error deleting banner.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                },
            });
        }
    });
});
window.statusChange = function (id) {
    $.ajax({
        url: 'banner_action.php',
        method: 'POST',
        data: { id: id, action: 'StatusChange' },
        success: function (response) {
            // Parse the response manually
            const data = JSON.parse(response);

            if (data.success) {
                alert(`Status changed to ${data.new_status}`);
            } else {
                alert(data.message);
            }
        },
        error: function () {
            alert('Error while updating status.');
        }
    });
};

  });
</script>
<?php } ?>