<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>

<div class="container-xxl flex-grow-1 container-p-y">
	<button class="btn btn-secondary create-new btn-primary waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#adminModal" type="button"><span><i class="ti ti-plus me-sm-1"></i> <span class="d-none d-sm-inline-block">Add User</span></span></button>
	<div class="modal fade" id="adminModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="adminForm" method="post" enctype="multipart/form-data">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Add/Edit User</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" id="id" name="id" />
	  		<input type="hidden" id="role" name="role" value="admin" />
          <div class="row mb-3">
            <div class="col-md-6 mb-3">
              <label class="form-label">Name</label>
              <input type="text" class="form-control" name="name" id="name" required />
            </div>
            <div class="col-md-6 mb-3">
              <label class="form-label">Mobile</label>
              <input type="tel" class="form-control" name="phone" id="phone" required />
            </div>
			<div class="col-md-12 mb-3">
              <label class="form-label">Email</label>
              <input type="email" class="form-control" name="email" id="email" />
            </div>


			   <div class="col-md-12 mb-6 form-password-toggle">
                  <label class="form-label" for="password">Password</label>
                  <div class="input-group input-group-merge">
                    <input
                      type="password"
                      id="password"
                      class="form-control"
                      name="password"
                      placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                      aria-describedby="password" />
                    <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                  </div>
                </div>
			  
          </div>
          
          
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </div>
    </form>
  </div>
</div>
	<div class="card">
              
		
                <div class="card-datatable table-responsive">
                  <table class="datatables-ajax table table-bordered table-responsive">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Mobile</th>
                                <th>Email</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $result = mysqli_query($conn, "SELECT * FROM users ORDER BY id ASC");
                            while ($row = mysqli_fetch_array($result)) {
                            ?>
                            <tr class="showtr">
                                <td><?php echo htmlspecialchars($row['name']); ?></td>
                                <td><?php echo htmlspecialchars($row['phone']); ?></td>
                                <td><?php echo htmlspecialchars($row['email']); ?></td>
                                <td>
                                    <label class="switch">
                                        <input type="checkbox" class="switch-input" value="<?php echo $row['id']; ?>"
                                               <?php if ($row['status'] == '1') echo "checked"; ?>
                                               onClick="statusChange(this.value);" />
                                        <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                        </span>
                                    </label>
                                </td>
                                <td>
									<button type="button" id="<?php echo $row["id"]; ?>" class="btn btn-xs btn-warning update"><i class="far fa-edit"></i></button>
                   				 <button type="button" id="<?php echo $row["id"]; ?>" class="btn btn-xs btn-danger delete"><i class="far fa-trash-alt"></i></button>
                                   
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
              </div>
</div>
<script>
  $(document).ready(function () {
    // Open modal for creating new record
    $('#modal_button').click(function () {
      $('#adminModal').modal('show');
      $('#adminForm')[0].reset();
      $('.modal-title').text("Create New Record");
      $('#id').val('');
      $('#password').val('').closest('.form-password-toggle').show(); // show password
    });

    // Open modal for updating record
    $(document).on('click', '.update', function () {
      var id = $(this).attr("id");
      $.ajax({
        url: "admin_master_action.php",
        method: "POST",
        data: { id: id, action: 'Select' },
        dataType: "json",
        success: function (data) {
          $('#adminModal').modal('show');
          $('#name').val(data.name);
          $('#phone').val(data.phone);
          $('#email').val(data.email);
          $('#id').val(id);
          $('.modal-title').text("Update User");
          $('#password').val('');
          $('#password').closest('.form-password-toggle').hide(); // hide password field on update
        },
        error: function () {
          Swal.fire('Error', 'Error fetching data.', 'error');
        }
      });
    });

    // Submit form (create/update)
    $('#adminForm').on('submit', function (event) {
      event.preventDefault();

      let name = $('#name').val();
      let phone = $('#phone').val();
      let email = $('#email').val();
      let password = $('#password').val();
      let id = $('#id').val();
      let role = $('#role').val();
      let action = id === '' ? 'Create' : 'Update';

      if (name && phone && email) {
        if (action === 'Create' && password === '') {
          Swal.fire('Validation Error', 'Password is required for new records.', 'warning');
          return;
        }

        $.ajax({
          url: "admin_master_action.php",
          method: "POST",
          data: {
            adminname: name,
            mobile: phone,
            adminuser: email,
            password: password,
            id: id,
            role: role,
            action: action
          },
          success: function (data) {
            $('#adminModal').modal('hide');

            if (data.action === 'Create') {
              Swal.fire('Success', 'User created successfully.', 'success');
            } else if (data.action === 'Update') {
              Swal.fire('Success', 'User updated successfully.', 'success');
            } else if (data.action ==='Duplicate') {
              Swal.fire('Error', 'Mobile number or username already exists.', 'error');
              return;
            } else {
              Swal.fire('Error', 'An unexpected error occurred.', 'error');
              return;
            }

            setTimeout(() => {
              location.reload();
            }, 1500);
          },
          error: function () {
            Swal.fire('Error', 'Error while inserting data.', 'error');
          }
        });
      } else {
        Swal.fire('Validation Error', 'All fields are required.', 'warning');
      }
    });

    // Prevent space in password
    $('#password').on('keypress', function (event) {
      if (event.which === 32) return false;
    });
 
     // Handle delete action
    $(document).on('click', '.delete', function () {
    var id = $(this).attr("id");
    var row = $(this).closest('tr'); // Reference the row for deletion

    // SweetAlert2 confirmation
    Swal.fire({
        title: 'Are you sure?',
        text: 'You are about to delete this.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            // Proceed with AJAX delete request
            $.ajax({
                url: "admin_master_action.php",
                method: "POST",
                data: { id: id, action: 'Delete' },
                success: function (response) {
                    if (response.success && response.action === 'Delete') {
                        Swal.fire({
                            title: 'Deleted!',
                            text: 'Deleted Successfully.',
                            icon: 'success',
                            confirmButtonText: 'OK'
                        });

                        // Animate row removal
                        row.css('background-color', '#f8d7da').fadeOut(800, function () {
                            $(this).remove();
                        });
                    } else {
                        Swal.fire({
                            title: 'Error!',
                            text: 'There was an error deleting the user.',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        title: 'Error!',
                        text: 'Error deleting user.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                },
            });
        }
    });
});
window.statusChange = function (id) {
    $.ajax({
        url: 'admin_master_action.php',
        method: 'POST',
        data: { id: id, action: 'StatusChange' },
        success: function (response) {
            // Parse the response manually
            const data = JSON.parse(response);

            if (data.success) {
                alert(`Status changed to ${data.new_status}`);
            } else {
                alert(data.message);
            }
        },
        error: function () {
            alert('Error while updating status.');
        }
    });
};
});

</script>
<?php } ?>