<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include("inc/template.php");

function main() {
    global $conn;
        
?>

<div class="container-xxl flex-grow-1 container-p-y">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb breadcrumb-custom-icon">
            <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
            <li class="breadcrumb-item"><a href="newspepars_order_add.php">Pepar Order Add</a></li>
            <li class="breadcrumb-item active">Pepar Order List</li>
        </ol>
    </nav>

    <!-- Filter: Financial Year -->
    <div class="mb-3 w-25">
        <label for="financialYearFilter" class="form-label">Financial Year:</label>
        <select id="financialYearFilter" class="form-select">
            
            <?php
                require_once 'models/FyModel.php';
                $fyModel = new FyModel($conn);
                $financialyears = $fyModel->dropdownFinancialYears();
                while ($row = $financialyears->fetch_assoc()) {
                    echo '<option value="' . $row['id'] . '">' . $row['year_label'] . '</option>';
                }
            ?>
        </select>
    </div>

    <!-- Alert Box -->
    <div id="alert-box" class="alert d-none" role="alert"></div>

    <!-- Orders Table -->
    <div class="card mt-3">
        <div class="card-datatable text-nowrap">
            <table class="datatables-ajax table table-bordered">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Bill No</th>
                        <th>Agency Name</th>
                        <th>Total Qty</th>
                        <th>Amount</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="3" class="text-end">Total:</th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                </tfoot>
                <tbody></tbody>
            </table>
        </div>
    </div>

    <!-- Modal to View Order Details -->
    <div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                  <button type="button" class="btn btn-xs btn-primary me-2" id="printOrderBtn">
                    <i class="fas fa-print"></i> Print Invoice
                </button>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="table-responsive text-nowrap">
                    <table class="table table-sm table-bordered">
                        <thead>
                            <tr>
                                <th>Paper Name</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th>Total</th>
                                <th>Remarks</th>
                            </tr>
                        </thead>
                        <tbody id="modal-content-body">
                            <!-- Items will be loaded here -->
                        </tbody>
                        <tfoot id="modal-footer">
                            <!-- Footer will be generated dynamically -->
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</div>
<script>
$(document).ready(function() {

    // Toast Function
    function showToast(message, type = 'success') {
        const alertBox = $('#alert-box');
        alertBox.removeClass('d-none alert-success alert-danger')
                .addClass(`alert alert-${type}`)
                .text(message);
        setTimeout(() => {
            alertBox.addClass('d-none').removeClass(`alert-${type}`).text('');
        }, 3000);
    }
    function capitalizeWords(str) {
        if (!str) return '';
        return str.toLowerCase().replace(/\b\w/g, txt => txt.toUpperCase());
    }
    $(document).on('click', '.viewBtn', function() {
    var id = $(this).data('id');
    $('#modal-content-body').html('<tr><td colspan="5" class="text-center py-5"><div class="spinner-border" role="status"></div></td></tr>');
    $('#modal-footer').html('');

    $.ajax({
        url: 'fetch_sales_items.php',
        type: 'POST',
        data: { id: id },
        dataType: 'json',
        success: function(response) {
            if(response.items && response.items.length > 0){
                let tbodyHtml = '';
                let totalQty = 0;
                let subtotal = 0;

                response.items.forEach(item => {
                    let total = item.rate * item.qty;
                    tbodyHtml += `<tr>
                    
                        <td>${capitalizeWords(item.newspaper_name)}</td>
                        <td>${item.rate.toFixed(2)}</td>
                        <td>${item.qty}</td>
                        <td>${total.toFixed(2)}</td>
                        <td>${item.remarks}</td>
                    </tr>`;
                    totalQty += parseInt(item.qty);
                    subtotal += total;
                });

                $('#modal-content-body').html(tbodyHtml);

                // Build footer dynamically
                let footerHtml = `
                    <tr>
                        <th colspan="2" class="text-end">Total Qty</th>
                        <th>${totalQty}</th>
                        <th></th>
						<th></th>
                    </tr>
                    <tr>
                        <th colspan="3" class="text-end">Subtotal</th>
                        <th>${subtotal.toFixed(2)}</th>
                        <th></th>
                    </tr>
                `;

                if(response.transport_charge > 0){
                    footerHtml += `
                        <tr>
                            <th colspan="3" class="text-end">Transport Charge</th>
                            <th>${response.transport_charge.toFixed(2)}</th>
                            <th></th>
                        </tr>
                    `;
                }

                if(response.discount > 0){
                    footerHtml += `
                        <tr>
                            <th colspan="3" class="text-end">Discount</th>
                            <th>${response.discount.toFixed(2)}</th>
                            <th></th>
                        </tr>
                    `;
                }

                let grandTotal = subtotal + (response.transport_charge || 0) - (response.discount || 0);
                footerHtml += `
                    <tr>
                        <th colspan="3" class="text-end">Grand Total</th>
                        <th>${grandTotal.toFixed(2)}</th>
                        <th></th>
                    </tr>
                `;

                $('#modal-footer').html(footerHtml);

            } else {
                $('#modal-content-body').html('<tr><td colspan="5" class="text-center">No items found</td></tr>');
            }
			$('#printOrderBtn').off('click').on('click', function(){
                window.open('print_order.php?id=' + id, '_blank');
            });
            $('#viewModal').modal('show');
        },
        error: function() {
            $('#modal-content-body').html('<tr><td colspan="5" class="text-danger">Failed to load details. Please try again.</td></tr>');
        }
    });
});

    // Delete Order
    $(document).on('click', '.deleteBtn', function () {
        const id = $(this).data('id');
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you really want to delete this order?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.post('controllers/NewsOrderController.php', {
                    action: 'deleteOrder',
                    id: id
                }, function(res) {
                    let result = JSON.parse(res);
                    if (result.status === 'success') {
                        orderTable.ajax.reload(null, false);
                        Swal.fire('Deleted!', result.message, 'success');
                    } else {
                        Swal.fire('Error!', result.message, 'error');
                    }
                });
            }
        });
    });

    // Initialize DataTable
    const orderTable = $('.datatables-ajax').DataTable({
        processing: true,
        serverSide: true,
        responsive: false,
        ajax: {
            url: 'controllers/NewsOrderController.php',
            type: 'POST',
            data: function(d){
            d.action = 'datatable';
            d.financial_year_id = $('#financialYearFilter').val(); // pass selected year
        }
        },
        pageLength: 25,
        order: [[0, 'desc']],
        columns: [
            { data: 'sale_date' },
            { data: 'bill_no' },
            { data: 'agency_name', render: d => capitalizeWords(d) },
            { data: 'total_qty' },
            { data: 'total_amount' },
            { data: 'actions', orderable: false, searchable: false }
        ],
        dom:
            '<"row mx-3 justify-content-between"' +
            '<"d-md-flex justify-content-between align-items-center dt-layout-start col-md-auto me-auto"lB>' +
            '<"d-md-flex justify-content-between align-items-center dt-layout-end col-md-auto ms-auto mt-0"f>' +
            '>' +
            '<"table-responsive"t>' +
            '<"row mx-3 justify-content-between"' +
            '<"col-sm-12 col-md-6"i>' +
            '<"col-sm-12 col-md-6 d-flex justify-content-end"p>' +
            '>',
        buttons: [
            {
                extend: 'print',
                text: 'Print',
                footer: true,
                className: 'btn btn-sm btn-primary',
                exportOptions: { columns: ':visible:not(:last-child)' }
            },
            {
                extend: 'csv',
                text: 'CSV',
                footer: true,
                className: 'btn btn-sm btn-primary',
                exportOptions: { columns: ':visible:not(:last-child)' }
            }
        ],
        footerCallback: function (row, data, start, end, display) {
            var api = this.api();
            var totalQty = api.column(3, { page: 'current' }).data().reduce(function(a, b){
                return parseFloat(a||0) + parseFloat(b||0);
            }, 0);
            var totalAmount = api.column(4, { page: 'current' }).data().reduce(function(a, b){
                return parseFloat(a||0) + parseFloat(b||0);
            }, 0);

            $(api.column(3).footer()).html(+ totalQty);
            $(api.column(4).footer()).html(totalAmount.toFixed(2));

            // $(api.column(4).footer()).html(+ totalAmount.toFixed(2));
        }
    });
	// Reload DataTable on financial year change
$('#financialYearFilter').on('change', function(){
    orderTable.ajax.reload();
});
});
</script>
<?php } ?>
