<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include("inc/template.php");

function main() {
    global $conn;
    require_once 'models/FyModel.php';
    $fyModel = new FyModel($conn);
    $financialYear = $fyModel->getActiveFinancialYearId();
    $financialYearId = $financialYear['id'];
    $financialYearLabel = $financialYear['year_label'];
?>
<div class="container-xxl flex-grow-1 container-p-y">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb breadcrumb-custom-icon">
            <li class="breadcrumb-item"><a href="dashboard.php">Home</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i></li>
            <li class="breadcrumb-item"><a href="newspepars_order_list.php">Pepar Order List</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i></li>
            <li class="breadcrumb-item active">Pepar Add</li>
        </ol>
    </nav>

    <form id="newsForm">
        <div class="card mb-4 shadow-sm">
            
            <div class="card-body">
                <div class="row g-3 mb-3">
                    <!-- Bill Date -->
                    <div class="col-md-3">
                        <label for="sale_date" class="form-label">Bill Date</label>
                        <input type="date" class="form-control" name="sale_date" id="sale_date" value="<?= date('Y-m-d') ?>" required>
                    </div>

                    <!-- Bill No -->
                    <div class="col-md-3">
                        <label for="bill_no" class="form-label">Bill No.</label>
                        <input type="text" class="form-control" name="bill_no" id="bill_no" required>
                    </div>

                    <!-- Agency -->
                    <div class="col-md-6">
                        <label for="agency_id" class="form-label">Agency Name</label>
                        <select name="agency_id" id="agency_id" class="form-select" required>
                            <option value="">-- Select Agency --</option>
                            <?php
                            require_once 'models/AgencyModel.php';
                            $agencyModel = new AgencyModel($conn);
                            $agencies = $agencyModel->dropdownAgency();
                            while ($row = $agencies->fetch_assoc()) {
                                echo '<option value="' . $row['id'] . '">' . ucwords(htmlspecialchars($row['agencyname'])) . '</option>';
                            }
                            ?>
                        </select>
                    </div>

                    <!-- Newspaper -->
                    <div class="col-md-6">
                        <label for="newspaper_id" class="form-label">Newspaper Name</label>
                        <select name="newspaper_id" id="newspaper_id" class="form-select">
                            <option value="">-- Select Paper --</option>
                            <?php
                            require_once 'models/NewspaperModel.php';
                            $newspaperModel = new NewspaperModel($conn);
                            $newspapers = $newspaperModel->dropdownnewpepars();
                            while ($row = $newspapers->fetch_assoc()) {
                                echo '<option value="' . $row['id'] . '" data-price="' . $row['price'] . '">' . ucwords(htmlspecialchars($row['name'])) . '</option>';
                            }
                            ?>
                        </select>
                    </div>

                    <!-- Rate -->
                    <div class="col-md-3">
                        <label for="price" class="form-label">Rate</label>
                        <input type="number" name="price" id="price" class="form-control" step="0.01" value="0.00">
                    </div>

                    <!-- Quantity -->
                    <div class="col-md-3">
                        <label for="qty" class="form-label">Quantity</label>
                        <input type="number" name="qty" id="qty" class="form-control" value="1">
                    </div>

                    <!-- Remarks -->
                    <div class="col-md-12">
                        <label for="remarks" class="form-label">Remarks</label>
                        <input type="text" class="form-control" name="remarks" id="remarks">
                    </div>
                </div>

                <!-- Hidden Inputs -->
                <input type="hidden" name="financial_year_id" value="<?= $financialYearId ?>">
                <input type="hidden" name="created_by" value="<?= $_SESSION['admin_id'] ?>">

                <!-- Add Product Button -->
                <div class="text-end mb-3">
                    <button type="button" class="btn btn-primary add-row">Add Product</button>
                </div>

                <!-- Product Table -->
                <div class="table-responsive">
                    <table class="table table-bordered table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Newspaper</th>
                                <th>Rate</th>
                                <th>Qty</th>
                                <th>Total</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="podata"></tbody>
                        <tfoot>
                            <tr>
                                <th colspan="3" class="text-end">Total Qty</th>
                                <th id="totalQty">0</th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="4" class="text-end">Subtotal</th>
                                <th id="subtotal">0.00</th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="4" class="text-end">Transport Charge</th>
                                <th><input type="number" id="transport" name="transport" style="width: 80px;" class="form-control form-control-sm" value="0" step="0.01"></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="4" class="text-end">Discount</th>
                                <th><input type="number" id="discount" name="discount" style="width: 80px;" class="form-control form-control-sm" value="0" step="0.01"></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="4" class="text-end">Grand Total</th>
                                <th id="grandtotal">0.00</th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <!-- Save Buttons -->
                <div class="text-end mt-3">
                    <button type="button" class="btn btn-success save-order">Save Order</button>
                    <button type="button" class="btn btn-success save-print">Save & Print</button>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- Scripts -->

<script>
$(document).ready(function() {
    // Auto-set price
    $('#newspaper_id').on('change', function() {
        $('#price').val(parseFloat($(this).find(':selected').data('price') || 0).toFixed(2));
    });

    // Add row
    // Add row
$('.add-row').on('click', function() {
    let paperId = $('#newspaper_id').val();
    let paperName = $('#newspaper_id option:selected').text();
    let price = parseFloat($('#price').val()) || 0;
    let qty = parseInt($('#qty').val()) || 0;

    if (!paperId || price <= 0 || qty <= 0) {
        alert('Please select newspaper, enter rate & qty.');
        return;
    }

    // ===== Prevent duplicate newspaper in table =====
    let exists = false;
    $('#podata input[name="newspaper_id[]"]').each(function() {
        if ($(this).val() == paperId) {
            exists = true;
            return false; // break loop
        }
    });
    if (exists) {
        alert('This newspaper is already added!');
        return;
    }

    let total = (price * qty).toFixed(2);
    let row = `
        <tr>
            <td class="sl"></td>
            <td>${paperName}<input type="hidden" name="newspaper_id[]" value="${paperId}"></td>
            <td>${price.toFixed(2)}<input type="hidden" name="price[]" value="${price}"></td>
            <td>${qty}<input type="hidden" name="qty[]" value="${qty}"></td>
            <td class="row-total">${total}</td>
            <td><button type="button" class="btn btn-xs btn-danger delete-row">Delete</button></td>
        </tr>`;
    $('#podata').append(row);

    // Reset
    $('#newspaper_id').val('');
    $('#price').val('0.00');
    $('#qty').val('1');

    updateSerials();
    updateTotals();
});


    // Delete row
    $('#podata').on('click', '.delete-row', function() {
        $(this).closest('tr').remove();
        updateSerials();
        updateTotals();
    });

    // Update serial numbers
    function updateSerials() {
        $('#podata tr').each(function(index) {
            $(this).find('.sl').text(index + 1);
        });
    }

    // Update totals
    function updateTotals() {
        let subtotal = 0, totalQty = 0;
        $('#podata tr').each(function() {
            subtotal += parseFloat($(this).find('.row-total').text()) || 0;
            totalQty += parseInt($(this).find('input[name="qty[]"]').val()) || 0;
        });
        let transport = parseFloat($('#transport').val()) || 0;
        let discount = parseFloat($('#discount').val()) || 0;
        let grandTotal = Math.max(0, subtotal + transport - discount);

        $('#subtotal').text(subtotal.toFixed(2));
        $('#totalQty').text(totalQty);
        $('#grandtotal').text(grandTotal.toFixed(2));
    }

    $('#transport, #discount').on('input', updateTotals);

    // Save Order
    function saveOrder(printAfter = false) {
        if ($('#podata tr').length === 0) { alert('Add at least one newspaper.'); return; }
        if (!$('#bill_no').val().trim()) { alert('Bill No. is required.'); return; }

        let formData = new FormData($('#newsForm')[0]);
        formData.append('action', 'saveOrder');

        $.ajax({
            url: 'controllers/NewsOrderController.php',
            method: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function(res) {
                try {
                    let result = JSON.parse(res);
                    if (result.status === 'success') {
                        alert('Order saved successfully!');
                        $('#newsForm')[0].reset();
                        $('#podata').empty();
                        updateTotals();
                        if (printAfter) window.open('print_order.php?id=' + result.order_id, '_blank');
                    } else alert(result.message || 'Save failed.');
                } catch (err) { console.error(res); alert('Invalid server response.'); }
            },
            error: function() { alert('Server error during save.'); }
        });
    }

    $('.save-order').click(() => saveOrder(false));
    $('.save-print').click(() => saveOrder(true));
});

</script>
<?php } ?>
