<?php
class AgencyModel {
    private $conn;
	private $uploadPath = "../uploads/agency/";
    public function __construct($db) {
        $this->conn = $db;
    }

    public function getAgencyById($id) {
        $stmt = $this->conn->prepare("SELECT * FROM agency WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }
	
	public function dropdownAgency() {
        $stmt = $this->conn->prepare("SELECT id, agencyname FROM agency WHERE status = 'active' ORDER BY id asc");
        $stmt->execute();
        return $stmt->get_result();
    }
	
	public function viewAgencyById($id) {
    $id = intval($id);
    $sql = "SELECT * FROM agency WHERE id = $id LIMIT 1";
    $res = $this->conn->query($sql);

    if ($res && $res->num_rows > 0) {
        $row = $res->fetch_assoc();
        return $row;
    }
    return null;
}


    /** Duplicate checks */
    public function checkDuplicate($field, $value, $id = 0) {
        $allowed = ["email", "phone", "registration_no"];
        if (!in_array($field, $allowed)) return false;

        $stmt = $this->conn->prepare("SELECT id FROM agency WHERE $field = ? AND id != ?");
        $stmt->bind_param("si", $value, $id);
        $stmt->execute();
        return $stmt->get_result()->num_rows > 0;
    }

    /** ✅ Save (Insert/Update) Agency */
    public function saveAgency($data, $logo_filename = '') {
    if (!empty($data['id'])) {
        // fetch old logo
        $old = $this->getAgencyById($data['id']);
    $oldLogo = $old['logo'] ?? '';

    // If no new logo uploaded, keep old one
    if (empty($logo_filename)) {
        $logo_filename = $oldLogo;
    } else {
        // If new uploaded, delete old file
        if ($oldLogo && file_exists($this->uploadPath . $oldLogo)) {
            unlink($this->uploadPath . $oldLogo);
        }
    }

        $sql = "UPDATE agency 
                SET agencyname=?, ownername=?, registration_no=?, gst_no=?, 
                    email=?, phone=?, address=?, city=?, state=?, country=?, 
                    pincode=?, website=?, status=?, logo=? 
                WHERE id=?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param(
            "ssssssssssssssi",
            $data['agencyname'],
            $data['ownername'],
            $data['registration_no'],
            $data['gst_no'],
            $data['email'],
            $data['phone'],
            $data['address'],
            $data['city'],
            $data['state'],
            $data['country'],
            $data['pincode'],
            $data['website'],
            $data['status'],
            $logo_filename, // ✅ will be old logo if new not uploaded
            $data['id']
        );
        return $stmt->execute();
    } else {
        // Insert new agency
        $sql = "INSERT INTO agency 
            (agencyname, ownername, registration_no, gst_no, email, phone, 
            address, city, state, country, pincode, website, status, logo) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param(
            "ssssssssssssss",
            $data['agencyname'],
            $data['ownername'],
            $data['registration_no'],
            $data['gst_no'],
            $data['email'],
            $data['phone'],
            $data['address'],
            $data['city'],
            $data['state'],
            $data['country'],
            $data['pincode'],
            $data['website'],
            $data['status'],
            $logo_filename
        );
        return $stmt->execute();
    }
}

    /** ✅ Delete Agency + Logo Unlink */
    public function deleteAgency($id) {
        $row = $this->getAgencyById($id);
        if ($row && $row['logo']) {
            $logoPath = $this->uploadPath . $row['logo'];
            if (file_exists($logoPath)) {
                unlink($logoPath);
            }
        }

        $stmt = $this->conn->prepare("DELETE FROM agency WHERE id = ?");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }
	
	public function getAgency($start, $length, $search = '') {
    $where = "WHERE 1"; // Always true, so we can append filters easily

    if (!empty($search)) {
        $search = $this->conn->real_escape_string($search);
        $where .= " AND (
            agencyname LIKE '%$search%' 
            OR ownername LIKE '%$search%'
            OR registration_no LIKE '%$search%' 
            OR email LIKE '%$search%' 
            OR phone LIKE '%$search%'
            OR city LIKE '%$search%'
            OR state LIKE '%$search%'
            OR country LIKE '%$search%'
        )";
    }

    // Count total agencies
    $totalResult = $this->conn->query("SELECT COUNT(*) as total FROM agency");
    $total = $totalResult->fetch_assoc()['total'];

    // Count filtered
    $filteredResult = $this->conn->query("SELECT COUNT(*) as total FROM agency $where");
    $filtered = $filteredResult->fetch_assoc()['total'];

    // Fetch paginated data
    $sql = "SELECT * FROM agency $where ORDER BY id DESC LIMIT $start, $length";
    $res = $this->conn->query($sql);

    $data = [];
    while ($row = $res->fetch_assoc()) {
        $row['created_at'] = date('d-m-Y', strtotime($row['created_at']));

        if (!empty($row['logo']) && file_exists("../uploads/agency/" . $row['logo'])) {
            $row['logo'] = '<img src="../uploads/agency/' . $row['logo'] . '" alt="Logo" class="img-thumbnail" width="50">';
        } else {
            $row['logo'] = '<span class="text-muted">No Logo</span>';
        }

        $checked = ($row['status'] === 'active') ? 'checked' : '';

       

        $row['actions'] = '
    <button class="btn btn-info btn-xs viewAgency" data-id="'.$row['id'].'"><i class="tf-icons ti ti-eye"></i></button>
    <button class="btn btn-warning btn-xs" onclick="window.location.href=\'agency_add.php?id='.$row['id'].'\'"><i class="tf-icons ti ti-edit"></i></button>
    <button class="btn btn-danger btn-xs deleteAgency" data-id="'.$row['id'].'"><i class="tf-icons ti ti-trash"></i></button>
';


        $data[] = $row;
    }

    return [
        "total"    => $total,
        "filtered" => $filtered,
        "data"     => $data
    ];
}
public function toggleStatus($id) {
    $agency = $this->getAgencyById($id);
    if (!$agency) return false;

    // Flip status
    $newStatus = ($agency['status'] === 'active') ? 'inactive' : 'active';

    $stmt = $this->conn->prepare("UPDATE agency SET status = ? WHERE id = ?");
    $stmt->bind_param("si", $newStatus, $id);
    if ($stmt->execute()) {
        return $newStatus; // return string directly
    }
    return false;
}


}
