<?php
session_start();
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../models/ResetAuthModel.php';
//require_once __DIR__ . '/../models/AuthModel.php'; // Make sure this exists

$resetModel = new ResetAuthModel($conn);
//$authModel = new AuthModel($conn);

$action = $_POST['action'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($action === 'forgotPassword') {
        $email = $_POST['email'] ?? '';

        $user = $resetModel->findUserByEmail($email);

        if ($user) {
            // Generate token and expiry
            $token = bin2hex(random_bytes(32));
            $expiry = date('Y-m-d H:i:s', strtotime('+1 hour'));

            // Store token in DB
            $stmt = $conn->prepare("UPDATE users SET reset_token = ?, reset_token_expiry = ? WHERE email = ?");
            $stmt->bind_param('sss', $token, $expiry, $email);
            $stmt->execute();

            // Respond with reset link (you can replace with actual mail sending)
            echo json_encode([
                'status' => 'success',
                'message' => 'Reset link generated.',
                'reset_url' => "https://successinfotech.net/newspaper_agency/reset_password.php?token=$token"
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Email not found.'
            ]);
        }

        exit;
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'resetPassword') {
    $token = $_POST['token'] ?? '';
    $newPassword = $_POST['new_password'] ?? '';

    if (empty($token) || empty($newPassword)) {
        echo json_encode(['status' => 'error', 'message' => 'Missing fields.']);
        exit;
    }

    if ($resetModel->resetPassword($token, $newPassword)) {
        echo json_encode(['status' => 'success', 'message' => 'Password reset successful.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid or expired token.']);
    }
}
}
