<?php
session_start();
require_once __DIR__.'/../inc/db.php';
require_once __DIR__.'/../models/AuthModel.php';

$model = new AuthModel($conn);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email-username'] ?? '');
    $password = $_POST['password'] ?? '';
    $remember = isset($_POST['remember']);

    $user = $model->login($email, $password);

    if (is_array($user)) {
        // Set session
        $_SESSION['admin_id'] = $user['id'];
        $_SESSION['admin_name'] = $user['name'];
        $_SESSION['admin_email'] = $user['email'];
        $_SESSION['welcome_message'] = 'Welcome, ' . htmlspecialchars($user['name']) . '!';

        // Update last login
        $stmt = $conn->prepare("UPDATE users SET last_login = NOW() WHERE id = ?");
        $stmt->bind_param("i", $user['id']);
        $stmt->execute();

        // Remember me cookies
        if ($remember) {
            setcookie('admin_email', $user['email'], time() + 604800, "/"); // 7 days
            setcookie('admin_token', base64_encode($user['id']), time() + 604800, "/");
        }

        echo json_encode(['status' => 'success', 'message' => 'Login successful']);
    } else {
        $messages = [
            'inactive' => 'Your account is not active. Contact admin.',
            'not_admin' => 'Access denied. Admins only.',
            'invalid_password' => 'Incorrect password.',
            'not_found' => 'User not found.',
        ];

        echo json_encode(['status'=>'error','message'=>$messages[$user] ?? 'Login failed']);
    }
}
