<?php include('inc/template.php'); ?>
<div class="container-fluid flex-grow-1 container-p-y">
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.php">Home</a></li>
      <li class="breadcrumb-item"><a href="vehicle_booking_list.php">Vehicle Booking List</a></li>
      <li class="breadcrumb-item active">
        <?php echo isset($_GET['id']) ? 'Update Vehicle Booking' : 'Add Vehicle Booking'; ?>
      </li>
    </ol>
  </nav>
<div class="row">
		<div class="col-9">
  <div class="card shadow p-4">
    <form id="vehicleBookingForm" method="post" enctype="multipart/form-data">
      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">Booking Date</label>
          <input type="date" name="booking_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
        </div>

        <div class="col-md-8">
							<label for="customer_id" class="form-label">Customer Name</label>
							<input type="hidden" id="inquiry_id" name="inquiry_id" />
							<select name="customer_id" id="customer_id" required class="select2 form-select form-select-lg">
								<option value="">Select Customer</option>

								<!-- In-Progress Inquiry Customers -->
								<optgroup label="In-Progress Inquiries">
									<?php
									$inProgress = $conn->query( "SELECT c.id AS customer_id,c.name,c.phone, i.id AS inquiry_id FROM customers c INNER JOIN inquiries i ON c.id = i.customer_id AND i.inquiry_type = 'vehicle' AND i.status = 'in-progress' WHERE c.status = 'active' ORDER BY c.name ASC" );
									if ( $inProgress->num_rows > 0 ) {
										while ( $row = $inProgress->fetch_assoc() ) {
											echo '<option value="' . $row[ 'customer_id' ] . '" data-inquiry="' . $row[ 'inquiry_id' ] . '">'
											. htmlspecialchars( ucwords( strtolower( $row[ 'name' ] ) ) ) . ' (' . $row[ 'phone' ] . ')'
											. '</option>';
										}
									} else {
										echo '<option disabled>No in-progress inquiries</option>';
									}
									?>
								</optgroup>

								<!-- Other Customers (no in-progress inquiry) -->
								<optgroup label="Other Customers">
									<?php
									$others = $conn->query( "SELECT c.id AS customer_id, c.name, c.phone FROM customers c WHERE c.status = 'active' AND c.id NOT IN ( SELECT customer_id FROM inquiries WHERE status = 'in-progress' AND inquiry_type = 'package' ) ORDER BY c.name ASC" );
									if ( $others->num_rows > 0 ) {
										while ( $row = $others->fetch_assoc() ) {
											echo '<option value="' . $row[ 'customer_id' ] . '" data-inquiry="">'
											. htmlspecialchars( ucwords( strtolower( $row[ 'name' ] ) ) ) . ' (' . $row[ 'phone' ] . ')'
											. '</option>';
										}
									} else {
										echo '<option disabled>All customers have in-progress inquiries</option>';
									}
									?>
								</optgroup>
							</select>

						</div>

        <div class="col-md-4">
          <label class="form-label">Vehicle Type</label>
			 <select name="vehicle_type" id="vehicle_type" class="form-select">
        <option value="">Select Vehicle</option>
        <?php
          $query = "SELECT id, vehicle_type FROM vehicles WHERE status='active' ORDER BY id ASC";
          $result = mysqli_query($conn, $query);
          while ($r = mysqli_fetch_assoc($result)) {
            echo "<option value='{$r['vehicle_type']}'>{$r['vehicle_type']}</option>";
          }
        ?>
      </select>
          
        </div>

        <div class="col-md-4">
          <label class="form-label">Vehicle Name / Model</label>
          <input type="text" name="vehicle_name" id="vehicle_name" class="form-control" required>
        </div>

        <div class="col-md-4">
          <label class="form-label">Trip Type</label>
          <select name="trip_type" id="trip_type" class="form-select" required>
            <option value="one_way">One Way</option>
            <option value="round_trip">Round Trip</option>
            <!--<option value="local">Local</option>-->
          </select>
        </div>

        <div class="col-md-4">
          <label class="form-label">Pickup Location</label>
          <input type="text" name="vehicle_pickup_location" id="vehicle_pickup_location" class="form-control" required>
        </div>

        <div class="col-md-4">
          <label class="form-label">Drop Location</label>
          <input type="text" name="vehicle_drop_location" id="vehicle_drop_location" class="form-control" required>
        </div>

        <div class="col-md-4">
          <label class="form-label">Pickup Datetime</label>
          <input type="datetime-local" name="vehicle_pickup_datetime" id="vehicle_pickup_datetime" class="form-control" required min="<?= date('Y-m-d\TH:i'); ?>">
        </div>

        <div class="col-md-4 return-date">
          <label class="form-label">Return Datetime</label>
          <input type="datetime-local" name="vehicle_return_datetime" id="vehicle_return_datetime" class="form-control" min="<?= date('Y-m-d\TH:i'); ?>">
        </div>
		<div class="col-md-3">
          <label class="form-label">Passengers</label>
          <input type="number" name="vehicle_passengers" id="vehicle_passengers" class="form-control" min="1" value="1">
        </div>
        <div class="col-md-3">
          <label class="form-label">Total KMs</label>
          <input type="number" name="vehicle_total_km" id="vehicle_total_km" class="form-control" min="0" value="0">
        </div>

        <div class="col-md-3">
          <label class="form-label">Rate per KM (â‚¹)</label>
          <input type="number" name="vehicle_rate_per_km" id="vehicle_rate_per_km" class="form-control" min="0" value="0">
        </div>

        <div class="col-md-3">
          <label class="form-label">Driver Allowance (â‚¹)</label>
          <input type="number" name="vehicle_driver_allowance" id="vehicle_driver_allowance" class="form-control" min="0" value="0">
        </div>

        <div class="col-md-3">
          <label class="form-label">Other Charges (â‚¹)</label>
          <input type="number" name="extra_charges" id="extra_charges" class="form-control" value="0">
        </div>

        <div class="col-md-3">
          <label class="form-label">Discount %</label>
          <input type="number" name="discount" id="discount" class="form-control" min="0" value="0">
        </div>

        <div class="col-md-3">
          <label class="form-label">With GST?</label>
          <select name="gst_included" id="gst_included" class="form-select">
            <option value="no">No</option>
            <option value="yes">Yes</option>
          </select>
          <input type="hidden" name="gst_rate" id="gst_rate" value="5">
        </div>

        <div class="col-md-4">
          <label class="form-label">Grand Total (â‚¹)</label>
          <input type="text" name="grand_total" id="grand_total" class="form-control fw-bold text-success" readonly>
        </div>

        <div class="col-md-4">
					<label for="payment_mode" class="form-label">Payment Mode</label>
					<select name="payment_mode" id="payment_mode" class="form-select" required>
						<option value="">Select Mode</option>
						<option value="cash">Cash</option>
						<option value="upi">UPI</option>
						<option value="bank">Bank Transfer</option>
						<option value="card">Card</option>
						<option value="online">Online</option>
					</select>
				</div>

        <!-- UPI Details -->
				<div class="col-md-4" id="upi_details_group" style="display:none;">
					<label for="upi_id" class="form-label">UPI ID</label>
					<input type="text" name="upi_id" id="upi_id" class="form-control" placeholder="e.g. username@upi">
				</div>

				<!-- Bank Details -->
				<div class="col-md-4" id="bank_details_group" style="display:none;">
					<label for="bank_name" class="form-label">Bank Name</label>
					<input type="text" name="bank_name" id="bank_name" class="form-control" placeholder="Bank Name">
				</div>

				<div class="col-md-4" id="account_no_group" style="display:none;">
					<label for="account_no" class="form-label">Account / Cheque No</label>
					<input type="text" name="account_no" id="account_no" class="form-control" placeholder="Account or Cheque Number">
				</div>

				<div class="col-md-4" id="transaction_id_group" style="display:none;">
					<label for="transaction_id" class="form-label">Transaction / Reference ID</label>
					<input type="text" name="transaction_id" id="transaction_id" class="form-control" placeholder="Transaction ID">
				</div>

				<!-- Advance Payment -->
				<div class="col-md-4" id="advance_payment_group" style="display:none;">
					<label for="advance_payment" class="form-label">Advance Payment (INR)</label>
					<input type="number" name="advance_payment" id="advance_payment" class="form-control" min="1" placeholder="Enter amount">
				</div>
        <input type="hidden" name="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">
        <input type="hidden" name="id" value="<?php echo $_GET['id'] ?? ''; ?>">
        <input type="hidden" name="created_by" value="<?php echo $userId; ?>">
      </div>

      <div class="mt-4">
        <button type="submit" class="btn btn-primary me-2">Save</button>
        <button type="button" id="download-pdf" class="btn btn-success me-2">Download PDF</button>
        <button type="reset" class="btn btn-secondary">Reset</button>
      </div>
    </form>
  </div>
</div>
<div class="col-3">
  <div class="card shadow p-4 sticky-card">
    <div class="row g-3">
      <h5>Vehicle Inquiry Detail</h5>

      <div class="col-md-12">
        <label class="form-label">Vehicle Type</label>
        <input type="text" id="type" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Pickup Location</label>
        <input type="text" id="from_city" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Drop Location</label>
        <input type="text" id="to_city" class="form-control" readonly>
      </div>
	<div class="col-md-12">
        <label class="form-label">Pickup Datetime</label>
        <input type="text" id="pickup_date" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Drop Datetime</label>
        <input type="text" id="drop_date" class="form-control" readonly>
      </div>

      
      <div class="col-md-12">
        <label class="form-label">Passengers</label>
        <input type="text" id="vpassengers" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Remarks</label>
        <textarea id="remarks" class="form-control" rows="4" readonly></textarea>
      </div>
    </div>
  </div>
</div>
</div>
</div>
<script>
$(document).ready(function () {
	
 // Show/hide return date
  $('#trip_type').on('change', function () {
    if ($(this).val() === 'round_trip') {
      $('.return-date').show();
      $('#return_date').prop('required', true);
    } else {
      $('.return-date').hide();
      $('#return_date').prop('required', false);
    }
  }).trigger('change');
  // ================================
  // Payment Mode Toggle
  // ================================
  $('#payment_mode').on('change', function () {
    const mode = $(this).val();

    // Hide all optional groups
    $('#upi_details_group, #bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group').hide();
    $('#upi_id, #bank_name, #account_no, #transaction_id, #advance_payment').prop('required', false).val('');

    if (mode === 'upi') {
      $('#upi_details_group, #transaction_id_group, #advance_payment_group').show();
      $('#upi_id, #transaction_id, #advance_payment').prop('required', true);
    } else if (mode === 'bank' || mode === 'card' || mode === 'online') {
      $('#bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group').show();
      $('#bank_name, #account_no, #transaction_id, #advance_payment').prop('required', true);
    } else if (mode === 'cash') {
      $('#advance_payment_group').show();
      $('#advance_payment').prop('required', true);
    }
  });

  // Convert string to number safely
  function num(v) {
    return parseFloat(v) || 0;
  }

  // ================================
  // ðŸ”¹ Total Calculation Function
  // ================================
  function calculateTotal() {
    const km = num($('#vehicle_total_km').val());
    const rate = num($('#vehicle_rate_per_km').val());
    const driver = num($('#vehicle_driver_allowance').val());
    const other = num($('#extra_charges').val());
    const discount = num($('#discount').val());
    const gstRate = num($('#gst_rate').val());
    const gstIncluded = $('#gst_included').val();

    let total = (km * rate) + driver + other;
    let discountAmt = (discount > 0) ? (total * discount / 100) : 0;
    total -= discountAmt;

    if (gstIncluded === 'yes') {
      total += total * gstRate / 100;
    }

    $('#grand_total').val(total.toFixed(2));
  }

  // Trigger calculation on relevant inputs
  $('#vehicle_total_km, #vehicle_rate_per_km, #vehicle_driver_allowance, #extra_charges, #discount, #gst_included')
    .on('input change', calculateTotal);

  calculateTotal();
  // ================================
  // Customer Fetch Inquiry Details (Flight)
  // ================================

  $('#customer_id').on('change', function () {
  const customerId = $(this).val();

  if (customerId) {
    $.ajax({
      url: 'ajax/fetchInquiryDetails.php',
      type: 'POST',
      data: { customer_id: customerId, type: 'vehicle' },
      dataType: 'json',
      beforeSend: function () {
        $('#inquiry_id,#type,#from_city,#to_city,#pickup_date,#drop_date,#vpassengers,#remarks').val('');
      },
      success: function (res) {
        if (res.status === 'success') {
          const d = res.vehicle || {};

          function formatDate(dateStr) {
            if (!dateStr) return '';
            const date = new Date(dateStr);
            if (isNaN(date)) return dateStr;
            return date.toLocaleString('en-IN', {
              day: '2-digit',
              month: '2-digit',
              year: 'numeric',
              hour: '2-digit',
              minute: '2-digit',
              hour12: true
            });
          }

          $('#inquiry_id').val(d.inquiry_id || 0);
          $('#type').val(d.vehicle_type || '');
          $('#from_city').val(d.vehicle_pickup_location || '');
          $('#to_city').val(d.vehicle_drop_location || '');
          $('#pickup_date').val(formatDate(d.vehicle_pickup_datetime));
          $('#drop_date').val(formatDate(d.vehicle_drop_datetime));
          $('#vpassengers').val(d.vehicle_passengers || '');
          $('#remarks').val(d.remarks || '');
        }
      },
      error: function () {
        toastr.error('Error fetching vehicle inquiry details.');
      }
    });
  } else {
    $('#inquiry_id,#type,#from_city,#to_city,#pickup_date,#drop_date,#vpassengers,#remarks').val('');
  }
});


  // ================================
  // Ã°Å¸â€Â¹ Form Submission + PDF Download
  // ================================
  let downloadPdfAfterSubmit = false;

  $('#download-pdf').click(function (e) {
    e.preventDefault();
    downloadPdfAfterSubmit = true;
    $('#vehicleBookingForm').submit();
  });

  $('#vehicleBookingForm').submit(function (e) {
    e.preventDefault();

    const payment = parseFloat($('#advance_payment').val() || 0);
    if (payment <= 0) {
      toastr.error('Advance payment must be greater than 0.');
      return false;
    }

    const formData = new FormData(this);

    $.ajax({
      url: 'controller/VehicleBookingController.php',
      method: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      dataType: 'json',
      success: function (response) {
        if (response.status === 'success') {
          toastr.success(response.message);

          if (downloadPdfAfterSubmit && response.id) {
            window.open('controller/DownloadPDFVehicleBookingController.php?id=' + response.id, '_blank');
            downloadPdfAfterSubmit = false;
          }

          setTimeout(() => window.location.href = 'vehicle_booking_list.php', 1500);
        } else {
          toastr.error(response.message || 'Failed to save booking.');
        }
      },
      error: function (xhr, status, error) {
        toastr.error('An error occurred while submitting the form.');
        console.error('AJAX Error:', status, error, xhr.responseText);
      }
    });
  });
});
</script>

<?php include('inc/footer.php'); ?>
