<?php include('inc/template.php');?>

<div class="container-fluid flex-grow-1 container-p-y">
<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
    <li class="breadcrumb-item active">Vehicles Master</li>
    </ol>
</nav>
    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#vehicleModal">
        <span class="ti-xs ti ti-plus me-1"></span> Add New Vehicles
    </button>
    <div class="row mb-4">
                <!--  Modal -->
        <div class="modal fade" id="vehicleModal" tabindex="-1" aria-labelledby="vehicleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <form id="vehicleForm">
                    <div class="modal-header">
                        <h5 class="modal-title">Add/Edit Vehicle</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="vehicle_type" class="form-label">Vehicle Type</label>
                            <input type="text" id="vehicle_type" name="vehicle_type" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label for="quantity" class="form-label">Quantity</label>
                            <input type="number" id="quantity" name="quantity" class="form-control" min="1" required>
                        </div>
                        <input type="hidden" name="id" id="id">
                        <input type="hidden" name="action" id="action" value="Create">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save</button>
                    </div>
                </form>
                </div>
            </div>
        </div>

        <!-- Users Table -->
        <div class="col-xl-12 col-lg-6 col-md-6">
            <div class="card">
                <div class="card-datatable table-responsive pt-0">
                    <table class="datatables-ajax table table-bordered table-responsive">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Vehicle</th>
                                <th>Quantity</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
							$n = 0;
                            $result = mysqli_query($conn, "SELECT * FROM vehicles ORDER BY id ASC");
                            while ($row = mysqli_fetch_array($result)) {
							$n++;
                            ?>
                            <tr class="showtr">
                                <td><?php echo $n; ?></td>
                                <td><?php echo htmlspecialchars($row['vehicle_type']); ?></td>
                                <td><?php echo htmlspecialchars($row['quantity']); ?></td>
                                							
                                <td>
                                    <label class="switch">
                                        <input type="checkbox" class="switch-input" value="<?php echo $row[0]; ?>"
                                               <?php if ($row['status'] == 'active') echo "checked"; ?>
                                               onClick="statusChange(this.value);" />
                                        <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                        </span>
                                    </label>
                                </td>
                                <td>
									
									<button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-warning update"><i class="far fa-edit"></i></button>
                   				 <button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-danger delete"><i class="far fa-trash-alt"></i></button>
                                   
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function () {

    // Show modal for Create
    $('#modal_button').click(function () {
        $('#vehicleForm')[0].reset();
        $('.modal-title').text("Create New Record");
        $('#action').val('Create');
        $('#id').val('');
        $('#vehicleModal').modal('show');
    });

    // Show modal for Update
$(document).on('click', '.update', function () {
    const id = $(this).attr("id");
    $.ajax({
        url: "controller/VehicleController.php",
        method: "POST",
        data: { id: id, action: 'Select' },
        dataType: "json",
        success: function (res) {
            if(res.status === 'success') {
                $('#vehicle_type').val(res.data.vehicle_type);
                $('#quantity').val(res.data.quantity);
                $('#id').val(res.data.id);
                $('#action').val('Update');
                $('#vehicleModal .modal-title').text('Edit Vehicle');
                $('#vehicleModal').modal('show');
            } else {
                toastr.error(res.message);
            }
        },
        error: function () {
            toastr.error('Error fetching data.');
        }
    });
});


    // Submit form (Create/Update)
    $('#vehicleForm').submit(function(e) {
        e.preventDefault();
        $.ajax({
            url: 'controller/VehicleController.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(res) {
                if(res.status === 'success') {
                    toastr.success(res.message);
                    $('#vehicleModal').modal('hide');
                    setTimeout(()=> location.reload(), 500);
                } else {
                    toastr.error(res.message);
                }
            },
            error: function() { toastr.error('Error processing request.'); }
        });
    });

    // Status change
    window.statusChange = function (id) {
        $.ajax({
            url: 'controller/VehicleController.php',
            method: 'POST',
            data: { id: id, action: 'ToggleStatus' },
            dataType: "json",
            success: function (response) {
                if (response.status === 'success') {
                    const newStatus = response.new_status === "active" ? "Active" : "Inactive";
                    toastr.success(`Status changed to ${newStatus}`);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function () {
                toastr.error('Failed to update status.');
            }
        });
    };

    // Delete user
    $(document).on('click', '.delete', function () {
        const id = $(this).attr("id");
        const row = $(this).closest('tr');

        if (confirm('Are you sure you want to delete?')) {
            $.ajax({
                url: 'controller/VehicleController.php',
                method: 'POST',
                data: { id: id, action: 'Delete' },
                dataType: "json",
                success: function (response) {
                    if (response.status === 'success') {
                        toastr.success(response.message);
                        row.css('background-color', '#f8d7da').fadeOut(800, function () {
                            $(this).remove();
                        });
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error('Error deleting user.');
                }
            });
        }
    });

});
</script>


<?php include('inc/footer.php');?>