<?php include('inc/template.php'); ?>

<div class="container-fluid flex-grow-1 container-p-y">

  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.php">Home</a></li>
      <li class="breadcrumb-item active">Payment Ledger Report</li>
    </ol>
  </nav>

  <div class="card shadow-sm">
    <div class="card-body">
      <h5 class="card-title mb-4"><i class="ti ti-report-money me-2"></i>Payment Ledger Report</h5>

      <!-- 🔹 Filters -->
      <form class="row g-3 mb-4" method="GET">
        <div class="col-md-3">
          <label class="form-label">From Date</label>
          <input type="date" name="from_date" class="form-control" 
                 value="<?= htmlspecialchars($_GET['from_date'] ?? '') ?>">
        </div>
        <div class="col-md-3">
          <label class="form-label">To Date</label>
          <input type="date" name="to_date" class="form-control" 
                 value="<?= htmlspecialchars($_GET['to_date'] ?? '') ?>">
        </div>
        <div class="col-md-3">
          <label class="form-label">Search (Name / Phone)</label>
          <input type="text" name="search" class="form-control" placeholder="Enter name or phone"
                 value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">
        </div>
        <div class="col-md-3 align-self-end">
          <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary flex-fill">
              <i class="ti ti-filter me-1"></i> Filter
            </button>
            <a href="payment_ledger_report.php" class="btn btn-secondary flex-fill">
              <i class="ti ti-refresh me-1"></i> Reset
            </a>
          </div>
        </div>
      </form>

      <!-- 🔹 Report Table -->
      <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle text-center">
          <thead class="table-light">
            <tr>
              <th>#</th>
              <th>Date</th>
              <th>Receipt No</th>
              <th>Customer Name</th>
              <th>Mode</th>
              <th>Type</th>
              <th>Amount (₹)</th>
              <th>Narration</th>
            </tr>
          </thead>
          <tbody>
          <?php
          // 🔹 Get active financial year
          $fyQuery = $conn->query("SELECT year_label FROM financial_years WHERE status='active' ORDER BY id DESC LIMIT 1");
          $currentFY = ($fyQuery->num_rows > 0) ? $fyQuery->fetch_assoc()['year_label'] : '';

          // 🔹 Filters
          $where = "WHERE 1";

          if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {
              $from = $_GET['from_date'];
              $to   = $_GET['to_date'];
              $where .= " AND DATE(p.payment_date) BETWEEN '$from' AND '$to'";
          } elseif ($currentFY) {
              $where .= " AND p.financial_year = '$currentFY'";
          }

          if (!empty($_GET['search'])) {
              $search = $conn->real_escape_string($_GET['search']);
              $where .= " AND (c.name LIKE '%$search%' OR c.phone LIKE '%$search%')";
          }

          // 🔹 Fetch payment data
          $query = "
            SELECT 
              p.id,
              DATE(p.payment_date) AS payment_date,
              p.receipt_no,
              c.name AS customer_name,
              c.phone,
              p.mode,
              p.payment_type,
              p.amount,
              p.narration
            FROM payments p
            LEFT JOIN customers c ON p.customer_id = c.id
            $where
            ORDER BY p.payment_date ASC
          ";

          $result = $conn->query($query);
          $i = 1;
          $total_received = 0;
          $total_refund = 0;

          if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
              $isRefund = $row['payment_type'] === 'refund';
              $color = $isRefund ? 'text-danger' : 'text-success';
              $sign = $isRefund ? '-' : '+';

              if ($isRefund)
                $total_refund += $row['amount'];
              else
                $total_received += $row['amount'];
          ?>
            <tr>
              <td><?= $i++; ?></td>
              <td><?= htmlspecialchars($row['payment_date']); ?></td>
              <td><?= htmlspecialchars($row['receipt_no']); ?></td>
              <td><?= htmlspecialchars($row['customer_name'] ?? ''); ?></td>
              <td><?= htmlspecialchars(ucfirst($row['mode'])); ?></td>
              <td class="<?= $color; ?>"><?= ucfirst($row['payment_type']); ?></td>
              <td class="<?= $color; ?>"><?= $sign . ' ₹' . number_format($row['amount'], 2); ?></td>
              <td><?= htmlspecialchars($row['narration'] ?? ''); ?></td>
            </tr>
          <?php } 
          } else {
            echo '<tr><td colspan="8" class="text-muted">No payments found</td></tr>';
          }
          ?>
          </tbody>
          <tfoot class="fw-bold table-secondary">
            <tr>
              <td colspan="6" class="text-end">Total Received:</td>
              <td>₹<?= number_format($total_received, 2); ?></td>
              <td></td>
            </tr>
            <tr>
              <td colspan="6" class="text-end text-danger">Total Refund:</td>
              <td class="text-danger">₹<?= number_format($total_refund, 2); ?></td>
              <td></td>
            </tr>
            <tr>
              <td colspan="6" class="text-end">Net Total:</td>
              <td>₹<?= number_format($total_received - $total_refund, 2); ?></td>
              <td></td>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include('inc/footer.php');?>