<?php include('inc/template.php');?>

<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="index.php">Home</a>
			</li>
			<li class="breadcrumb-item active">Package Category wise List</li>
		</ol>
	</nav>

	<button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#categoryModal">
    <span class="ti-xs ti ti-plus me-1"></span> Add Package Category wise
</button>


	<div class="row mb-4">
		<!-- Modal -->
		<div class="modal fade" id="categoryModal" tabindex="-1" aria-labelledby="categoryModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<form id="categoryForm">
						<div class="modal-header">
							<h5 class="modal-title" id="categoryModalLabel">Add/Edit Package Category wise</h5>
							<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
						</div>
						<div class="modal-body">
							<!-- Package -->
							<div class="mb-3">
								<label for="destination_id" class="form-label">Destination / State</label>
								<select id="destination_id" name="destination_id" class="form-select select2" required>
									<option value="">Select Destination</option>
									<?php
									$destinations = mysqli_query( $conn, "SELECT id, state_name FROM states WHERE status='1' ORDER BY state_name ASC" );
									while ( $d = mysqli_fetch_assoc( $destinations ) ) {
										echo "<option value='{$d['id']}'>{$d['state_name']}</option>";
									}
									?>
								</select>
							</div>
							<div class="mb-3">
								<label for="package_id" class="form-label">Package</label>
								<select id="package_id" name="package_id" class="form-select" required>
									<option value="">Select Package</option>
									<!-- Packages will be loaded dynamically via AJAX -->
								</select>
							</div>
							<!-- Category -->
							<div class="mb-3">
								<label for="category_id" class="form-label">Category Name</label>
								<select id="category_id" name="category_id" class="form-select" required>
									<option value="">Select Category</option>
									<?php
									$categories = mysqli_query( $conn, "SELECT id, category_name FROM package_categories WHERE status='active' ORDER BY category_name ASC" );
									while ( $c = mysqli_fetch_assoc( $categories ) ) {
										echo "<option value='{$c['id']}'>{$c['category_name']}</option>";
									}
									?>
								</select>
							</div>

							<!-- Purchase Price -->
							<div class="mb-3">
								<label for="purchase_price" class="form-label">Purchase Price</label>
								<input type="number" step="0.01" id="purchase_price" name="purchase_price" class="form-control" placeholder="Enter Purchase Price" required/>
							</div>

							<!-- Sale Price -->
							<div class="mb-3">
								<label for="sale_price" class="form-label">Sale Price</label>
								<input type="number" step="0.01" id="sale_price" name="sale_price" class="form-control" placeholder="Enter Sale Price" required/>
							</div>
						</div>
						<div class="modal-footer">
							<input type="hidden" id="id" name="id"/>
							<input type="hidden" id="action" name="action" value="Create"/>
							<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
							<button type="submit" class="btn btn-primary">Save</button>
						</div>
					</form>
				</div>
			</div>
		</div>

		<!-- Table -->
		<div class="col-xl-12 col-lg-6 col-md-6">
			<div class="card">
				<div class="card-datatable table-responsive pt-0">
					<table class="datatables-ajax table table-bordered table-responsive">
						<thead>
							<tr>
								<th>#</th>
								<th>Category</th>
								<th>Code</th>
								<th>Package</th>
								<th>Day / Night</th>
								<th>Purchase Price (₹)</th>
								<th>Sale Price (₹)</th>
								<th>Status</th>
								<th>Action</th>
							</tr>
						</thead>
						<tbody>
							<?php
							$n = 0;
							$result = mysqli_query( $conn, "
            SELECT pcp.id, pk.package_code, pk.package_name, pk.days, pk.nights, pc.category_name, pcp.purchase_price, pcp.sale_price, pcp.status
            FROM package_category_prices pcp
            JOIN packages pk ON pk.id = pcp.package_id
            JOIN package_categories pc ON pc.id = pcp.category_id
            ORDER BY pcp.id ASC
        " );
							while ( $row = mysqli_fetch_assoc( $result ) ) {
								$n++;
								$packageName = ucwords( strtolower( $row[ 'package_name' ] ) );
								?>
							<tr>
								<td>
									<?= $n ?>
								</td>
								<td>
									<?= htmlspecialchars($row['category_name']) ?>
								</td>
								<td>
									<?= htmlspecialchars($row['package_code']) ?>
								</td>
								<td>
									<?= htmlspecialchars($packageName) ?>
								</td>
								<td>
									<?= (int)$row['days'] ?>D /
									<?= (int)$row['nights'] ?>N</td>
								<td>
									<?= number_format($row['purchase_price'], 2) ?>
								</td>
								<td>
									<?= number_format($row['sale_price'], 2) ?>
								</td>
								<td>
									<label class="switch">
                    <input type="checkbox" class="switch-input" value="<?= (int)$row['id'] ?>"
                        <?= ($row['status'] === 'active') ? "checked" : "" ?>
                        onclick="statusChange(this.value);" />
                    <span class="switch-toggle-slider">
                        <span class="switch-on"></span>
                        <span class="switch-off"></span>
                    </span>
                </label>
								
								</td>
								<td>
									<button type="button" class="btn btn-sm btn-info" onclick="location.href='package_categorywise_overview.php?id=<?= (int)$row['id']; ?>'">
                    <i class="far fa-eye"></i>
                </button>
								
									<button type="button" id="<?= (int)$row['id'] ?>" class="btn btn-sm btn-warning update">
                    <i class="far fa-edit"></i>
                </button>
								
									<button type="button" id="<?= (int)$row['id'] ?>" class="btn btn-sm btn-danger delete">
                    <i class="far fa-trash-alt"></i>
                </button>
								
								</td>
							</tr>
							<?php } ?>
						</tbody>
					</table>

				</div>
			</div>
		</div>
	</div>
</div>


<script>
	$( document ).ready( function () {

		// ----------------------------
		// 1. Reset modal on open
		// ----------------------------
		$( '#categoryModal' ).on( 'show.bs.modal', function () {
			// Only reset when adding a new record, not editing
			if ( $( '#action' ).val() !== 'Update' ) {
				$( '#categoryForm' )[ 0 ].reset();
				$( '#action' ).val( 'Create' );
				$( '#id' ).val( '' );
				$( '#package_id' ).html( '<option value="">Select Package</option>' );
				$( '.modal-title' ).text( 'Add Package Category Price' );
			}
		} );


		// ----------------------------
		// 2. Load Packages dynamically based on Destination
		// ----------------------------
		$( '#destination_id' ).on( 'change', function () {
			let destId = $( this ).val();
			$( '#package_id' ).html( '<option value="">Loading...</option>' );

			if ( destId ) {
				$.ajax( {
					url: 'controller/PackageCategoryPriceController.php',
					type: 'POST',
					data: {
						action: 'GetPackages',
						destination_id: destId
					},
					dataType: 'json',
					success: function ( res ) {
						if ( res.status === 'success' ) {
							let options = '<option value="">Select Package</option>';
							$.each( res.data, function ( i, pkg ) {
								options += `<option value="${pkg.id}">${pkg.package_code} - ${pkg.package_name} (${pkg.days}D / ${pkg.nights}N)</option>`;
							} );
							$( '#package_id' ).html( options );
						} else {
							$( '#package_id' ).html( '<option value="">No packages found</option>' );
						}
					},
					error: function () {
						$( '#package_id' ).html( '<option value="">Error loading packages</option>' );
					}
				} );
			} else {
				$( '#package_id' ).html( '<option value="">Select Package</option>' );
			}
		} );

		// ----------------------------
		// 3. Create / Update Form
		// ----------------------------
		$( '#categoryForm' ).on( 'submit', function ( e ) {
			e.preventDefault();
			$.ajax( {
				url: 'controller/PackageCategoryPriceController.php',
				type: 'POST',
				data: $( this ).serialize(),
				dataType: 'json',
				success: function ( res ) {
					if ( res.status === 'success' ) {
						toastr.success( res.message );
						$( '#categoryModal' ).modal( 'hide' );
						setTimeout( () => location.reload(), 500 );
					} else {
						toastr.error( res.message );
					}
				},
				error: function () {
					toastr.error( 'Error processing request.' );
				}
			} );
		} );

		// ----------------------------
		// 4. Edit / Load record
		// ----------------------------
		$( document ).on( 'click', '.update', function () {
			let id = $( this ).attr( 'id' );
			$.post( 'controller/PackageCategoryPriceController.php', {
				id: id,
				action: 'Select'
			}, function ( res ) {
				if ( res.status === 'success' ) {
					const data = res.data;

					// Fill hidden fields and inputs
					$( '#id' ).val( data.id );
					$( '#action' ).val( 'Update' );
					$( '#category_id' ).val( data.category_id ).trigger( 'change' ); // category
					$( '#purchase_price' ).val( data.purchase_price );
					$( '#sale_price' ).val( data.sale_price );

					// Set destination and load packages
					$( '#destination_id' ).val( data.destination_id ).trigger( 'change' );

					// After destination packages are loaded, select the correct package
					$( document ).one( 'ajaxStop', function () {
						$( '#package_id' ).val( data.package_id ).trigger( 'change' );
					} );

					$( '#categoryModal' ).modal( 'show' );
					$( '.modal-title' ).text( 'Edit Package Category Price' );
				} else {
					toastr.error( res.message );
				}
			}, 'json' );
		} );


		// ----------------------------
		// 5. Toggle Status
		// ----------------------------
		window.statusChange = function ( id ) {
			$.post( 'controller/PackageCategoryPriceController.php', {
				id: id,
				action: 'ToggleStatus'
			}, function ( res ) {
				if ( res.status === 'success' ) {
					toastr.success( `Status changed to ${res.new_status}` );
				} else {
					toastr.error( res.message );
				}
			}, 'json' );
		};

		// ----------------------------
		// 6. Delete record
		// ----------------------------
		$( document ).on( 'click', '.delete', function () {
			let id = $( this ).attr( 'id' );
			if ( confirm( 'Are you sure to delete this record?' ) ) {
				$.post( 'controller/PackageCategoryPriceController.php', {
					id: id,
					action: 'Delete'
				}, function ( res ) {
					if ( res.status === 'success' ) location.reload();
					else toastr.error( res.message );
				}, 'json' );
			}
		} );

	} );
</script>


<?php include('inc/footer.php');?>