<?php include( 'inc/template.php' );?>
	<div class="container-fluid flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="inquiry_list.php">Package List</a></li>
    <li class="breadcrumb-item active"><?php echo isset($_GET['id']) ? 'Update Package' : 'Package Add'; ?></li>
    </ol>
</nav>
	
    <link rel="stylesheet" href="assets/vendor/libs/quill/editor.css" />
		<div class="card mb-4">

			<form class="card-body" method="post" enctype="multipart/form-data">
    <div class="row g-3">
		<input type="hidden" id="package_code" name="package_code"/>
		<div class="col-md-6 position-relative">
  <label class="form-label" for="destination">Destination (State)</label>
  <input type="text" id="destination" name="destination" class="form-control" autocomplete="off" placeholder="Enter state name" required />
  <input type="hidden" id="destination_id" name="destination_id">
  <div id="stateSuggestions" class="list-group position-absolute w-100 bg-white shadow-sm rounded-2" 
       style="z-index:1050; max-height:250px; overflow-y:auto;"></div>
</div>
        <div class="col-md-6">
            <label class="form-label" for="package_name">Package Name</label>
            <input type="text" id="package_name" name="package_name" class="form-control" required />
        </div>

        
        <div class="col-md-2">
            <label class="form-label" for="days">Days</label>
            <input type="number" id="days" name="days" class="form-control" min="1" required />
        </div>

        <div class="col-md-2">
            <label class="form-label" for="nights">Nights</label>
            <input type="number" id="nights" name="nights" class="form-control" min="1" required />
        </div>

       <div class="col-md-3">
  <label class="form-label" for="purchase_price">Purchase Price (₹)</label>
  <input type="number" id="purchase_price" name="purchase_price" class="form-control" min="0" step="0.01"  />
</div>

<div class="col-md-3">
  <label class="form-label" for="sale_price">Sale Price (₹)</label>
  <input type="number" id="sale_price" name="sale_price" class="form-control" min="0" step="0.01"  />
</div>

			<!-- Description -->
			<div class="col-md-12">
			  <label class="form-label">Description</label>
			  <div id="editor_description" class="quill-editor"></div>
			  <input type="hidden" name="description" id="desc_input">
			</div>

			<!-- Inclusions -->
			<div class="col-md-12">
			  <label class="form-label">Inclusions</label>
			  <div id="editor_inclusions" class="quill-editor"></div>
			  <input type="hidden" name="inclusions" id="incl_input">
			</div>

			<!-- Exclusions -->
			<div class="col-md-12">
			  <label class="form-label">Exclusions</label>
			  <div id="editor_exclusions" class="quill-editor"></div>
			  <input type="hidden" name="exclusions" id="excl_input">
			</div>

    </div>

    <div class="pt-4">
        <input type="hidden" id="upd" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>">
        <input type="hidden" name="id" id="id">
        <input type="hidden" name="action" id="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">
        <button type="submit" class="btn btn-primary me-2"><?php echo isset($_GET['id']) ? 'Update' : 'Save'; ?></button>
        <button type="reset" class="btn btn-label-secondary">Cancel</button>
    </div>
</form>



		</div>
	</div>

<!-- Quill JS -->
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
<!--
<script>
  const fullToolbar = [
    [{ font: [] }, { size: [] }],
    ['bold', 'italic', 'underline', 'strike'],
    [{ color: [] }, { background: [] }],
    [{ script: 'super' }, { script: 'sub' }],
    [{ header: '1' }, { header: '2' }, 'blockquote', 'code-block'],
    [{ list: 'ordered' }, { list: 'bullet' }, { indent: '-1' }, { indent: '+1' }],
    [{ direction: 'rtl' }],
    ['link', 'image', 'video', 'formula'],
    ['clean']
  ];

  // Initialize each editor separately
  const editorDescription = new Quill('#editor_description', {
    bounds: '#editor_description',
    placeholder: 'Type Description...',
    modules: { toolbar: fullToolbar },
    theme: 'snow'
  });

  const editorInclusions = new Quill('#editor_inclusions', {
    bounds: '#editor_inclusions',
    placeholder: 'Type Inclusions...',
    modules: { toolbar: fullToolbar },
    theme: 'snow'
  });

  const editorExclusions = new Quill('#editor_exclusions', {
    bounds: '#editor_exclusions',
    placeholder: 'Type Exclusions...',
    modules: { toolbar: fullToolbar },
    theme: 'snow'
  });

  // Sync editor content to hidden fields before submit
  document.getElementById('quotationForm').addEventListener('submit', function () {
    document.getElementById('desc_input').value = editorDescription.root.innerHTML;
    document.getElementById('incl_input').value = editorInclusions.root.innerHTML;
    document.getElementById('excl_input').value = editorExclusions.root.innerHTML;
  });
</script>
-->
<script>
$(document).ready(function () {
    // Initialize Quill Editors
    const quillDesc = new Quill('#editor_description', { theme: 'snow' });
    const quillIncl = new Quill('#editor_inclusions', { theme: 'snow' });
    const quillExcl = new Quill('#editor_exclusions', { theme: 'snow' });

    $('form.card-body').on('submit', function (event) {
        event.preventDefault();

        // Sync Quill content
        $('#desc_input').val(quillDesc.root.innerHTML);
        $('#incl_input').val(quillIncl.root.innerHTML);
        $('#excl_input').val(quillExcl.root.innerHTML);

        let formData = new FormData(this);

        // Basic Validation
        if (!formData.get("package_name") || !formData.get("destination")) {
            toastr.error("All required fields must be filled.");
            return;
        }

        $.ajax({
            url: 'controller/PackagesController.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function (response) {
                if (response.status === 'success') {
                    toastr.success(response.message);
                    setTimeout(() => window.location.href = 'package_list.php', 1500);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function (xhr) {
                toastr.error('An error occurred while submitting the form.');
                console.error('AJAX Error:', xhr.responseText);
            }
        });
    });

    // If updating existing package
    const upd = $('#upd').val();
    if (upd) {
        $.ajax({
            url: 'controller/PackagesController.php',
            type: 'POST',
            data: { id: upd, action: 'Select' },
            dataType: 'json',
            success: function (response) {
                if (response.status === 'success') {
                    let data = response.data;
					 $('#package_code').val(data.package_code);
                    $('#package_name').val(data.package_name);
					 $('#destination_id').val(data.destination_id);
                    $('#destination').val(data.destination);
                    $('#days').val(data.days);
                    $('#nights').val(data.nights);
                    $('#purchase_price').val(data.purchase_price);
                    $('#sale_price').val(data.sale_price);
                    quillDesc.root.innerHTML = data.description || '';
                    quillIncl.root.innerHTML = data.inclusions || '';
                    quillExcl.root.innerHTML = data.exclusions || '';
                    $('#id').val(data.id);
                    $('#action').val('Update');
                } else {
                    toastr.error(response.message);
                }
            },
            error: function () {
                toastr.error('Failed to load package data.');
            }
        });
    }
});

$(document).ready(function() {
    // 🔹 Destination search
  $('#destination').on('input', function() {
      let query = $(this).val();
      if (query.length < 2) {
          $('#stateSuggestions').empty();
          return;
      }

      $.ajax({
          url: 'ajax/state_search.php',
          type: 'GET',
          data: { q: query },
          success: function(res) {
              let states = JSON.parse(res);
              let html = '';
              if (states.length > 0) {
                  states.forEach(state => {
                      html += `<a href="javascript:void(0)" 
                                class="list-group-item list-group-item-action state-item" 
                                data-id="${state.id}" 
                                data-name="${state.state_name}">
                                ${state.state_name}
                              </a>`;
                  });
              } else {
                  html = '<span class="list-group-item">No states found</span>';
              }
              $('#stateSuggestions').html(html);
          }
      });
  });

  // 🔹 When a state is clicked, fill destination + fetch next package code
  $(document).on('click', '.state-item', function() {
      let stateName = $(this).data('name');
      let stateId = $(this).data('id');
      $('#destination').val(stateName);
      $('#destination_id').val(stateId);
      $('#stateSuggestions').empty();

      // ✅ Fetch next package code immediately
      $.ajax({
          url: 'controller/PackagesController.php',
          type: 'POST',
          data: { action: 'getNextPackageCode', destination: stateName },
          dataType: 'json',
          success: function (res) {
              if (res.package_code) {
                  $('#package_code').val(res.package_code);
              } else {
                  $('#package_code').val('');
              }
          },
          error: function () {
              console.error('Failed to fetch next package code');
          }
      });
  });

  // 🔹 Hide suggestion box if clicked outside
  $(document).click(function(e) {
      if (!$(e.target).closest('#destination, #stateSuggestions').length) {
          $('#stateSuggestions').empty();
      }
  });

  // 🔹 Extra: If user types destination manually (no suggestion click)
  $('#destination').on('blur', function() {
      let destination = $(this).val().trim();
      if (destination !== '') {
          $.ajax({
              url: 'controller/PackagesController.php',
              type: 'POST',
              data: { action: 'getNextPackageCode', destination: destination },
              dataType: 'json',
              success: function (res) {
                  if (res.package_code) {
                      $('#package_code').val(res.package_code);
                  } else {
                      $('#package_code').val('');
                  }
              }
          });
      }
  });
});

</script>

<?php include('inc/footer.php');?>