<?php
$pcwId = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch package with categories
$sql = "SELECT p.id AS package_id, p.package_code, p.package_name, p.destination, p.description, p.inclusions, p.exclusions, p.days, p.nights, p.sale_price AS package_sale_price, p.purchase_price AS package_purchase_price, p.destination_id,ccp.category_id,ccp.purchase_price AS category_purchase_price, ccp.sale_price AS category_sale_price, cat.category_name, ccp.status AS category_status, ccp.created_at AS category_created_at FROM packages p LEFT JOIN package_category_prices ccp ON p.id = ccp.package_id LEFT JOIN package_categories cat ON ccp.category_id = cat.id WHERE p.status = 'active' AND ccp.id = $pcwId";

$result = $conn->query($sql);
$package = ($result->num_rows > 0) ? $result->fetch_assoc() : null;
$package_id = $package['package_id'];
$category_id = $package['category_id'];
$destination_id = $package['destination_id'];


// Page titles
$current_page = basename($_SERVER['PHP_SELF']); 
$page_titles = [
    'package_categorywise_overview.php' => 'Package Category Wise Overview',
    'package_categorywise_hotel.php'   => 'Package Hotel',
    'hotel_photo.php'                  => 'Hotel Photos',
    'hotel_bookings.php'               => 'Bookings'
];
$current_title = $page_titles[$current_page] ?? 'Hotel Overview';
?>
<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb breadcrumb-custom-icon">
      <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
      <li class="breadcrumb-item"><a href="hotel_list.php">Package Category wise List</a></li>
      <li class="breadcrumb-item active"><?php echo $current_title; ?></li>
  </ol>
</nav>

<!-- Nav Pills -->
<div class="row">
  <div class="col-xl-12 col-lg-12 col-md-12 order-0 order-md-1">
    <div class="nav-align-top">
      <div class="nav-scroller">
        <ul class="nav nav-pills flex-nowrap mb-6 row-gap-2">
          <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'package_categorywise_overview.php') ? 'active' : ''; ?>" 
               href="package_categorywise_overview.php?id=<?php echo $pcwId; ?>">
              <i class="ti ti-packages ti-sm me-1_5"></i> Overview
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'package_categorywise_hotel.php') ? 'active' : ''; ?>" 
               href="package_categorywise_hotel.php?id=<?php echo $pcwId; ?>">
              <i class="ti ti-building-skyscraper ti-sm me-1_5"></i>Package Hotel
            </a>
          </li>
          
        </ul>
      </div>
    </div>
  </div>
</div>

<style>
.nav-scroller {
  overflow-x: auto;
  white-space: nowrap;
}
.nav-scroller .nav {
  flex-wrap: nowrap;
}
</style>
