<?php include('inc/template.php');?>
<div class="container-fluid flex-grow-1 container-p-y">
	<?php include('package_booking_header.php');?>
        <div class="row mb-4">
                <!--  Modal -->
        <!-- Payment Modal -->
<div class="modal fade" id="basicModal" tabindex="-1" aria-labelledby="basicModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="paymentForm">
        <div class="modal-header">
          <h5 class="modal-title">Payment</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <div class="row">
            <div class="col mb-3">
              <label class="form-label">Payment Mode</label>
              <select name="payment_mode" id="payment_mode" class="form-select" required>
                <option value="cash">Cash</option>
                <option value="upi">UPI</option>
                <option value="bank">Bank</option>
                <option value="card">Card</option>
                <option value="online">Online</option>
              </select>
            </div>
          </div>

          <div class="row">
            <div class="col-6 mb-3">
              <label class="form-label">Total Amount</label>
              <input type="number" id="totalAmount" name="total" class="form-control" 
                     value="<?= htmlspecialchars($due_total ?? 0); ?>" readonly />
            </div>
            <div class="col-6 mb-3">
              <label class="form-label">Received</label>
              <input type="number" name="received" class="form-control" required />
            </div>
          </div>

          <!-- Dynamic Payment Details -->
          <div class="row">
            <!-- UPI -->
            <div class="col-md-6 mb-3" id="upi_details_group" style="display:none;">
              <label for="upi_id" class="form-label">UPI ID</label>
              <input type="text" name="upi_id" id="upi_id" class="form-control" placeholder="e.g. username@upi">
            </div>

            <!-- Bank Name -->
            <div class="col-md-6 mb-3" id="bank_details_group" style="display:none;">
              <label for="bank_name" class="form-label">Bank Name</label>
              <input type="text" name="bank_name" id="bank_name" class="form-control" placeholder="Bank Name">
            </div>

            <!-- Account / Cheque No -->
            <div class="col-md-6 mb-3" id="account_no_group" style="display:none;">
              <label for="account_no" class="form-label">Account / Cheque No</label>
              <input type="text" name="account_no" id="account_no" class="form-control" placeholder="Account or Cheque Number">
            </div>

            <!-- Transaction ID -->
            <div class="col-md-6 mb-3" id="transaction_id_group" style="display:none;">
              <label for="transaction_id" class="form-label">Transaction / Reference ID</label>
              <input type="text" name="transaction_id" id="transaction_id" class="form-control" placeholder="Transaction ID">
            </div>
          </div>

          <!-- Remarks -->
          <div class="row">
            <div class="col mb-3">
              <label class="form-label">Remarks</label>
              <textarea name="remarks" class="form-control"></textarea>
            </div>
          </div>

          <!-- Hidden Fields -->
          <input type="hidden" name="useridnew" id="useridnew" value="<?= $userId; ?>" />
          <input type="hidden" name="booking_id" id="booking_id" value="<?= htmlspecialchars($book_id ?? ''); ?>" />
		  <input type="hidden" name="payment_id" id="payment_id" value="" />
          <input type="hidden" name="customer_id" id="customerId" value="<?= htmlspecialchars($row['customer_id'] ?? ''); ?>" />
          <input type="hidden" name="gst_included" id="gstIncluded" value="<?= htmlspecialchars($row['gst_included'] ?? ''); ?>" />
        </div>

        <div class="modal-footer">
          <input type="hidden" name="action" value="save">
          <button type="submit" class="btn btn-primary">Save</button>
          <button type="button" class="btn btn-primary" id="download-pdf">Save & PDF</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </form>
    </div>
  </div>
</div>



        <!-- Users Table -->
        <div class="col-xl-12 col-lg-6 col-md-6">
            <div class="card">
				
                <div class="card-datatable table-responsive pt-0"><button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#basicModal">
        <span class="ti-xs ti ti-plus me-1"></span> Add New Payment
    </button>
					
					<table class="datatables-ajax table table-bordered table-responsive">
    <thead>
        <tr>
            <th>Date</th>
		    <th>Mode</th>
            <th>Amount</th>
            <th>Reference / Details</th>
            <th>Status</th>
            <th>Received By</th>
			<th>Action</th>
        </tr>
    </thead>
    <tbody>
    <?php if ($payment_result->num_rows > 0): ?>
        <?php while ($p = $payment_result->fetch_assoc()): ?>
            <tr>
                <td><?= date('d-m-Y h:i A', strtotime($p['payment_date'])) ?></td>
                <td class="text-capitalize"><?= htmlspecialchars($p['mode']) ?></td>
                <td>₹ <?= number_format($p['amount'], 2) ?></td>
                <td>
                    <?php
                    switch ($p['mode']) {
                        case 'cash':
                            echo "Receipt No: " . htmlspecialchars($p['receipt_no']);
                            break;

                        case 'card':
                            echo "Card Txn ID: " . htmlspecialchars($p['transaction_id']) . "<br>";
                            echo "Bank: " . htmlspecialchars($p['bank_name']);
                            break;

                        case 'upi':
                            echo "UPI ID: " . htmlspecialchars($p['upi_id']) . "<br>";
                            echo "Txn ID: " . htmlspecialchars($p['transaction_id']);
                            break;

                        case 'bank':
                            echo "Bank: " . htmlspecialchars($p['bank_name']) . "<br>";
                            echo "A/c No: " . htmlspecialchars($p['account_no']) . "<br>";
                            //echo "Ref No: " . htmlspecialchars($p['reference_no']);
                            break;

                        case 'online':
                            echo "Txn ID: " . htmlspecialchars($p['transaction_id']) . "<br>";
                            //echo "Ref No: " . htmlspecialchars($p['reference_no']);
                            break;

                        default:
                            echo "N/A";
                    }

                    if (!empty($p['narration'])) {
                        echo "<br><small class='text-muted'>Note: " . htmlspecialchars($p['narration']) . "</small>";
                    }
                    ?>
                </td>
                <td>
                    <?php
                    $statusClass = match(strtolower($p['status'])) {
                        'completed' => 'bg-success',
                        'pending'   => 'bg-warning',
                        'failed'    => 'bg-danger',
                        'cancelled' => 'bg-secondary',
                        default     => 'bg-info'
                    };
                    ?>
                    <span class="badge <?= $statusClass ?>"><?= ucfirst($p['status']) ?></span>
                </td>
                <td><?= htmlspecialchars($p['received_by_name'] ?? 'Admin') ?></td>
				<td>
    <div class="btn-group" role="group">
        
        <!-- Edit -->
        <button type="button" 
            class="btn btn-sm btn-warning update" 
            data-id="<?= $p['id']; ?>" 
            title="Edit Payment">
            <i class="ti ti-pencil"></i>
        </button>

        <!-- Delete -->
        <button type="button" 
            class="btn btn-sm btn-danger delete" 
            data-id="<?= $p['id']; ?>" 
            title="Delete Payment">
            <i class="ti ti-trash"></i>
        </button>

        <!-- Download PDF -->
        <button type="button" 
            class="btn btn-sm btn-secondary download" 
            data-id="<?= $p['id']; ?>" 
            title="Download Receipt">
            <i class="ti ti-download"></i>
        </button>
    </div>
</td>

            </tr>
        <?php endwhile; ?>
    <?php else: ?>
        <tr><td colspan="6" class="text-center">No payments found for this booking.</td></tr>
    <?php endif; ?>
    </tbody>
</table>

                    





                </div>
            </div>
        </div>
    </div>
</div>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
<script>
$(document).ready(function () {
//  Show/Hide Mode Fields
  $('#payment_mode').on('change', function () {
  const mode = $(this).val();

  // Hide all optional input groups
  $('#upi_details_group, #bank_details_group, #account_no_group, #transaction_id_group').hide();

  // Remove required attribute from all
  $('#upi_id, #bank_name, #account_no, #transaction_id').prop('required', false);

  // --- UPI Mode ---
  if (mode === 'upi') {
    $('#upi_details_group, #transaction_id_group').show();
    $('#upi_id, #transaction_id').prop('required', true);
  }

  // --- Bank Mode ---
  else if (mode === 'bank') {
    $('#bank_details_group, #account_no_group, #transaction_id_group').show();
    $('#bank_name, #account_no, #transaction_id').prop('required', true);
  }

  // --- Card Mode ---
  else if (mode === 'card') {
    $('#bank_details_group, #transaction_id_group').show();
    $('#bank_name, #transaction_id').prop('required', true);
  }

  // --- Online Mode ---
  else if (mode === 'online') {
    $('#transaction_id_group').show();
    $('#transaction_id').prop('required', true);
  }

  // --- Cash Mode ---
  else {
    // Nothing extra needed for cash
  }
});
    // Show modal for Create
    $('#modal_button').click(function () {
    $('#paymentForm')[0].reset();
    $('#action').val('Create');
    $('#id').val('');
    $('.modal-title').text("Create New Payment");
    $('#basicModal').modal('show');
});


  
// Load payment for update
  $(document).on('click', '.update', function () {
    const id = $(this).data("id");
    $.post("controller/PaymentController.php", { id: id, action: 'Select' }, function (data) {
      if (data && data.id) {
        $('#payment_mode').val(data.mode).trigger('change');
		$('#payment_id').val(data.id);
        $('#totalAmount').val(data.total || 0);
        $('input[name="received"]').val(data.amount);
        $('input[name="upi_id"]').val(data.upi_id);
        $('input[name="account_no"]').val(data.account_no);
        $('input[name="bank_name"]').val(data.bank_name);
		$('input[name="transaction_id"]').val(data.transaction_id);
        $('textarea[name="remarks"]').val(data.narration);
        $('#booking_id').val(data.booking_id);
        $('#customerId').val(data.customer_id);
        $('.modal-title').text("Update Payment");
        $('#basicModal').modal('show');
      } else {
        Swal.fire('Not Found', 'No data found for this payment ID.', 'warning');
      }
    }, 'json');
  });



// Delete action
$(document).on('click', '.delete', function () {
    const id = $(this).data("id"); // Use data-id instead of id
    const row = $(this).closest('tr');

    if (confirm('Are you sure you want to delete this payment record?')) { // Update text to reflect correct action
        $.ajax({
            url: 'controller/PaymentController.php',
            method: 'POST',
            data: { id: id, action: 'Delete' },
            dataType: "json",
            success: function (response) {
                if (response.status === 'success') {
                    toastr.success(response.message);
                    row.css('background-color', '#f8d7da').fadeOut(800, function () {
                        $(this).remove();
                    });
                } else {
                    toastr.error(response.message);
                }
            },
            error: function () {
                toastr.error('Error deleting payment record.');
            }
        });
    }
});

let generatePDF = false;

$('#download-pdf').on('click', function (e) {
    e.preventDefault();
    generatePDF = true;
    $('#paymentForm').submit(); // trigger form submission
});

    // Submit form for Create or Update
    $('#paymentForm').on('submit', function (e) {
    e.preventDefault();
    $('#basicModal').modal('hide');

    Swal.fire({
        title: 'Confirm Save',
        text: "Save this payment record?",
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Yes, Save it'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "controller/PaymentController.php",
                method: "POST",
                data: $(this).serialize(),
                dataType: "json",
                success: function (response) {
                    if (response.status === 'success') {
                        if (generatePDF) {
                            window.open('controller/DownlaodPaymentController.php?payment_id=' + response.payment_id, '_blank');
                        }
                        Swal.fire('Success', response.message, 'success');
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        Swal.fire('Error', response.message, 'error');
                    }
                },
                error: function () {
                    Swal.fire('Error', 'Server error occurred.', 'error');
                }
            });
        }
    });
});




    // Download PDF
    $('.download').on('click', function() {
        const id = $(this).data('id');
        window.open('controller/DownlaodPaymentController.php?payment_id=' + id, '_blank');
    });


});
</script>


<?php include('inc/footer.php');?>