<?php include('inc/template.php'); ?>

<div class="container-fluid flex-grow-1 container-p-y">

  <!-- Ã°Å¸Â§Â­ Breadcrumb -->
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.php">Home</a></li>
      <li class="breadcrumb-item"><a href="hotel_booking_add.php">Hotel Booking Add</a></li>
      <li class="breadcrumb-item active">Hotel Booking List</li>
    </ol>
  </nav>

  <!-- Ã°Å¸Â§Â¾ Booking List Card -->
  <div class="card">
    <div class="card-datatable table-responsive pt-0">
      <table id="hotelBookingTable" class="table table-bordered">
        <thead>
          <tr>
            <th>Invoice Date</th>
            <th>Invoice No</th>
            <th>Name</th>
            <th>Mobile</th>
            <th>Hotel Name</th>
			<th>City</th>
			<th>Checkin/Checkout</th>
            <th>Total Amount</th>
            <th>Due Amount</th>
            <th>Payment Status</th>
            <th>Action</th>
          </tr>
        </thead>
		  <tbody>
		</tbody>
		  <tfoot>
			  </tfoot>
      </table>
    </div>
  </div>

   <!-- Add Payment Modal -->
<div class="modal fade" id="statusChangeModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="paymentForm">
        <div class="modal-header">
          <h5 class="modal-title">Add Payment</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">

          <!-- Payment Mode -->
          <div class="row">
            <div class="col mb-3">
              <label class="form-label">Payment Mode</label>
              <select name="payment_mode" id="payment_mode" class="form-select" required>
                <option value="">Select Mode</option>
                <option value="cash">Cash</option>
                <option value="upi">UPI</option>
                <option value="bank">Bank Transfer</option>
                <option value="card">Card</option>
                <option value="online">Online</option>
              </select>
            </div>
          </div>

          <!-- Amount Fields -->
          <div class="row">
            
            <div class="col-6 mb-3">
              <label class="form-label">Due Amount</label>
			<input type="hidden" id="totalAmount" class="form-control" readonly />
              <input type="number" id="balance_amount" class="form-control" readonly />
            </div>
			  <div class="col-6 mb-3">
              <label class="form-label">Received Amount</label>
              <input type="number" name="amount" id="receivedAmount" class="form-control" required />
            </div>
          </div>


          <!-- UPI -->
          <div class="row">
            <div class="col-md-6 mb-3" id="upi_details_group" style="display:none;">
              <label for="upi_id" class="form-label">UPI ID</label>
              <input type="text" name="upi_id" id="upi_id" class="form-control" placeholder="e.g. username@upi">
            </div>

            <!-- Bank Details -->
            <div class="col-md-6 mb-3" id="bank_details_group" style="display:none;">
              <label for="bank_name" class="form-label">Bank Name</label>
              <input type="text" name="bank_name" id="bank_name" class="form-control" placeholder="Bank Name">
            </div>

            <div class="col-md-6 mb-3" id="account_no_group" style="display:none;">
              <label for="account_no" class="form-label">Account / Cheque No</label>
              <input type="text" name="account_no" id="account_no" class="form-control" placeholder="Account or Cheque Number">
            </div>

            <div class="col-md-6 mb-3" id="transaction_id_group" style="display:none;">
              <label for="transaction_id" class="form-label">Transaction / Reference ID</label>
              <input type="text" name="transaction_id" id="transaction_id" class="form-control" placeholder="Transaction ID">
            </div>
          </div>

          <!-- Remarks -->
          <div class="row">
            <div class="col mb-3">
              <label class="form-label">Remarks</label>
              <textarea name="narration" class="form-control" rows="2"></textarea>
            </div>
          </div>

          <!-- Hidden Inputs -->
          <input type="hidden" name="booking_id" id="bookingId" />
          <input type="hidden" name="customer_id" id="customerId" />
          <input type="hidden" name="received_by" value="<?php echo $userId; ?>" />
          <input type="hidden" name="payment_type" value="received" />
          <input type="hidden" name="action" value="savepayment" />
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" id="save-only">Save</button>
          <button type="submit" class="btn btn-success" id="download-pdf">Save & PDF</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </form>
    </div>
  </div>
</div>


</div>

<script>
let isPdf = false;

$(document).ready(function () {

  // ==============================
  // ðŸ”¹ PAYMENT MODE HANDLER
  // ==============================
  $('#payment_mode').on('change', function () {
    const mode = $(this).val();

    // Hide all optional input groups
    $('#upi_details_group, #bank_details_group, #account_no_group, #transaction_id_group').hide();

    // Remove required attributes
    $('#upi_id, #bank_name, #account_no, #transaction_id').prop('required', false);

    // --- UPI Mode ---
    if (mode === 'upi') {
      $('#upi_details_group, #transaction_id_group').show();
      $('#upi_id, #transaction_id').prop('required', true);
    }
    // --- Bank Mode ---
    else if (mode === 'bank') {
      $('#bank_details_group, #account_no_group, #transaction_id_group').show();
      $('#bank_name, #account_no, #transaction_id').prop('required', true);
    }
    // --- Card Mode ---
    else if (mode === 'card') {
      $('#bank_details_group, #transaction_id_group').show();
      $('#bank_name, #transaction_id').prop('required', true);
    }
    // --- Online Mode ---
    else if (mode === 'online') {
      $('#transaction_id_group').show();
      $('#transaction_id').prop('required', true);
    }
    // --- Cash Mode ---
    else {
      // No extra fields
    }
  });

  // ==============================
  // ðŸ”¹ OPEN PAYMENT MODAL
  // ==============================
  $(document).on('click', '.changeStatusBtn', function () {
    const id = $(this).data('id');
    const customerId = $(this).data('customer_id');
    const totalAmount = $(this).data('total_amount');
    const balanceAmount = $(this).data('balance_amount');

    $('#bookingId').val(id);
    $('#customerId').val(customerId);
    $('#totalAmount').val(totalAmount);
    $('#balance_amount').val(balanceAmount);

    $('#payment_mode').val('cash');
    $('#receivedAmount').val('');
    $('#upi_details_group, #bank_details_group, #account_no_group, #transaction_id_group').hide();

    $('.modal-title').text('Add Payment â€” Balance: â‚¹' + balanceAmount);
    $('#statusChangeModal').modal('show');
  });

  // ==============================
  // ðŸ”¹ BUTTON ACTION TYPE
  // ==============================
  $('#download-pdf').on('click', function () { isPdf = true; });
  $('#save-only').on('click', function () { isPdf = false; });

  // ==============================
  // ðŸ”¹ PAYMENT FORM SUBMIT
  // ==============================
  $('#paymentForm').on('submit', function (e) {
    e.preventDefault();
	$('#statusChangeModal').modal('hide');

    const total = parseFloat($('#totalAmount').val()) || 0;
    const balance = parseFloat($('#balance_amount').val()) || 0;
    const received = parseFloat($('#receivedAmount').val()) || 0;
    const mode = $('#payment_mode').val();

    // --- VALIDATION ---
    if (!mode) {
      Swal.fire('Select Payment Mode', 'Please choose a valid payment mode.', 'warning');
      return;
    }
    if (received <= 0) {
      Swal.fire('Invalid Amount', 'Enter a valid payment amount.', 'warning');
      return;
    }
    if (received > balance) {
      Swal.fire('Warning', 'Received amount cannot be greater than balance amount.', 'warning');
      return;
    }

    const formData = $(this).serialize();

    // Disable submit buttons during process
    $('#save-only, #download-pdf').prop('disabled', true).text('Processing...');

    $.ajax({
      url: 'controller/HotelBookingController.php',
      type: 'POST',
      data: formData,
      dataType: 'json',
      success: function (response) {
        $('#save-only, #download-pdf').prop('disabled', false).text('Save');
        if (response.status === 'success') {
          Swal.fire('Success', response.message, 'success').then(() => {
            if (isPdf && response.payment_id) {
              window.open('controller/DownloadPaymentController.php?payment_id=' + response.payment_id, '_blank');
            }
            $('#statusChangeModal').modal('hide');
            $('#paymentForm')[0].reset();
            $('#hotelBookingTable').DataTable().ajax.reload(null, false);
          });
        } else {
          Swal.fire('Error', response.message, 'error');
        }
      },
      error: function () {
        $('#save-only, #download-pdf').prop('disabled', false).text('Save');
        Swal.fire('Error', 'Unable to process request.', 'error');
      }
    });
  });

  // ==============================
  // ðŸ”¹ INITIALIZE DATATABLE
  // ==============================
  const table = $('#hotelBookingTable').DataTable({
    processing: true,
    serverSide: true,
    ajax: {
      url: 'controller/HotelBookingController.php',
      type: 'POST',
      data: { action: 'fetch' }
    },
    columns: [
      { data: 'booking_date' },
      { data: 'booking_code' },
      { data: 'customer_name' },
      { data: 'customer_phone' },
      { data: 'hotel_name' },
      { data: 'hotel_city' },
      { data: 'checkin_checkout' },
      { data: 'total_amount' },
      { data: 'due_amount' },
      { data: 'payment_status' },
      { data: 'action', orderable: false, searchable: false }
    ],
    order: [[0, 'desc']],
    pageLength: 25,
    language: {
      processing: '<i class="fa fa-spinner fa-spin"></i> Loading records...'
    }
  });

  // ==============================
  // ðŸ”¹ DELETE BOOKING
  // ==============================
  $(document).on('click', '.delete', function () {
    const id = $(this).attr('id');
    Swal.fire({
      title: 'Are you sure?',
      text: 'This booking will be permanently deleted!',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, Delete!'
    }).then(result => {
      if (result.isConfirmed) {
        $.ajax({
          url: 'controller/HotelBookingController.php',
          method: 'POST',
          data: { id: id, action: 'Delete' },
          dataType: 'json',
          success: function (response) {
            if (response.status === 'Delete') {
              toastr.success(response.message);
              table.ajax.reload(null, false);
            } else {
              toastr.error(response.message);
            }
          },
          error: function () {
            toastr.error('Error deleting record.');
          }
        });
      }
    });
  });

  // ==============================
  // ðŸ”¹ DOWNLOAD BOOKING PDF
  // ==============================
  $(document).on('click', '.download', function () {
    const id = $(this).data('id');
    window.open('controller/DownloadPDFHotelBookingController.php?id=' + id, '_blank');
  });

});
</script>

<?php include('inc/footer.php');?>